/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.navigation.ui.swt.component;

import org.eclipse.core.runtime.Assert;
import org.eclipse.equinox.log.Logger;
import org.eclipse.riena.core.IRienaActivator;
import org.eclipse.riena.core.Log4r;
import org.eclipse.riena.internal.navigation.ui.swt.Activator;
import org.eclipse.riena.navigation.ui.swt.lnf.renderer.ShellLogoRenderer;
import org.eclipse.riena.ui.swt.lnf.LnfManager;
import org.eclipse.riena.ui.swt.utils.ImageStore;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;

public class LogoComposite
extends Composite {
    private static final Logger LOGGER = Log4r.getLogger((IRienaActivator)Activator.getDefault(), LogoComposite.class);

    public LogoComposite(Composite parent, int style) {
        super(parent, style | 0x20000000);
        this.init(parent);
    }

    private void init(Composite parent) {
        Assert.isTrue((boolean)(parent.getLayout() instanceof FormLayout));
        FormData logoData = new FormData();
        int topInset = 0;
        int leftRightInset = 0;
        logoData.top = new FormAttachment(0, topInset);
        int height = this.getSwitchterTopMargin() + this.getSwitchterHeight() - 1;
        logoData.bottom = new FormAttachment(0, height + 2);
        Image logoImage = this.getLogoImage();
        if (logoImage == null) {
            return;
        }
        Rectangle imageBounds = logoImage.getBounds();
        if (imageBounds == null) {
            return;
        }
        logoData.width = imageBounds.width + ShellLogoRenderer.getHorizontalLogoMargin() * 2;
        Integer hPos = this.getHorizontalLogoPosition();
        switch (hPos) {
            case 0x1000000: {
                logoData.left = new FormAttachment(50, -logoData.width / 2);
                break;
            }
            case 131072: {
                logoData.right = new FormAttachment(100, -leftRightInset);
                break;
            }
            default: {
                logoData.left = new FormAttachment(0, leftRightInset);
            }
        }
        this.setLayoutData(logoData);
        this.addPaintListener(new LogoPaintListener());
    }

    private Image getLogoImage() {
        Image logoImage = LnfManager.getLnf().getImage("TitlelessShell.logo");
        if (logoImage == null) {
            String message = "The image of the logo wasn't found! A dummy image is used.";
            LOGGER.log(2, message);
            logoImage = ImageStore.getInstance().getMissingImage();
        }
        return logoImage;
    }

    private int getHorizontalLogoPosition() {
        Integer hPos = LnfManager.getLnf().getIntegerSetting("TitlelessShell.horizontalLogoPosition");
        if (hPos == null) {
            hPos = 16384;
        }
        return hPos;
    }

    private int getSwitchterTopMargin() {
        int margin = LnfManager.getLnf().getIntegerSetting("SubApplicationSwitcher.topMargin");
        return margin;
    }

    private int getSwitchterHeight() {
        int margin = LnfManager.getLnf().getIntegerSetting("SubApplicationSwitcher.height");
        return margin;
    }

    private static class LogoPaintListener
    implements PaintListener {
        private LogoPaintListener() {
        }

        public void paintControl(PaintEvent e) {
            this.onPaint(e);
        }

        private void onPaint(PaintEvent e) {
            Composite logoComposite = (Composite)e.getSource();
            Rectangle compositeBounds = logoComposite.getBounds();
            ShellLogoRenderer renderer = (ShellLogoRenderer)LnfManager.getLnf().getRenderer("TitlelessShell.logoRenderer");
            renderer.setBounds(compositeBounds);
            renderer.paint(e.gc, null);
        }
    }
}

