/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.navigation.ui.swt.views;

import java.io.IOException;
import org.eclipse.equinox.log.Logger;
import org.eclipse.jface.bindings.Scheme;
import org.eclipse.riena.core.IRienaActivator;
import org.eclipse.riena.core.Log4r;
import org.eclipse.riena.core.exception.IExceptionHandlerManager;
import org.eclipse.riena.core.service.Service;
import org.eclipse.riena.core.wire.Wire;
import org.eclipse.riena.internal.navigation.ui.swt.Activator;
import org.eclipse.riena.internal.navigation.ui.swt.IAdvisorHelper;
import org.eclipse.riena.navigation.ui.controllers.ApplicationController;
import org.eclipse.riena.navigation.ui.swt.presentation.stack.TitlelessStackPresentationFactory;
import org.eclipse.riena.navigation.ui.swt.views.ApplicationViewAdvisor;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.application.IWorkbenchWindowConfigurer;
import org.eclipse.ui.application.WorkbenchAdvisor;
import org.eclipse.ui.application.WorkbenchWindowAdvisor;
import org.eclipse.ui.keys.IBindingService;
import org.eclipse.ui.presentations.AbstractPresentationFactory;
import org.eclipse.ui.statushandlers.AbstractStatusHandler;
import org.eclipse.ui.statushandlers.StatusAdapter;

public class ApplicationAdvisor
extends WorkbenchAdvisor {
    private final ApplicationController controller;
    private final IAdvisorHelper advisorHelper;

    public ApplicationAdvisor(ApplicationController controller, IAdvisorHelper factory) {
        this.controller = controller;
        this.advisorHelper = factory;
    }

    public WorkbenchWindowAdvisor createWorkbenchWindowAdvisor(IWorkbenchWindowConfigurer configurer) {
        configurer.setPresentationFactory((AbstractPresentationFactory)new TitlelessStackPresentationFactory());
        ApplicationViewAdvisor workbenchWindowAdvisor = new ApplicationViewAdvisor(configurer, this.controller, this.advisorHelper);
        Wire.instance((Object)((Object)workbenchWindowAdvisor)).andStart(Activator.getDefault().getContext());
        return workbenchWindowAdvisor;
    }

    public String getInitialWindowPerspectiveId() {
        return null;
    }

    public synchronized AbstractStatusHandler getWorkbenchErrorHandler() {
        return new AbstractStatusHandler(){

            public void handle(StatusAdapter statusAdapter, int style) {
                ((IExceptionHandlerManager)Service.get(IExceptionHandlerManager.class)).handleException(statusAdapter.getStatus().getException(), statusAdapter.getStatus().getMessage());
            }
        };
    }

    public void postStartup() {
        this.installDefaultBinding();
    }

    private void installDefaultBinding() {
        IBindingService bindingService = (IBindingService)PlatformUI.getWorkbench().getService(IBindingService.class);
        String scheme = this.advisorHelper.getKeyScheme();
        Scheme rienaScheme = bindingService.getScheme(scheme);
        try {
            bindingService.savePreferences(rienaScheme, bindingService.getBindings());
        }
        catch (IOException ioe) {
            Logger logger = Log4r.getLogger((IRienaActivator)Activator.getDefault(), ((Object)((Object)this)).getClass());
            logger.log(1, "Could not activate scheme: " + scheme, (Throwable)ioe);
        }
    }
}

