/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.navigation.ui.swt.views;

import org.eclipse.core.runtime.Assert;
import org.eclipse.equinox.log.Logger;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.riena.core.IRienaActivator;
import org.eclipse.riena.core.Log4r;
import org.eclipse.riena.core.wire.InjectExtension;
import org.eclipse.riena.internal.navigation.ui.swt.Activator;
import org.eclipse.riena.internal.navigation.ui.swt.CoolbarUtils;
import org.eclipse.riena.internal.navigation.ui.swt.IAdvisorHelper;
import org.eclipse.riena.internal.navigation.ui.swt.RestoreFocusOnEscListener;
import org.eclipse.riena.navigation.IApplicationNode;
import org.eclipse.riena.navigation.INavigationNode;
import org.eclipse.riena.navigation.ISubApplicationNode;
import org.eclipse.riena.navigation.listener.ApplicationNodeListener;
import org.eclipse.riena.navigation.listener.IApplicationNodeListener;
import org.eclipse.riena.navigation.listener.ISubApplicationNodeListener;
import org.eclipse.riena.navigation.listener.NavigationTreeObserver;
import org.eclipse.riena.navigation.listener.SubApplicationNodeListener;
import org.eclipse.riena.navigation.model.ApplicationNode;
import org.eclipse.riena.navigation.ui.controllers.ApplicationController;
import org.eclipse.riena.navigation.ui.swt.binding.InjectSwtViewBindingDelegate;
import org.eclipse.riena.navigation.ui.swt.component.MenuCoolBarComposite;
import org.eclipse.riena.navigation.ui.swt.component.TitleComposite;
import org.eclipse.riena.navigation.ui.swt.lnf.renderer.EmbeddedBorderRenderer;
import org.eclipse.riena.navigation.ui.swt.lnf.renderer.ModuleGroupRenderer;
import org.eclipse.riena.navigation.ui.swt.lnf.renderer.ShellBorderRenderer;
import org.eclipse.riena.navigation.ui.swt.lnf.renderer.ShellRenderer;
import org.eclipse.riena.navigation.ui.swt.presentation.SwtViewProvider;
import org.eclipse.riena.navigation.ui.swt.presentation.stack.TitlelessStackPresentation;
import org.eclipse.riena.navigation.ui.swt.statusline.IStatuslineContentFactoryExtension;
import org.eclipse.riena.navigation.ui.swt.views.GrabCorner;
import org.eclipse.riena.navigation.ui.swt.views.NavigationViewPart;
import org.eclipse.riena.navigation.ui.swt.views.UIViewFailure;
import org.eclipse.riena.ui.filter.IUIFilter;
import org.eclipse.riena.ui.ridgets.controller.IController;
import org.eclipse.riena.ui.ridgets.swt.uibinding.AbstractViewBindingDelegate;
import org.eclipse.riena.ui.swt.DefaultStatuslineContentFactory;
import org.eclipse.riena.ui.swt.IStatusLineContentFactory;
import org.eclipse.riena.ui.swt.Statusline;
import org.eclipse.riena.ui.swt.StatuslineSpacer;
import org.eclipse.riena.ui.swt.lnf.ILnfRenderer;
import org.eclipse.riena.ui.swt.lnf.LnfManager;
import org.eclipse.riena.ui.swt.lnf.rienadefault.RienaDefaultLnf;
import org.eclipse.riena.ui.swt.utils.ImageStore;
import org.eclipse.riena.ui.swt.utils.TestingSupport;
import org.eclipse.riena.ui.swt.utils.WidgetIdentificationSupport;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.CoolBar;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveRegistry;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.application.ActionBarAdvisor;
import org.eclipse.ui.application.IActionBarConfigurer;
import org.eclipse.ui.application.IWorkbenchWindowConfigurer;
import org.eclipse.ui.application.WorkbenchWindowAdvisor;
import org.eclipse.ui.internal.WorkbenchWindow;

public class ApplicationViewAdvisor
extends WorkbenchWindowAdvisor {
    private static final Logger LOGGER = Log4r.getLogger((IRienaActivator)Activator.getDefault(), ApplicationViewAdvisor.class);
    private static final String PROPERTY_RIENA_APPLICATION_WIDTH = "riena.application.width";
    private static final String PROPERTY_RIENA_APPLICATION_HEIGHT = "riena.application.height";
    private static final Point APPLICATION_MIN_SIZE = new Point(800, 600);
    private static final int DEFAULT_COOLBAR_TOP_MARGIN = 2;
    public static final String SHELL_RIDGET_PROPERTY = "applicationWindow";
    private final ApplicationController controller;
    private final AbstractViewBindingDelegate binding;
    private final IAdvisorHelper advisorHelper;
    private TitleComposite titleComposite;
    private IStatusLineContentFactory statuslineContentFactory;

    public ApplicationViewAdvisor(IWorkbenchWindowConfigurer configurer, ApplicationController pController, IAdvisorHelper helper) {
        super(configurer);
        this.controller = pController;
        this.binding = this.createBinding();
        this.advisorHelper = helper;
        this.initializeListener();
    }

    public void addUIControl(Composite control, String propertyName) {
        this.binding.addUIControl((Object)control, propertyName);
    }

    @InjectExtension
    public void bindStatuslineContentFactory(IStatuslineContentFactoryExtension[] statuslineContentFactoryExtensions) {
        if (statuslineContentFactoryExtensions.length > 0) {
            this.statuslineContentFactory = statuslineContentFactoryExtensions[0].createFactory();
        }
    }

    public final ActionBarAdvisor createActionBarAdvisor(IActionBarConfigurer configurer) {
        return this.advisorHelper.createActionBarAdvisor(configurer);
    }

    public void createWindowContents(Shell shell) {
        this.initShell(shell);
        shell.setLayout((Layout)new FormLayout());
        GrabCorner grabCorner = this.createGrabCorner(shell);
        this.createStatusLine((Composite)shell, grabCorner);
        this.titleComposite = this.createTitleComposite(shell);
        Composite menuBarComposite = this.createMenuBarComposite((Composite)shell, this.titleComposite);
        Composite coolBarComposite = this.createCoolBarComposite((Composite)shell, menuBarComposite);
        this.createMainComposite((Composite)shell, coolBarComposite);
        RestoreFocusOnEscListener focusListener = new RestoreFocusOnEscListener(shell);
        focusListener.addControl(RestoreFocusOnEscListener.findCoolBar(menuBarComposite));
        focusListener.addControl(RestoreFocusOnEscListener.findCoolBar(coolBarComposite));
    }

    public void dispose() {
        super.dispose();
        if (this.titleComposite != null) {
            this.titleComposite.dispose();
            this.titleComposite = null;
        }
    }

    public void preWindowOpen() {
        this.configureWindow();
    }

    public void postWindowOpen() {
        super.postWindowOpen();
        this.doInitialBinding();
        if (this.titleComposite != null) {
            this.titleComposite.setRedraw(false);
            this.titleComposite.setRedraw(true);
        }
    }

    protected AbstractViewBindingDelegate createBinding() {
        return new InjectSwtViewBindingDelegate();
    }

    private void initializeListener() {
        MySubApplicationNodeListener subApplicationListener = new MySubApplicationNodeListener();
        NavigationTreeObserver navigationTreeObserver = new NavigationTreeObserver();
        navigationTreeObserver.addListener((ISubApplicationNodeListener)subApplicationListener);
        navigationTreeObserver.addListener((IApplicationNodeListener)new MyApplicationNodeListener());
        navigationTreeObserver.addListenerTo((IApplicationNode)this.controller.getNavigationNode());
    }

    private void configureWindow() {
        IWorkbenchWindowConfigurer configurer = this.getWindowConfigurer();
        String label = ((IApplicationNode)this.controller.getNavigationNode()).getLabel();
        if (label != null) {
            configurer.setTitle(label);
        }
        this.initApplicationSize(configurer);
        if (LnfManager.getLnf().getBooleanSetting("Shell.hideOsBorder").booleanValue() && !TestingSupport.isTestingEnabled()) {
            configurer.setShellStyle(0x20000008);
        }
    }

    private void initApplicationSize(IWorkbenchWindowConfigurer configurer) {
        int height;
        int width = Integer.getInteger(PROPERTY_RIENA_APPLICATION_WIDTH, ApplicationViewAdvisor.APPLICATION_MIN_SIZE.x);
        if (width < ApplicationViewAdvisor.APPLICATION_MIN_SIZE.x) {
            width = ApplicationViewAdvisor.APPLICATION_MIN_SIZE.x;
            LOGGER.log(2, "The initial width of the application is less than the minimum width which is " + ApplicationViewAdvisor.APPLICATION_MIN_SIZE.x);
        }
        if ((height = Integer.getInteger(PROPERTY_RIENA_APPLICATION_HEIGHT, ApplicationViewAdvisor.APPLICATION_MIN_SIZE.y).intValue()) < ApplicationViewAdvisor.APPLICATION_MIN_SIZE.y) {
            height = ApplicationViewAdvisor.APPLICATION_MIN_SIZE.y;
            LOGGER.log(2, "The initial height of the application is less than the minimum heightwhich is " + ApplicationViewAdvisor.APPLICATION_MIN_SIZE.y);
        }
        configurer.setInitialSize(new Point(width, height));
    }

    private void doInitialBinding() {
        this.binding.injectAndBind((IController)this.controller);
        this.controller.afterBind();
        ((IApplicationNode)this.controller.getNavigationNode()).activate();
    }

    private void createStatusLine(Composite shell, Composite grabCorner) {
        Statusline statusLine = new Statusline(shell, 0, StatuslineSpacer.class, (IStatusLineContentFactory)(this.getStatuslineContentFactory() != null ? this.getStatuslineContentFactory() : new DefaultStatuslineContentFactory()));
        FormData fd = new FormData();
        fd.height = LnfManager.getLnf().getIntegerSetting("statusline.height");
        Rectangle navigationBounds = TitlelessStackPresentation.calcNavigationBounds(shell);
        fd.left = new FormAttachment(0, navigationBounds.x);
        fd.right = grabCorner != null ? new FormAttachment((Control)grabCorner, 0) : new FormAttachment(100, 0);
        fd.bottom = new FormAttachment(100, -5);
        statusLine.setLayoutData((Object)fd);
        this.addUIControl((Composite)statusLine, "statusline");
    }

    private void initShell(Shell shell) {
        shell.setBackground(LnfManager.getLnf().getColor("TitlelessShell.background"));
        shell.addPaintListener((PaintListener)new ShellPaintListener());
        String iconName = ((IApplicationNode)this.controller.getNavigationNode()).getIcon();
        shell.setImage(ImageStore.getInstance().getImage(iconName));
        shell.setMinimumSize(APPLICATION_MIN_SIZE);
        this.addUIControl((Composite)shell, SHELL_RIDGET_PROPERTY);
        if (this.getShellRenderer() != null) {
            this.getShellRenderer().setShell(shell);
        }
        WidgetIdentificationSupport.setIdentification((Shell)shell);
    }

    private MenuManager getMenuManager() {
        return ((WorkbenchWindow)this.getWindowConfigurer().getWindow()).getMenuManager();
    }

    private TitleComposite createTitleComposite(Shell parentShell) {
        ApplicationNode node = (ApplicationNode)this.controller.getNavigationNode();
        return new TitleComposite(parentShell, node);
    }

    private GrabCorner createGrabCorner(Shell shell) {
        if (GrabCorner.isResizeable() && LnfManager.getLnf().getBooleanSetting("Shell.hideOsBorder").booleanValue()) {
            return new GrabCorner(shell, 0x20000000);
        }
        return null;
    }

    private Composite createMenuBarComposite(Composite parent, Composite previous) {
        Assert.isTrue((boolean)(parent.getLayout() instanceof FormLayout));
        int padding = this.getShellPadding();
        MenuCoolBarComposite composite = new MenuCoolBarComposite(parent, 0);
        composite.setLayout((Layout)new FillLayout());
        this.createMenuBar(composite);
        FormData formData = new FormData();
        formData.top = new FormAttachment((Control)previous, this.getMenuBarTopMargin());
        formData.left = new FormAttachment(0, padding);
        formData.right = new FormAttachment(100, -padding);
        composite.setLayoutData(formData);
        return composite;
    }

    private void createMenuBar(MenuCoolBarComposite parent) {
        IContributionItem[] contribItems = this.getMenuManager().getItems();
        int i = 0;
        while (i < contribItems.length) {
            if (contribItems[i] instanceof MenuManager) {
                MenuManager topMenuManager = (MenuManager)contribItems[i];
                parent.createAndAddMenu(topMenuManager);
            }
            ++i;
        }
    }

    private Composite createCoolBarComposite(Composite parent, Composite previous) {
        Assert.isTrue((boolean)(parent.getLayout() instanceof FormLayout));
        int padding = this.getCoolBarSeparatorPadding();
        Label separator = new Label(parent, 258);
        FormData formData = new FormData();
        formData.top = new FormAttachment((Control)previous);
        formData.left = new FormAttachment(0, padding);
        formData.right = new FormAttachment(100, -padding);
        separator.setLayoutData((Object)formData);
        padding = this.getShellPadding();
        Composite result = new Composite(parent, 0);
        result.setLayout((Layout)new FillLayout());
        formData = new FormData();
        formData.top = new FormAttachment((Control)previous, this.getToolBarTopMargin());
        formData.left = new FormAttachment(0, padding);
        formData.right = new FormAttachment(100, -padding);
        result.setLayoutData((Object)formData);
        Control control = this.getWindowConfigurer().createCoolBarControl(result);
        if (control instanceof CoolBar) {
            CoolBar coolbar = (CoolBar)control;
            CoolbarUtils.initCoolBar(coolbar);
        }
        return result;
    }

    private int getCoolBarSeparatorPadding() {
        ModuleGroupRenderer mgRenderer = (ModuleGroupRenderer)LnfManager.getLnf().getRenderer("ModuleGroup.renderer");
        if (mgRenderer == null) {
            mgRenderer = new ModuleGroupRenderer();
        }
        int padding = mgRenderer.getModuleGroupPadding();
        EmbeddedBorderRenderer borderRenderer = (EmbeddedBorderRenderer)LnfManager.getLnf().getRenderer("SubModuleView.borderRenderer");
        if (borderRenderer == null) {
            borderRenderer = new EmbeddedBorderRenderer();
        }
        padding += borderRenderer.getBorderWidth();
        return padding += this.getShellPadding();
    }

    private Composite createMainComposite(Composite parent, Composite previous) {
        Assert.isTrue((boolean)(parent.getLayout() instanceof FormLayout));
        int padding = this.getShellPadding();
        Composite composite = new Composite(parent, 0x20000000);
        composite.setLayout((Layout)new FillLayout());
        FormData formData = new FormData();
        formData.top = new FormAttachment((Control)previous, LnfManager.getLnf().getIntegerSetting("toolbar.workarea.vertical.gap").intValue(), 0);
        formData.bottom = new FormAttachment(100, -padding);
        formData.left = new FormAttachment(0, padding);
        formData.right = new FormAttachment(100, -padding);
        composite.setLayoutData((Object)formData);
        this.getWindowConfigurer().createPageComposite(composite);
        return composite;
    }

    private int getShellPadding() {
        ShellBorderRenderer borderRenderer = (ShellBorderRenderer)LnfManager.getLnf().getRenderer("TitlelessShell.borderRenderer");
        return borderRenderer.getCompleteBorderWidth();
    }

    private ShellRenderer getShellRenderer() {
        ShellRenderer shellRenderer = (ShellRenderer)LnfManager.getLnf().getRenderer("TitlelessShell.renderer");
        return shellRenderer;
    }

    private int getMenuBarTopMargin() {
        RienaDefaultLnf lnf = LnfManager.getLnf();
        return lnf.getIntegerSetting("Menubar.topMargin", Integer.valueOf(2));
    }

    private int getToolBarTopMargin() {
        RienaDefaultLnf lnf = LnfManager.getLnf();
        return lnf.getIntegerSetting("Toolbar.topMargin", Integer.valueOf(2));
    }

    public IStatusLineContentFactory getStatuslineContentFactory() {
        return this.statuslineContentFactory;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum BtnState {
        NONE,
        HOVER,
        HOVER_SELECTED;

    }

    private static class MyApplicationNodeListener
    extends ApplicationNodeListener {
        private MyApplicationNodeListener() {
        }

        public void filterAdded(IApplicationNode source, IUIFilter filter) {
            this.show();
        }

        public void filterRemoved(IApplicationNode source, IUIFilter filter) {
            this.show();
        }

        private void show() {
            try {
                IViewPart vp = this.getNavigationViewPart();
                if (vp == null) {
                    NavigationViewPart navi = (NavigationViewPart)this.getActivePage().showView("org.eclipse.riena.navigation.ui.swt.views.navigationViewPart");
                    navi.updateNavigationSize();
                }
            }
            catch (PartInitException e) {
                throw new UIViewFailure(e.getMessage(), e);
            }
        }

        private IWorkbenchPage getActivePage() {
            return PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        }

        private IViewPart getNavigationViewPart() {
            IViewReference[] references;
            IViewReference[] iViewReferenceArray = references = this.getActivePage().getViewReferences();
            int n = references.length;
            int n2 = 0;
            while (n2 < n) {
                IViewReference viewReference = iViewReferenceArray[n2];
                if (viewReference.getId().equals("org.eclipse.riena.navigation.ui.swt.views.navigationViewPart")) {
                    return viewReference.getView(true);
                }
                ++n2;
            }
            return null;
        }
    }

    private class MySubApplicationNodeListener
    extends SubApplicationNodeListener {
        private MySubApplicationNodeListener() {
        }

        public void activated(ISubApplicationNode source) {
            if (source != null) {
                this.showPerspective(source);
                if (ApplicationViewAdvisor.this.titleComposite != null) {
                    ApplicationViewAdvisor.this.titleComposite.setRedraw(false);
                    ApplicationViewAdvisor.this.titleComposite.setRedraw(true);
                }
            }
            super.activated((INavigationNode)source);
        }

        private void showPerspective(ISubApplicationNode source) {
            try {
                PlatformUI.getWorkbench().showPerspective(SwtViewProvider.getInstance().getSwtViewId((INavigationNode<?>)source).getId(), PlatformUI.getWorkbench().getActiveWorkbenchWindow());
            }
            catch (WorkbenchException e) {
                throw new UIViewFailure(e.getMessage(), e);
            }
        }

        public void disposed(ISubApplicationNode source) {
            SwtViewProvider viewProvider = SwtViewProvider.getInstance();
            String id = viewProvider.getSwtViewId((INavigationNode<?>)source).getId();
            IWorkbench workbench = PlatformUI.getWorkbench();
            IPerspectiveRegistry registry = workbench.getPerspectiveRegistry();
            IPerspectiveDescriptor perspDesc = registry.findPerspectiveWithId(id);
            workbench.getActiveWorkbenchWindow().getActivePage().closePerspective(perspDesc, false, false);
            viewProvider.unregisterSwtViewId((INavigationNode<?>)source);
        }
    }

    private static class ShellPaintListener
    implements PaintListener {
        private ShellPaintListener() {
        }

        public void paintControl(PaintEvent e) {
            this.onPaint(e);
        }

        private void onPaint(PaintEvent e) {
            if (e.getSource() instanceof Control) {
                Control shell = (Control)e.getSource();
                Rectangle shellBounds = shell.getBounds();
                Rectangle bounds = new Rectangle(0, 0, shellBounds.width, shellBounds.height);
                ILnfRenderer borderRenderer = LnfManager.getLnf().getRenderer("TitlelessShell.borderRenderer");
                borderRenderer.setBounds(bounds);
                borderRenderer.paint(e.gc, null);
            }
        }
    }
}

