/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.navigation.ui.swt.views;

import org.eclipse.riena.navigation.IModuleNode;
import org.eclipse.riena.navigation.INavigationNode;
import org.eclipse.riena.navigation.ISubModuleNode;
import org.eclipse.riena.navigation.listener.ISubModuleNodeListener;
import org.eclipse.riena.navigation.listener.NavigationTreeObserver;
import org.eclipse.riena.navigation.listener.SubModuleNodeListener;
import org.eclipse.riena.navigation.model.NavigationNode;
import org.eclipse.riena.navigation.model.SubModuleNode;
import org.eclipse.riena.navigation.ui.controllers.ModuleController;
import org.eclipse.riena.ui.ridgets.ISelectableRidget;
import org.eclipse.riena.ui.ridgets.ITreeRidget;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Widget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SWTModuleController
extends ModuleController {
    private ITreeRidget tree;
    private static final String PROPERTY_ENABLED = "enabled";
    private static final String PROPERTY_VISIBLE = "visible";
    private static final String PROPERTY_IMAGE = "icon";

    public SWTModuleController(IModuleNode navigationNode) {
        super(navigationNode);
        this.addListeners();
    }

    public void setTree(ITreeRidget tree) {
        this.tree = tree;
    }

    public ITreeRidget getTree() {
        return this.tree;
    }

    public void afterBind() {
        super.afterBind();
        this.updateNavigationNodeMarkers();
        this.bindTree();
    }

    private void addListeners() {
        NavigationTreeObserver navigationTreeObserver = new NavigationTreeObserver();
        navigationTreeObserver.addListener((ISubModuleNodeListener)new SubModuleListener());
        navigationTreeObserver.addListenerTo((IModuleNode)this.getNavigationNode());
    }

    private void bindTree() {
        this.tree.setRootsVisible(false);
        Object[] roots = this.createTreeRootNodes();
        this.tree.bindToModel(roots, NavigationNode.class, "children", "parent", "label", PROPERTY_ENABLED, PROPERTY_VISIBLE, PROPERTY_IMAGE);
        this.tree.setSelectionType(ISelectableRidget.SelectionType.SINGLE);
        this.selectActiveNode();
    }

    private IModuleNode[] createTreeRootNodes() {
        IModuleNode moduleNode = (IModuleNode)this.getNavigationNode();
        return new IModuleNode[]{moduleNode};
    }

    private Display getDisplay() {
        return ((Widget)this.getTree().getUIControl()).getDisplay();
    }

    private void runAsync(Runnable op) {
        this.getDisplay().asyncExec(op);
    }

    private void selectActiveNode() {
        this.setSelectedNode(this.getNavigationNode());
    }

    private void setSelectedNode(INavigationNode<?> node) {
        if (node.isActivated() && node != this.getNavigationNode()) {
            this.tree.setSelection(node);
            this.expandAllParents(node);
        }
        for (INavigationNode child : node.getChildren()) {
            this.setSelectedNode(child);
        }
    }

    private void expandAllParents(INavigationNode<?> node) {
        INavigationNode parent = node.getParent();
        while (parent instanceof SubModuleNode) {
            this.tree.expand((Object)parent);
            parent = parent.getParent();
        }
    }

    private class SubModuleListener
    extends SubModuleNodeListener {
        private SubModuleListener() {
        }

        public void afterActivated(ISubModuleNode source) {
            SWTModuleController.this.runAsync(new Runnable(){

                public void run() {
                    SWTModuleController.this.selectActiveNode();
                }
            });
        }

        public void expandedChanged(ISubModuleNode source) {
            super.expandedChanged((INavigationNode)source);
            if (source.isExpanded()) {
                SWTModuleController.this.tree.expand((Object)source);
            } else {
                SWTModuleController.this.tree.collapse((Object)source);
            }
        }

        public void childRemoved(ISubModuleNode source, ISubModuleNode childRemoved) {
            super.childRemoved((INavigationNode)source, (INavigationNode)childRemoved);
            if (source.getChildren().size() == 0) {
                SWTModuleController.this.tree.collapse((Object)source);
            }
        }
    }
}

