/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.objecttransaction;

import java.lang.reflect.Proxy;
import org.eclipse.riena.objecttransaction.IObjectTransaction;
import org.eclipse.riena.objecttransaction.ObjectTransactionFactory;
import org.eclipse.riena.objecttransaction.ObjectTransactionManager;
import org.eclipse.riena.objecttransaction.context.BasicContextCarrier;
import org.eclipse.riena.objecttransaction.context.ContextProxy;
import org.eclipse.riena.objecttransaction.context.IContextProvider;
import org.eclipse.riena.objecttransaction.context.IObjectTransactionContext;
import org.eclipse.riena.objecttransaction.context.ObjectTransactionContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTransactedManager {
    private IContextProvider contextProvider;
    private IObjectTransactionContext objectTransactionContext = new ObjectTransactionContext();

    protected AbstractTransactedManager() {
        this.contextProvider = new BasicContextCarrier(this.objectTransactionContext);
    }

    protected final void setCurrentObjectTransaction(IObjectTransaction pObjectTransaction) {
        this.objectTransactionContext.setObjectTransaction(pObjectTransaction);
    }

    protected final IObjectTransaction getCurrentObjectTransaction() {
        return this.objectTransactionContext.getObjectTransaction();
    }

    protected final IObjectTransaction createObjectTransaction() {
        IObjectTransaction oldTransaction = ObjectTransactionManager.getInstance().getCurrent();
        IObjectTransaction result = ObjectTransactionFactory.getInstance().createObjectTransaction();
        ObjectTransactionManager.getInstance().setCurrent(oldTransaction);
        return result;
    }

    protected final IObjectTransaction createSubObjectTransaction() {
        IObjectTransaction cobj = this.getCurrentObjectTransaction();
        IObjectTransaction result = null;
        if (cobj != null) {
            result = this.createSubObjectTransaction(cobj);
        }
        return result;
    }

    protected final IObjectTransaction createSubObjectTransaction(IObjectTransaction pParentTransaction) {
        IObjectTransaction oldTransaction = ObjectTransactionManager.getInstance().getCurrent();
        IObjectTransaction result = pParentTransaction.createSubObjectTransaction();
        ObjectTransactionManager.getInstance().setCurrent(oldTransaction);
        return result;
    }

    public final <T> T cover(T pObject) {
        return ContextProxy.cover(pObject, this.contextProvider);
    }

    public final <T> T uncover(T pCovered) {
        Object result = null;
        result = pCovered != null && Proxy.isProxyClass(pCovered.getClass()) && Proxy.getInvocationHandler(pCovered) instanceof ContextProxy ? ((ContextProxy)Proxy.getInvocationHandler(pCovered)).getService() : (Object)pCovered;
        return (T)result;
    }

    public void commit() {
        IObjectTransaction cot = this.getCurrentObjectTransaction();
        if (cot != null) {
            cot.commit();
        }
    }

    public void rollback() {
        IObjectTransaction cot = this.getCurrentObjectTransaction();
        if (cot != null) {
            cot.rollback();
        }
    }
}

