/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.objecttransaction.state;

import org.eclipse.core.runtime.Assert;
import org.eclipse.riena.objecttransaction.state.Action;
import org.eclipse.riena.objecttransaction.state.InvalidActionFailure;
import org.eclipse.riena.objecttransaction.state.State;

public final class StateMachine {
    private StateMachine() {
    }

    public static State initAction(Action action) throws InvalidActionFailure {
        if (action.equals(Action.NEW) || action.equals(Action.ADD) || action.equals(Action.SET)) {
            return State.CREATED;
        }
        if (action.equals(Action.DELETE) || action.equals(Action.REMOVE)) {
            return State.DELETED;
        }
        throw new InvalidActionFailure("unknown action " + Action.toString(action));
    }

    public static State processAction(State currentState, Action action) throws InvalidActionFailure {
        Assert.isNotNull((Object)currentState, (String)"currentState cannot be null");
        if (currentState.equals(State.CREATED)) {
            if (action.equals(Action.SET) || action.equals(Action.ADD) || action.equals(Action.REMOVE)) {
                return currentState;
            }
            if (action.equals(Action.NEW)) {
                return currentState;
            }
            if (action.equals(Action.DELETE)) {
                return State.VANISHED;
            }
        } else if (currentState.equals(State.MODIFIED)) {
            if (action.equals(Action.NEW)) {
                throw new InvalidActionFailure("state is MODIFIED, can't set to NEW");
            }
            if (action.equals(Action.SET) || action.equals(Action.ADD) || action.equals(Action.REMOVE)) {
                return currentState;
            }
            if (action.equals(Action.DELETE)) {
                return State.DELETED;
            }
        } else {
            if (currentState.equals(State.DELETED)) {
                throw new InvalidActionFailure("currentState is DELETED, no action possible");
            }
            if (currentState.equals(State.VANISHED)) {
                throw new InvalidActionFailure("currentState is VANISHED, no action possible");
            }
            if (currentState.equals(State.CLEAN)) {
                if (action.equals(Action.NEW)) {
                    throw new InvalidActionFailure("state is MODIFIED, can't set to NEW");
                }
                if (action.equals(Action.SET) || action.equals(Action.ADD) || action.equals(Action.REMOVE)) {
                    return State.MODIFIED;
                }
                if (action.equals(Action.DELETE)) {
                    return State.DELETED;
                }
            }
        }
        throw new InvalidActionFailure("unknown action for currentState state is " + State.toString(currentState) + " action is " + Action.toString(action));
    }

    public static State mergeStates(State currentState, State newState) throws InvalidActionFailure {
        if (currentState.equals(newState)) {
            return currentState;
        }
        if (currentState.equals(State.CREATED)) {
            if (newState.equals(State.DELETED) || newState.equals(State.VANISHED)) {
                return State.VANISHED;
            }
            return State.CREATED;
        }
        if (currentState.equals(State.MODIFIED) && (newState.equals(State.DELETED) || newState.equals(State.VANISHED))) {
            return State.DELETED;
        }
        if (currentState.equals(State.MODIFIED) && newState.equals(State.CREATED)) {
            return State.MODIFIED;
        }
        if (currentState.equals(State.DELETED) || currentState.equals(State.VANISHED)) {
            throw new InvalidActionFailure("current State is " + State.toString(currentState) + " new State is " + State.toString(newState) + " invalid change");
        }
        if (currentState.equals(State.CLEAN)) {
            if (newState.equals(State.MODIFIED) || newState.equals(State.DELETED)) {
                return newState;
            }
            if (newState.equals(State.VANISHED)) {
                throw new InvalidActionFailure("current State is " + State.toString(currentState) + " new State is " + State.toString(newState) + " invalid change");
            }
        }
        throw new InvalidActionFailure("unknown current State " + State.toString(currentState) + " and new State " + State.toString(newState));
    }
}

