/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.ui.ridgets.swt;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.databinding.BindingException;
import org.eclipse.core.databinding.conversion.Converter;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.observable.value.ValueChangeEvent;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.riena.beans.common.Person;
import org.eclipse.riena.beans.common.PersonManager;
import org.eclipse.riena.beans.common.StringManager;
import org.eclipse.riena.internal.ui.ridgets.swt.AbstractSWTRidgetTest;
import org.eclipse.riena.internal.ui.ridgets.swt.MarkerSupport;
import org.eclipse.riena.internal.ui.ridgets.swt.TestSelectionListener;
import org.eclipse.riena.internal.ui.swt.test.UITestHelper;
import org.eclipse.riena.ui.ridgets.listener.ISelectionListener;
import org.eclipse.riena.ui.ridgets.listener.SelectionEvent;
import org.eclipse.riena.ui.ridgets.swt.AbstractComboRidget;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Widget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractComboRidgetTest
extends AbstractSWTRidgetTest {
    private PersonManager manager;
    private Person selection1;
    private Person selection2;
    private Person selection3;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.manager = new PersonManager(this.createPersonList());
        Iterator it = this.manager.getPersons().iterator();
        this.selection1 = (Person)it.next();
        this.selection2 = (Person)it.next();
        this.selection3 = (Person)it.next();
    }

    protected final Control getWidget() {
        return (Control)super.getWidget();
    }

    protected final AbstractComboRidget getRidget() {
        return (AbstractComboRidget)super.getRidget();
    }

    protected abstract Control createWidget(Composite var1, int var2);

    public void testBindingWithNullProperty() throws Exception {
        AbstractComboRidget ridget = this.getRidget();
        ridget.setUIControl((Object)this.createWidget((Composite)this.getShell()));
        ProductHolder model = new ProductHolder();
        ArrayList<Product> products = new ArrayList<Product>();
        products.add(new Product("one"));
        products.add(new Product("two"));
        products.add(new Product(null));
        products.add(new Product("four"));
        products.add(new Product("five"));
        model.setProducts(products);
        ridget.bindToModel((Object)model, "products", Product.class, null, (Object)model, "selectedProducts");
        try {
            ridget.updateFromModel();
            AbstractComboRidgetTest.fail();
        }
        catch (NullPointerException nullPointerException) {
            this.ok("expected");
        }
        AbstractComboRidgetTest.assertEquals((int)2, (int)this.getItemCount(ridget.getUIControl()));
    }

    public void testBindingWithNullElement() throws Exception {
        AbstractComboRidget ridget = this.getRidget();
        ridget.setUIControl((Object)this.createWidget((Composite)this.getShell()));
        ProductHolder model = new ProductHolder();
        ArrayList<Product> products = new ArrayList<Product>();
        products.add(new Product("one"));
        products.add(new Product("two"));
        products.add(null);
        products.add(new Product("four"));
        products.add(new Product("five"));
        model.setProducts(products);
        ridget.bindToModel((Object)model, "products", Product.class, null, (Object)model, "selectedProducts");
        try {
            ridget.updateFromModel();
            AbstractComboRidgetTest.fail();
        }
        catch (NullPointerException nullPointerException) {
            this.ok("expected");
        }
        AbstractComboRidgetTest.assertEquals((int)2, (int)this.getItemCount(ridget.getUIControl()));
    }

    public void testSetUIControl() {
        AbstractComboRidget ridget = this.getRidget();
        ridget.setUIControl(null);
        AbstractComboRidgetTest.assertNull((Object)ridget.getUIControl());
        ridget.setUIControl((Object)this.getWidget());
        AbstractComboRidgetTest.assertSame((Object)this.getWidget(), (Object)ridget.getUIControl());
    }

    public void testSetUIControlInvalid() {
        AbstractComboRidget ridget = this.getRidget();
        try {
            ridget.setUIControl((Object)this.getShell());
            AbstractComboRidgetTest.fail();
        }
        catch (BindingException bindingException) {
            this.ok();
        }
        try {
            ridget.setUIControl((Object)this.createWidget((Composite)this.getShell(), 0));
            AbstractComboRidgetTest.fail();
        }
        catch (BindingException bindingException) {
            this.ok();
        }
    }

    public void testGetEmptySelectionItem() {
        AbstractComboRidget ridget = this.getRidget();
        Control control = this.getWidget();
        StringManager aManager = new StringManager(new String[]{"A", "B", "C", "D", "E"});
        ridget.bindToModel((Object)aManager, "items", String.class, null, (Object)aManager, "selectedItem");
        ridget.updateFromModel();
        AbstractComboRidgetTest.assertNull((Object)ridget.getEmptySelectionItem());
        String emptySelectionItem = "A";
        ridget.setEmptySelectionItem((Object)emptySelectionItem);
        AbstractComboRidgetTest.assertSame((Object)emptySelectionItem, (Object)ridget.getEmptySelectionItem());
        ridget.setSelection((Object)"A");
        int controlSelectedItemIndex = this.getSelectionIndex(control);
        AbstractComboRidgetTest.assertEquals((int)-1, (int)ridget.getSelectionIndex());
        AbstractComboRidgetTest.assertEquals((int)0, (int)controlSelectedItemIndex);
        AbstractComboRidgetTest.assertEquals(null, (Object)ridget.getSelection());
        AbstractComboRidgetTest.assertEquals((String)"A", (String)this.getItem(control, controlSelectedItemIndex));
    }

    public void testBindToModelWithDomainObjects() {
        this.manager.setSelectedPerson(this.selection1);
        AbstractComboRidget ridget = this.getRidget();
        Control control = this.getWidget();
        AbstractComboRidgetTest.assertEquals(null, (String)this.getSelectedString(control));
        AbstractComboRidgetTest.assertEquals((int)0, (int)this.getItemCount(control));
        ridget.bindToModel((Object)this.manager, "persons", String.class, null, (Object)this.manager, "selectedPerson");
        AbstractComboRidgetTest.assertEquals(null, (String)this.getSelectedString(control));
        AbstractComboRidgetTest.assertEquals((int)0, (int)this.getItemCount(control));
        ridget.updateFromModel();
        AbstractComboRidgetTest.assertEquals((String)this.selection1.toString(), (String)this.getSelectedString(control));
        AbstractComboRidgetTest.assertEquals((int)this.manager.getPersons().size(), (int)this.getItemCount(control));
        int i = 0;
        while (i < this.getItemCount(control)) {
            String item = this.getItem(control, i);
            if (!this.find(this.manager, item)) {
                AbstractComboRidgetTest.fail();
            }
            ++i;
        }
        this.manager.setSelectedPerson(this.selection2);
        AbstractComboRidgetTest.assertEquals((String)this.selection1.toString(), (String)this.getSelectedString(control));
        ridget.updateFromModel();
        AbstractComboRidgetTest.assertEquals((String)this.selection2.toString(), (String)this.getSelectedString(control));
        this.select(control, 2);
        AbstractComboRidgetTest.assertEquals((String)this.selection3.toString(), (String)this.getSelectedString(control));
    }

    public void testBindToModelWithDomainObjectsUsingColumnPropertyName() {
        this.manager.setSelectedPerson(this.selection1);
        AbstractComboRidget ridget = this.getRidget();
        Control control = this.getWidget();
        AbstractComboRidgetTest.assertEquals(null, (String)this.getSelectedString(control));
        AbstractComboRidgetTest.assertEquals((int)0, (int)this.getItemCount(control));
        ridget.bindToModel((Object)this.manager, "persons", String.class, "getListEntry", (Object)this.manager, "selectedPerson");
        AbstractComboRidgetTest.assertEquals(null, (String)this.getSelectedString(control));
        AbstractComboRidgetTest.assertEquals((int)0, (int)this.getItemCount(control));
        ridget.updateFromModel();
        AbstractComboRidgetTest.assertEquals((String)this.selection1.getListEntry(), (String)this.getSelectedString(control));
        AbstractComboRidgetTest.assertEquals((String)this.selection1.getListEntry(), (String)this.getText(control));
        this.checkPersonList(this.manager);
        AbstractComboRidgetTest.assertEquals((Object)this.selection1, (Object)this.manager.getSelectedPerson());
        this.manager.setSelectedPerson(this.selection2);
        AbstractComboRidgetTest.assertEquals((String)this.selection1.getListEntry(), (String)this.getSelectedString(control));
        AbstractComboRidgetTest.assertEquals((String)this.selection1.getListEntry(), (String)this.getText(control));
        AbstractComboRidgetTest.assertEquals((Object)this.selection2, (Object)this.manager.getSelectedPerson());
        ridget.updateFromModel();
        AbstractComboRidgetTest.assertEquals((Object)this.selection2, (Object)this.manager.getSelectedPerson());
        AbstractComboRidgetTest.assertEquals((String)this.selection2.getListEntry(), (String)this.getSelectedString(control));
        AbstractComboRidgetTest.assertEquals((String)this.selection2.getListEntry(), (String)this.getText(control));
        this.select(control, 2);
        AbstractComboRidgetTest.assertEquals((String)this.selection3.getListEntry(), (String)this.getSelectedString(control));
        AbstractComboRidgetTest.assertEquals((String)this.selection3.getListEntry(), (String)this.getText(control));
        AbstractComboRidgetTest.assertEquals((Object)this.selection3, (Object)this.manager.getSelectedPerson());
    }

    public void testBindToModelWithStrings() {
        StringManager aManager = new StringManager(new String[]{"A", "B", "C", "D", "E"});
        Iterator it = aManager.getItems().iterator();
        String aSelection1 = (String)it.next();
        String aSelection2 = (String)it.next();
        String aSelection3 = (String)it.next();
        aManager.setSelectedItem(aSelection1);
        AbstractComboRidget ridget = this.getRidget();
        Control control = this.getWidget();
        AbstractComboRidgetTest.assertEquals((int)-1, (int)this.getSelectionIndex(control));
        AbstractComboRidgetTest.assertEquals((int)0, (int)this.getItemCount(control));
        ridget.bindToModel((Object)aManager, "items", String.class, null, (Object)aManager, "selectedItem");
        AbstractComboRidgetTest.assertEquals((int)-1, (int)this.getSelectionIndex(control));
        AbstractComboRidgetTest.assertEquals((int)0, (int)this.getItemCount(control));
        ridget.updateFromModel();
        AbstractComboRidgetTest.assertEquals((int)aManager.getItems().size(), (int)this.getItemCount(control));
        AbstractComboRidgetTest.assertEquals((String)aSelection1, (String)this.getSelectedString(control));
        int i = 0;
        while (i < this.getItemCount(control)) {
            if (!aManager.getItems().contains(this.getItem(control, i))) {
                AbstractComboRidgetTest.fail();
            }
            ++i;
        }
        aManager.setSelectedItem(aSelection2);
        AbstractComboRidgetTest.assertEquals((String)aSelection1, (String)this.getSelectedString(control));
        ridget.updateFromModel();
        AbstractComboRidgetTest.assertEquals((String)aSelection2, (String)this.getSelectedString(control));
        this.select(control, 2);
        AbstractComboRidgetTest.assertEquals((String)aSelection3, (String)this.getSelectedString(control));
        AbstractComboRidgetTest.assertEquals((String)aSelection3, (String)this.getText(control));
        AbstractComboRidgetTest.assertEquals((String)aSelection3, (String)aManager.getSelectedItem());
    }

    public void testBindToModelWithNoControl() {
        AbstractComboRidget ridget = (AbstractComboRidget)this.createRidget();
        Control control = (Control)this.createWidget((Composite)this.getShell());
        ridget.bindToModel((Object)this.manager, "persons", String.class, "getListEntry", (Object)this.manager, "selectedPerson");
        ridget.updateFromModel();
        AbstractComboRidgetTest.assertEquals((int)0, (int)this.getItemCount(control));
        ridget.setUIControl((Object)control);
        AbstractComboRidgetTest.assertEquals((int)this.manager.getPersons().size(), (int)this.getItemCount(control));
    }

    public void testFirePropertyChangeSelection() {
        this.manager.setSelectedPerson(this.selection1);
        AbstractComboRidget ridget = this.getRidget();
        Control control = this.getWidget();
        AbstractComboRidgetTest.assertEquals(null, (String)this.getSelectedString(control));
        AbstractComboRidgetTest.assertEquals((int)0, (int)this.getItemCount(control));
        ridget.bindToModel((Object)this.manager, "persons", String.class, "getListEntry", (Object)this.manager, "selectedPerson");
        AbstractComboRidgetTest.assertEquals(null, (String)this.getSelectedString(control));
        AbstractComboRidgetTest.assertEquals((int)0, (int)this.getItemCount(control));
        ridget.updateFromModel();
        this.expectPropertyChangeEvents(new SelectionPropertyChangeEvent(this.selection1, this.selection2));
        this.select(control, 1);
        this.verifyPropertyChangeEvents();
        this.expectNoPropertyChangeEvent();
        this.select(control, 1);
        this.verifyPropertyChangeEvents();
        this.expectPropertyChangeEvents(new SelectionPropertyChangeEvent(this.selection2, this.selection3), new SelectionPropertyChangeEvent(this.selection3, this.selection1));
        this.select(control, 2);
        this.select(control, 0);
        this.verifyPropertyChangeEvents();
    }

    public void testUpdateFromModel() {
        AbstractComboRidget ridget = this.getRidget();
        Control control = this.getWidget();
        ridget.bindToModel((Object)this.manager, "persons", String.class, null, (Object)this.manager, "selectedPerson");
        AbstractComboRidgetTest.assertEquals((int)0, (int)this.getItemCount(control));
        ridget.updateFromModel();
        int oldSize = this.manager.getPersons().size();
        AbstractComboRidgetTest.assertEquals((int)oldSize, (int)this.getItemCount(control));
        this.manager.getPersons().remove(this.manager.getPersons().iterator().next());
        AbstractComboRidgetTest.assertEquals((int)oldSize, (int)this.getItemCount(control));
        ridget.updateFromModel();
        AbstractComboRidgetTest.assertEquals((int)(oldSize - 1), (int)this.getItemCount(control));
    }

    public void testUpdateSelection() {
        AbstractComboRidget ridget = this.getRidget();
        Control control = this.getWidget();
        this.manager.setSelectedPerson(this.selection1);
        AbstractComboRidgetTest.assertEquals(null, (String)this.getSelectedString(control));
        AbstractComboRidgetTest.assertEquals((int)0, (int)this.getItemCount(control));
        ridget.bindToModel((Object)this.manager, "persons", String.class, null, (Object)this.manager, "selectedPerson");
        AbstractComboRidgetTest.assertEquals(null, (String)this.getSelectedString(control));
        AbstractComboRidgetTest.assertEquals((int)0, (int)this.getItemCount(control));
        ridget.updateFromModel();
        AbstractComboRidgetTest.assertEquals((String)this.selection1.toString(), (String)this.getSelectedString(control));
        this.select(control, 2);
        this.manager.setSelectedPerson(this.selection2);
        AbstractComboRidgetTest.assertEquals((String)this.selection3.toString(), (String)this.getSelectedString(control));
        AbstractComboRidgetTest.assertEquals((Object)this.selection2, (Object)this.manager.getSelectedPerson());
        ridget.updateFromModel();
        AbstractComboRidgetTest.assertEquals((String)this.selection2.toString(), (String)this.getSelectedString(control));
        AbstractComboRidgetTest.assertEquals((Object)this.selection2, (Object)this.manager.getSelectedPerson());
    }

    public void testGetObservableListWithStrings() {
        StringManager aManager = new StringManager(new String[]{"A", "B", "C", "D", "E"});
        AbstractComboRidget ridget = this.getRidget();
        ridget.bindToModel((Object)aManager, "items", String.class, null, (Object)aManager, "selectedItem");
        AbstractComboRidgetTest.assertEquals((int)0, (int)ridget.getObservableList().size());
        ridget.updateFromModel();
        AbstractComboRidgetTest.assertEquals((int)aManager.getItems().size(), (int)ridget.getObservableList().size());
        String[] stringArray = new String[]{"A", "B", "C", "D", "E"};
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String item = stringArray[n2];
            AbstractComboRidgetTest.assertTrue((boolean)ridget.getObservableList().contains((Object)item));
            ++n2;
        }
    }

    public void testGetSelectionIndex() {
        StringManager aManager = new StringManager(new String[]{"A", "B", "C", "D", "E"});
        AbstractComboRidget ridget = this.getRidget();
        ridget.bindToModel((Object)aManager, "items", String.class, null, (Object)aManager, "selectedItem");
        ridget.updateFromModel();
        AbstractComboRidgetTest.assertEquals((int)-1, (int)this.getRidget().getSelectionIndex());
        this.select(this.getWidget(), 1);
        AbstractComboRidgetTest.assertEquals((int)1, (int)this.getRidget().getSelectionIndex());
        ridget.setUIControl(null);
        AbstractComboRidgetTest.assertEquals((int)1, (int)this.getRidget().getSelectionIndex());
    }

    public void testGetSelection() {
        AbstractComboRidget ridget = this.getRidget();
        StringManager aManager = new StringManager(new String[]{"A", "B", "C", "D", "E"});
        ridget.bindToModel((Object)aManager, "items", String.class, null, (Object)aManager, "selectedItem");
        ridget.updateFromModel();
        AbstractComboRidgetTest.assertEquals(null, (Object)this.getRidget().getSelection());
        this.select(this.getWidget(), 1);
        AbstractComboRidgetTest.assertEquals((Object)"B", (Object)this.getRidget().getSelection());
        ridget.setUIControl(null);
        AbstractComboRidgetTest.assertEquals((Object)"B", (Object)this.getRidget().getSelection());
    }

    public void testSetSelectionInt() {
        AbstractComboRidget ridget = this.getRidget();
        Control control = ridget.getUIControl();
        StringManager aManager = new StringManager(new String[]{"A", "B", "C", "D", "E"});
        ridget.bindToModel((Object)aManager, "items", String.class, null, (Object)aManager, "selectedItem");
        ridget.updateFromModel();
        AbstractComboRidgetTest.assertEquals(null, (Object)ridget.getSelection());
        ridget.setSelection(0);
        AbstractComboRidgetTest.assertEquals((Object)"A", (Object)ridget.getSelection());
        AbstractComboRidgetTest.assertEquals((String)"A", (String)this.getItem(control, this.getSelectionIndex(control)));
        ridget.setSelection(1);
        AbstractComboRidgetTest.assertEquals((Object)"B", (Object)ridget.getSelection());
        AbstractComboRidgetTest.assertEquals((String)"B", (String)this.getItem(control, this.getSelectionIndex(control)));
        ridget.setUIControl(null);
        ridget.setSelection(2);
        AbstractComboRidgetTest.assertEquals((Object)"C", (Object)ridget.getSelection());
        AbstractComboRidgetTest.assertEquals((String)"B", (String)this.getItem(control, this.getSelectionIndex(control)));
        ridget.setUIControl((Object)control);
        AbstractComboRidgetTest.assertEquals((Object)"C", (Object)ridget.getSelection());
        AbstractComboRidgetTest.assertEquals((String)"C", (String)this.getItem(control, this.getSelectionIndex(control)));
        ridget.setSelection(-1);
        AbstractComboRidgetTest.assertEquals(null, (Object)ridget.getSelection());
        AbstractComboRidgetTest.assertEquals((int)-1, (int)this.getSelectionIndex(control));
        try {
            ridget.setSelection(999);
            AbstractComboRidgetTest.fail();
        }
        catch (RuntimeException runtimeException) {
            this.ok();
        }
    }

    public void testSetSelectionString() {
        AbstractComboRidget ridget = this.getRidget();
        Control control = ridget.getUIControl();
        StringManager aManager = new StringManager(new String[]{"A", "B", "C", "D", "E"});
        ridget.bindToModel((Object)aManager, "items", String.class, null, (Object)aManager, "selectedItem");
        ridget.updateFromModel();
        AbstractComboRidgetTest.assertEquals(null, (Object)ridget.getSelection());
        ridget.setSelection((Object)"A");
        AbstractComboRidgetTest.assertEquals((Object)"A", (Object)ridget.getSelection());
        AbstractComboRidgetTest.assertEquals((String)"A", (String)this.getItem(control, this.getSelectionIndex(control)));
        ridget.setSelection((Object)"B");
        AbstractComboRidgetTest.assertEquals((Object)"B", (Object)ridget.getSelection());
        AbstractComboRidgetTest.assertEquals((String)"B", (String)this.getItem(control, this.getSelectionIndex(control)));
        ridget.setUIControl(null);
        ridget.setSelection((Object)"C");
        AbstractComboRidgetTest.assertEquals((Object)"C", (Object)ridget.getSelection());
        AbstractComboRidgetTest.assertEquals((String)"B", (String)this.getItem(control, this.getSelectionIndex(control)));
        ridget.setUIControl((Object)control);
        AbstractComboRidgetTest.assertEquals((Object)"C", (Object)ridget.getSelection());
        AbstractComboRidgetTest.assertEquals((String)"C", (String)this.getItem(control, this.getSelectionIndex(control)));
        ridget.setSelection((Object)"X");
        AbstractComboRidgetTest.assertEquals(null, (Object)ridget.getSelection());
        AbstractComboRidgetTest.assertEquals((int)-1, (int)this.getSelectionIndex(control));
        ridget.setSelection((Object)"A");
        ridget.setSelection(null);
        AbstractComboRidgetTest.assertEquals(null, (Object)ridget.getSelection());
        AbstractComboRidgetTest.assertEquals((int)-1, (int)this.getSelectionIndex(control));
    }

    public void testSetSelectionWhenNotBoundToModel() {
        AbstractComboRidget ridget = this.getRidget();
        try {
            ridget.setSelection(new Object());
            AbstractComboRidgetTest.fail();
        }
        catch (BindingException bindingException) {
            this.ok();
        }
    }

    public void testOutputCannotBeChangedFromUI() {
        AbstractComboRidget ridget = this.getRidget();
        Control control = this.getWidget();
        StringManager aManager = new StringManager(new String[]{"A", "B", "C", "D", "E"});
        ridget.bindToModel((Object)aManager, "items", String.class, null, (Object)aManager, "selectedItem");
        ridget.updateFromModel();
        AbstractComboRidgetTest.assertNull((Object)ridget.getSelection());
        AbstractComboRidgetTest.assertEquals((int)-1, (int)this.getSelectionIndex(control));
        ridget.setOutputOnly(true);
        control.setFocus();
        this.selectA(control);
        AbstractComboRidgetTest.assertNull((Object)ridget.getSelection());
        AbstractComboRidgetTest.assertEquals((int)-1, (int)this.getSelectionIndex(control));
        ridget.setOutputOnly(false);
        control.setFocus();
        this.selectA(control);
        AbstractComboRidgetTest.assertEquals((Object)"A", (Object)ridget.getSelection());
        AbstractComboRidgetTest.assertEquals((int)0, (int)this.getSelectionIndex(control));
    }

    public void testOutputControlIsDisabledAndHasText() {
        AbstractComboRidget ridget = this.getRidget();
        Control control = this.getWidget();
        ridget.bindToModel((Object)this.manager, "persons", String.class, null, (Object)this.manager, "selectedPerson");
        ridget.updateFromModel();
        ridget.setSelection((Object)this.selection1);
        AbstractComboRidgetTest.assertTrue((boolean)control.isEnabled());
        AbstractComboRidgetTest.assertEquals((String)this.selection1.toString(), (String)this.getText(control));
        AbstractComboRidgetTest.assertEquals((Object)this.selection1, (Object)ridget.getSelection());
        ridget.setOutputOnly(true);
        AbstractComboRidgetTest.assertFalse((boolean)control.isEnabled());
        AbstractComboRidgetTest.assertEquals((String)this.selection1.toString(), (String)this.getText(control));
        AbstractComboRidgetTest.assertEquals((Object)this.selection1, (Object)ridget.getSelection());
        ridget.setEnabled(false);
        ridget.setEnabled(true);
        AbstractComboRidgetTest.assertFalse((boolean)control.isEnabled());
        AbstractComboRidgetTest.assertEquals((String)this.selection1.toString(), (String)this.getText(control));
        AbstractComboRidgetTest.assertEquals((Object)this.selection1, (Object)ridget.getSelection());
        ridget.setOutputOnly(false);
        AbstractComboRidgetTest.assertTrue((boolean)control.isEnabled());
        AbstractComboRidgetTest.assertEquals((String)this.selection1.toString(), (String)this.getText(control));
        AbstractComboRidgetTest.assertEquals((Object)this.selection1, (Object)ridget.getSelection());
    }

    public void testOuputControlIsUpdatedOnBind() {
        AbstractComboRidget ridget = this.getRidget();
        Control control = this.getWidget();
        ridget.setUIControl(null);
        ridget.setOutputOnly(true);
        ridget.bindToModel((Object)this.manager, "persons", String.class, null, (Object)this.manager, "selectedPerson");
        ridget.updateFromModel();
        ridget.setSelection((Object)this.selection1);
        AbstractComboRidgetTest.assertEquals((Object)this.selection1, (Object)ridget.getSelection());
        AbstractComboRidgetTest.assertEquals((String)"", (String)this.getText(control));
        AbstractComboRidgetTest.assertTrue((boolean)control.isEnabled());
        ridget.setUIControl((Object)control);
        AbstractComboRidgetTest.assertEquals((Object)this.selection1, (Object)ridget.getSelection());
        AbstractComboRidgetTest.assertEquals((String)this.selection1.toString(), (String)this.getText(control));
        AbstractComboRidgetTest.assertFalse((boolean)control.isEnabled());
    }

    public void testDisabledComboIsEmptyFromRidget() {
        if (!MarkerSupport.HIDE_DISABLED_RIDGET_CONTENT) {
            System.out.println("Skipping ComboRidgetTest.testDisabledComboIsEmptyFromRidget()");
            return;
        }
        AbstractComboRidget ridget = this.getRidget();
        Control control = this.getWidget();
        ridget.bindToModel((Object)this.manager, "persons", String.class, null, (Object)this.manager, "selectedPerson");
        ridget.updateFromModel();
        ridget.setSelection((Object)this.selection1);
        AbstractComboRidgetTest.assertEquals((String)this.selection1.toString(), (String)this.getText(control));
        AbstractComboRidgetTest.assertEquals((Object)this.selection1, (Object)ridget.getSelection());
        AbstractComboRidgetTest.assertEquals((Object)this.selection1, (Object)this.manager.getSelectedPerson());
        ridget.setEnabled(false);
        AbstractComboRidgetTest.assertEquals((String)"", (String)this.getText(control));
        AbstractComboRidgetTest.assertEquals((Object)this.selection1, (Object)ridget.getSelection());
        AbstractComboRidgetTest.assertEquals((Object)this.selection1, (Object)this.manager.getSelectedPerson());
        ridget.setSelection((Object)this.selection2);
        AbstractComboRidgetTest.assertEquals((String)"", (String)this.getText(control));
        AbstractComboRidgetTest.assertEquals((Object)this.selection2, (Object)ridget.getSelection());
        AbstractComboRidgetTest.assertEquals((Object)this.selection2, (Object)this.manager.getSelectedPerson());
        ridget.setEnabled(true);
        AbstractComboRidgetTest.assertEquals((String)this.selection2.toString(), (String)this.getText(control));
        AbstractComboRidgetTest.assertEquals((Object)this.selection2, (Object)ridget.getSelection());
        AbstractComboRidgetTest.assertEquals((Object)this.selection2, (Object)this.manager.getSelectedPerson());
    }

    public void testDisabledComboIsEmptyFromModel() {
        if (!MarkerSupport.HIDE_DISABLED_RIDGET_CONTENT) {
            System.out.println("Skipping ComboRidgetTest.testDisabledComboIsEmptyFromModel()");
            return;
        }
        AbstractComboRidget ridget = this.getRidget();
        Control control = this.getWidget();
        ridget.bindToModel((Object)this.manager, "persons", String.class, null, (Object)this.manager, "selectedPerson");
        this.manager.setSelectedPerson(this.selection1);
        ridget.updateFromModel();
        AbstractComboRidgetTest.assertEquals((String)this.selection1.toString(), (String)this.getText(control));
        AbstractComboRidgetTest.assertEquals((Object)this.selection1, (Object)ridget.getSelection());
        AbstractComboRidgetTest.assertEquals((Object)this.selection1, (Object)this.manager.getSelectedPerson());
        ridget.setEnabled(false);
        AbstractComboRidgetTest.assertEquals((String)"", (String)this.getText(control));
        AbstractComboRidgetTest.assertEquals((Object)this.selection1, (Object)ridget.getSelection());
        AbstractComboRidgetTest.assertEquals((Object)this.selection1, (Object)this.manager.getSelectedPerson());
        this.manager.setSelectedPerson(this.selection2);
        ridget.updateFromModel();
        AbstractComboRidgetTest.assertEquals((String)"", (String)this.getText(control));
        AbstractComboRidgetTest.assertEquals((Object)this.selection2, (Object)ridget.getSelection());
        AbstractComboRidgetTest.assertEquals((Object)this.selection2, (Object)this.manager.getSelectedPerson());
        ridget.setEnabled(true);
        AbstractComboRidgetTest.assertEquals((String)this.selection2.toString(), (String)this.getText(control));
        AbstractComboRidgetTest.assertEquals((Object)this.selection2, (Object)ridget.getSelection());
        AbstractComboRidgetTest.assertEquals((Object)this.selection2, (Object)this.manager.getSelectedPerson());
    }

    public void testDisabledDoesNotFireSelection() {
        AbstractComboRidget ridget = this.getRidget();
        ridget.bindToModel((Object)this.manager, "persons", String.class, null, (Object)this.manager, "selectedPerson");
        ridget.updateFromModel();
        FTPropertyChangeListener pcl = new FTPropertyChangeListener();
        ridget.addPropertyChangeListener("selection", (PropertyChangeListener)pcl);
        ridget.setSelection((Object)this.selection1);
        AbstractComboRidgetTest.assertEquals((int)1, (int)pcl.getCount());
        ridget.setEnabled(false);
        AbstractComboRidgetTest.assertEquals((int)1, (int)pcl.getCount());
        ridget.setSelection((Object)this.selection2);
        AbstractComboRidgetTest.assertEquals((int)2, (int)pcl.getCount());
        ridget.setEnabled(true);
        AbstractComboRidgetTest.assertEquals((int)2, (int)pcl.getCount());
    }

    public void testDisableWithoutBoundModel() {
        AbstractComboRidget ridget = this.getRidget();
        Control control = this.getWidget();
        AbstractComboRidgetTest.assertTrue((boolean)ridget.getObservableList().isEmpty());
        ridget.setEnabled(false);
        AbstractComboRidgetTest.assertFalse((boolean)ridget.isEnabled());
        AbstractComboRidgetTest.assertFalse((boolean)control.isEnabled());
        ridget.setEnabled(true);
        AbstractComboRidgetTest.assertTrue((boolean)ridget.isEnabled());
        AbstractComboRidgetTest.assertTrue((boolean)control.isEnabled());
    }

    public void testDisableAndClearOnBind() {
        AbstractComboRidget ridget = this.getRidget();
        Control control = this.getWidget();
        ridget.setUIControl(null);
        ridget.setEnabled(false);
        this.manager.setSelectedPerson(this.selection1);
        ridget.bindToModel((Object)this.manager, "persons", String.class, null, (Object)this.manager, "selectedPerson");
        ridget.updateFromModel();
        ridget.setUIControl((Object)control);
        AbstractComboRidgetTest.assertFalse((boolean)control.isEnabled());
        AbstractComboRidgetTest.assertEquals((String)"", (String)this.getText(control));
        AbstractComboRidgetTest.assertEquals((Object)this.selection1, (Object)ridget.getSelection());
        ridget.setEnabled(true);
        AbstractComboRidgetTest.assertTrue((boolean)control.isEnabled());
        AbstractComboRidgetTest.assertEquals((String)this.selection1.toString(), (String)this.getText(control));
        AbstractComboRidgetTest.assertEquals((Object)this.selection1, (Object)ridget.getSelection());
    }

    public void testSelectionListenerHasLatestValues() {
        final AbstractComboRidget ridget = this.getRidget();
        final Control control = this.getWidget();
        final StringManager stringManager = new StringManager(new String[]{"A", "B", "C", "D", "E"});
        ridget.bindToModel((Object)stringManager, "items", String.class, null, (Object)stringManager, "selectedItem");
        ridget.updateFromModel();
        ridget.setUIControl((Object)control);
        AbstractComboRidgetTest.assertEquals((int)-1, (int)this.getSelectionIndex(control));
        AbstractComboRidgetTest.assertEquals(null, (String)this.getSelectedString(control));
        AbstractComboRidgetTest.assertEquals(null, (Object)ridget.getSelection());
        AbstractComboRidgetTest.assertEquals(null, (String)stringManager.getSelectedItem());
        FTPropertyChangeListener listener = new FTPropertyChangeListener();
        listener.setRunnable(new Runnable(){

            public void run() {
                if (!(control instanceof CCombo)) {
                    AbstractComboRidgetTest.assertEquals((int)0, (int)AbstractComboRidgetTest.this.getSelectionIndex(control));
                    AbstractComboRidgetTest.assertEquals((String)"A", (String)AbstractComboRidgetTest.this.getSelectedString(control));
                }
                AbstractComboRidgetTest.assertEquals((Object)"A", (Object)ridget.getSelection());
                AbstractComboRidgetTest.assertEquals((String)"A", (String)stringManager.getSelectedItem());
            }
        });
        ridget.addPropertyChangeListener("selection", (PropertyChangeListener)listener);
        control.setFocus();
        this.selectA(control);
        AbstractComboRidgetTest.assertEquals((int)1, (int)listener.getCount());
        AbstractComboRidgetTest.assertEquals((int)0, (int)this.getSelectionIndex(control));
        AbstractComboRidgetTest.assertEquals((String)"A", (String)this.getSelectedString(control));
        AbstractComboRidgetTest.assertEquals((Object)"A", (Object)ridget.getSelection());
        AbstractComboRidgetTest.assertEquals((String)"A", (String)stringManager.getSelectedItem());
    }

    public void testValueConversion() {
        AbstractComboRidget ridget = this.getRidget();
        Control control = this.getWidget();
        final Person[] persons = new Person[]{new Person("Einstein", "Albert"), new Person("Da Vinci", "Leonardo"), new Person("Curie", "Marie")};
        ridget.setModelToUIControlConverter((IConverter)new Converter(Person.class, String.class){

            public Object convert(Object fromObject) {
                return AbstractComboRidgetTest.getInitials((Person)fromObject);
            }
        });
        ridget.setUIControlToModelConverter((IConverter)new Converter(String.class, Person.class){

            public Object convert(Object fromObject) {
                Person[] personArray = persons;
                int n = persons.length;
                int n2 = 0;
                while (n2 < n) {
                    Person person = personArray[n2];
                    if (fromObject.equals(AbstractComboRidgetTest.getInitials(person))) {
                        return person;
                    }
                    ++n2;
                }
                return null;
            }
        });
        WritableList options = new WritableList(Arrays.asList(persons), Person.class);
        WritableValue selection = new WritableValue((Object)persons[0], Person.class);
        ridget.bindToModel((IObservableList)options, Person.class, null, (IObservableValue)selection);
        ridget.updateFromModel();
        AbstractComboRidgetTest.assertEquals((String)"AE", (String)this.getItem(control, 0));
        AbstractComboRidgetTest.assertEquals((String)"LD", (String)this.getItem(control, 1));
        AbstractComboRidgetTest.assertEquals((String)"MC", (String)this.getItem(control, 2));
        AbstractComboRidgetTest.assertEquals((Object)persons[0], (Object)ridget.getSelection());
        this.select(control, 2);
        AbstractComboRidgetTest.assertEquals((Object)persons[2], (Object)ridget.getSelection());
    }

    public void testAddSelectionListener() throws InterruptedException {
        AbstractComboRidget ridget = this.getRidget();
        Control control = this.getWidget();
        StringManager aManager = new StringManager(new String[]{"A", "B", "C", "D", "E"});
        ridget.bindToModel((Object)aManager, "items", String.class, null, (Object)aManager, "selectedItem");
        ridget.updateFromModel();
        try {
            ridget.addSelectionListener(null);
            AbstractComboRidgetTest.fail();
        }
        catch (RuntimeException runtimeException) {
            this.ok();
        }
        TestSelectionListener selectionListener = new TestSelectionListener();
        ridget.addSelectionListener((ISelectionListener)selectionListener);
        AbstractComboRidgetTest.assertEquals(null, (Object)ridget.getSelection());
        AbstractComboRidgetTest.assertEquals((int)-1, (int)this.getSelectionIndex(control));
        control.setFocus();
        UITestHelper.sendKeyAction((Display)control.getDisplay(), (int)0x1000002);
        UITestHelper.readAndDispatch((Widget)control);
        AbstractComboRidgetTest.assertNotNull((Object)ridget.getSelection());
        AbstractComboRidgetTest.assertEquals((int)0, (int)this.getSelectionIndex(control));
        AbstractComboRidgetTest.assertEquals((int)1, (int)selectionListener.getCount());
        SelectionEvent selectionEvent = selectionListener.getSelectionEvent();
        AbstractComboRidgetTest.assertEquals((Object)ridget, (Object)selectionEvent.getSource());
        AbstractComboRidgetTest.assertTrue((boolean)selectionEvent.getOldSelection().isEmpty());
        AbstractComboRidgetTest.assertEquals((Object)ridget.getSelection(), selectionEvent.getNewSelection().get(0));
        UITestHelper.sendKeyAction((Display)control.getDisplay(), (int)0x1000002);
        UITestHelper.readAndDispatch((Widget)control);
        AbstractComboRidgetTest.assertNotNull((Object)ridget.getSelection());
        AbstractComboRidgetTest.assertEquals((int)1, (int)this.getSelectionIndex(control));
        AbstractComboRidgetTest.assertEquals((int)2, (int)selectionListener.getCount());
        SelectionEvent selectionEvent2 = selectionListener.getSelectionEvent();
        AbstractComboRidgetTest.assertEquals((Object)ridget, (Object)selectionEvent.getSource());
        AbstractComboRidgetTest.assertEquals((Object)selectionEvent.getNewSelection(), (Object)selectionEvent2.getOldSelection());
        AbstractComboRidgetTest.assertEquals((Object)ridget.getSelection(), selectionEvent2.getNewSelection().get(0));
        ridget.removeSelectionListener((ISelectionListener)selectionListener);
        UITestHelper.sendKeyAction((Display)control.getDisplay(), (int)0x1000002);
        UITestHelper.readAndDispatch((Widget)control);
        AbstractComboRidgetTest.assertEquals((int)2, (int)selectionListener.getCount());
    }

    public void testSelectionListenerWithObjectsOtherThanString() {
        AbstractComboRidget ridget = this.getRidget();
        WritableList options = new WritableList();
        options.add((Object)this.selection1);
        options.add((Object)this.selection2);
        WritableValue selection = new WritableValue(null, Person.class);
        ridget.bindToModel((IObservableList)options, Person.class, null, (IObservableValue)selection);
        ridget.updateFromModel();
        FTValueChangeListener valueListener = new FTValueChangeListener();
        selection.addValueChangeListener((IValueChangeListener)valueListener);
        FTSelectionListener selectionListener = new FTSelectionListener();
        ridget.addSelectionListener((ISelectionListener)selectionListener);
        AbstractComboRidgetTest.assertEquals((int)0, (int)valueListener.getCount());
        AbstractComboRidgetTest.assertEquals((int)0, (int)selectionListener.getCount());
        ridget.setSelection((Object)this.selection1);
        AbstractComboRidgetTest.assertEquals((int)1, (int)valueListener.getCount());
        AbstractComboRidgetTest.assertEquals((Object)this.selection1, (Object)selection.getValue());
        AbstractComboRidgetTest.assertEquals((int)1, (int)selectionListener.getCount());
        AbstractComboRidgetTest.assertEquals((Object)this.selection1, (Object)ridget.getSelection());
    }

    public void testChangeSelectionViaAPIWhenRidgetIsOutputOnly() {
        AbstractComboRidget ridget = this.getRidget();
        Control control = this.getWidget();
        WritableList options = new WritableList();
        options.add((Object)this.selection1);
        options.add((Object)this.selection2);
        WritableValue selection = new WritableValue(null, Person.class);
        ridget.setUIControl((Object)control);
        ridget.bindToModel((IObservableList)options, Person.class, null, (IObservableValue)selection);
        ridget.updateFromModel();
        ridget.setOutputOnly(true);
        AbstractComboRidgetTest.assertEquals((String)"", (String)this.getText(control));
        AbstractComboRidgetTest.assertEquals(null, (Object)ridget.getSelection());
        AbstractComboRidgetTest.assertEquals(null, (Object)selection.getValue());
        ridget.setSelection((Object)this.selection1);
        AbstractComboRidgetTest.assertEquals((String)this.selection1.toString(), (String)this.getText(control));
        AbstractComboRidgetTest.assertEquals((Object)this.selection1, (Object)ridget.getSelection());
        AbstractComboRidgetTest.assertEquals((Object)this.selection1, (Object)selection.getValue());
    }

    public void testChangeSelectionViaBeanWhenRidgetIsOutputOnly() {
        AbstractComboRidget ridget = this.getRidget();
        Control control = this.getWidget();
        WritableList options = new WritableList();
        options.add((Object)this.selection1);
        options.add((Object)this.selection2);
        WritableValue selection = new WritableValue(null, Person.class);
        ridget.setUIControl((Object)control);
        ridget.bindToModel((IObservableList)options, Person.class, null, (IObservableValue)selection);
        ridget.updateFromModel();
        ridget.setOutputOnly(true);
        AbstractComboRidgetTest.assertEquals((String)"", (String)this.getText(control));
        AbstractComboRidgetTest.assertEquals(null, (Object)ridget.getSelection());
        AbstractComboRidgetTest.assertEquals(null, (Object)selection.getValue());
        selection.setValue((Object)this.selection1);
        ridget.updateFromModel();
        AbstractComboRidgetTest.assertEquals((String)this.selection1.toString(), (String)this.getText(control));
        AbstractComboRidgetTest.assertEquals((Object)this.selection1, (Object)ridget.getSelection());
        AbstractComboRidgetTest.assertEquals((Object)this.selection1, (Object)selection.getValue());
    }

    private void checkPersonList(PersonManager manager) {
        Control control = this.getWidget();
        AbstractComboRidgetTest.assertEquals((int)manager.getPersons().size(), (int)this.getItemCount(control));
        ArrayList<String> listEntries = new ArrayList<String>();
        for (Person person : manager.getPersons()) {
            listEntries.add(person.getListEntry());
        }
        int i = 0;
        while (i < this.getItemCount(control)) {
            String item = this.getItem(control, i);
            if (!listEntries.contains(item)) {
                AbstractComboRidgetTest.fail();
            }
            ++i;
        }
    }

    private Collection<Person> createPersonList() {
        ArrayList<Person> newList = new ArrayList<Person>();
        Person person = new Person("Doe", "John");
        person.setEyeColor(1);
        newList.add(person);
        person = new Person("Jackson", "Janet");
        person.setEyeColor(1);
        newList.add(person);
        person = new Person("Jackson", "Jermaine");
        person.setEyeColor(1);
        newList.add(person);
        person = new Person("Jackson", "John");
        person.setEyeColor(3);
        newList.add(person);
        person = new Person("JJ Jr. Shabadoo", "Joey");
        person.setEyeColor(3);
        newList.add(person);
        person = new Person("Johnson", "Jack");
        person.setEyeColor(2);
        newList.add(person);
        person = new Person("Johnson", "Jane");
        person.setEyeColor(3);
        newList.add(person);
        person = new Person("Zappa", "Frank");
        person.setEyeColor(2);
        newList.add(person);
        return newList;
    }

    private boolean find(PersonManager manager, String item) {
        boolean result = false;
        Iterator iter = manager.getPersons().iterator();
        while (!result && iter.hasNext()) {
            result = ((Person)iter.next()).toString().equals(item);
        }
        return result;
    }

    private static String getInitials(Person person) {
        if (person == null) {
            return null;
        }
        String first = person.getFirstname();
        String last = person.getLastname();
        String f = first.length() > 0 ? String.valueOf(first.charAt(0)) : "?";
        String l = last.length() > 0 ? String.valueOf(last.charAt(0)) : "?";
        return String.valueOf(f) + l;
    }

    private String getItem(Control control, int index) {
        if (control instanceof Combo) {
            return ((Combo)control).getItem(index);
        }
        if (control instanceof CCombo) {
            return ((CCombo)control).getItem(index);
        }
        throw new IllegalArgumentException("unknown widget type: " + control);
    }

    private int getItemCount(Control control) {
        if (control instanceof Combo) {
            return ((Combo)control).getItemCount();
        }
        if (control instanceof CCombo) {
            return ((CCombo)control).getItemCount();
        }
        throw new IllegalArgumentException("unknown widget type: " + control);
    }

    private int getSelectionIndex(Control control) {
        if (control instanceof Combo) {
            return ((Combo)control).getSelectionIndex();
        }
        if (control instanceof CCombo) {
            return ((CCombo)control).getSelectionIndex();
        }
        throw new IllegalArgumentException("unknown widget type: " + control);
    }

    private String getSelectedString(Control control) {
        int index = this.getSelectionIndex(control);
        return index == -1 ? null : this.getItem(control, index);
    }

    private String getText(Control control) {
        if (control instanceof Combo) {
            return ((Combo)control).getText();
        }
        if (control instanceof CCombo) {
            return ((CCombo)control).getText();
        }
        throw new IllegalArgumentException("unknown widget type: " + control);
    }

    private void select(Control control, int index) {
        if (control instanceof Combo) {
            ((Combo)control).select(index);
        } else if (control instanceof CCombo) {
            ((CCombo)control).select(index);
        } else {
            throw new IllegalArgumentException("unknown widget type: " + control);
        }
    }

    private void selectA(Control control) {
        Display display = control.getDisplay();
        if (control instanceof Combo) {
            UITestHelper.sendString((Display)display, (String)"A");
        } else if (control instanceof CCombo) {
            UITestHelper.sendKeyAction((Display)display, (int)0x1000002);
        } else {
            throw new IllegalArgumentException("unknown widget type: " + control);
        }
        UITestHelper.readAndDispatch((Widget)control);
    }

    private static final class FTPropertyChangeListener
    implements PropertyChangeListener {
        private int count;
        private Runnable runnable;

        private FTPropertyChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            ++this.count;
            if (this.runnable != null) {
                this.runnable.run();
            }
        }

        int getCount() {
            return this.count;
        }

        void setRunnable(Runnable runnable) {
            this.runnable = runnable;
        }
    }

    private static class FTSelectionListener
    implements ISelectionListener {
        private int count;

        private FTSelectionListener() {
        }

        public void ridgetSelected(SelectionEvent event) {
            ++this.count;
        }

        int getCount() {
            return this.count;
        }
    }

    private static class FTValueChangeListener
    implements IValueChangeListener {
        private int count;

        private FTValueChangeListener() {
        }

        public void handleValueChange(ValueChangeEvent event) {
            ++this.count;
        }

        int getCount() {
            return this.count;
        }
    }

    private static final class Product {
        private String name;

        public Product(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ProductHolder {
        private List<Product> products;
        private Product selectedProducts;

        private ProductHolder() {
        }

        public void setProducts(List<Product> policenProdukte) {
            this.products = policenProdukte;
        }

        public List<Product> getProducts() {
            return this.products;
        }

        public void setSelectedProducts(Product selectedPolicenProdukt) {
            this.selectedProducts = selectedPolicenProdukt;
        }

        public Product getSelectedProducts() {
            return this.selectedProducts;
        }
    }

    private final class SelectionPropertyChangeEvent
    extends PropertyChangeEvent {
        private static final long serialVersionUID = 4711L;

        public SelectionPropertyChangeEvent(Object oldValue, Object newValue) {
            super(AbstractComboRidgetTest.this.getRidget(), "selection", oldValue, newValue);
        }
    }
}

