/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.navigation.ui.swt.views;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.util.Map;
import org.eclipse.riena.core.util.ReflectionUtils;
import org.eclipse.riena.internal.core.test.RienaTestCase;
import org.eclipse.riena.internal.core.test.collect.UITestCase;
import org.eclipse.riena.ui.swt.ChoiceComposite;
import org.eclipse.riena.ui.swt.lnf.ColorLnfResource;
import org.eclipse.riena.ui.swt.lnf.ILnfResource;
import org.eclipse.riena.ui.swt.lnf.ILnfTheme;
import org.eclipse.riena.ui.swt.lnf.LnFUpdater;
import org.eclipse.riena.ui.swt.lnf.LnfManager;
import org.eclipse.riena.ui.swt.lnf.rienadefault.RienaDefaultLnf;
import org.eclipse.riena.ui.swt.utils.SwtUtilities;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

@UITestCase
public class LnFUpdaterTest
extends RienaTestCase {
    private Shell shell;
    private LnFUpdater lnFUpdater;

    protected void setUp() throws Exception {
        super.setUp();
        this.shell = new Shell();
        this.lnFUpdater = new LnFUpdater();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        SwtUtilities.disposeWidget((Widget)this.shell);
        this.lnFUpdater = null;
    }

    public void testGetErrorMessage() throws IntrospectionException {
        PropertyDescriptor property = this.getForegroundProperty();
        Label label = new Label((Composite)this.shell, 0);
        String message = (String)ReflectionUtils.invokeHidden((Object)this.lnFUpdater, (String)"getErrorMessage", (Object[])new Object[]{label, property});
        LnFUpdaterTest.assertNotNull((Object)message);
        LnFUpdaterTest.assertTrue((message.indexOf(Label.class.getSimpleName()) > 0 ? 1 : 0) != 0);
        LnFUpdaterTest.assertTrue((message.indexOf(property.getName()) > 0 ? 1 : 0) != 0);
        SwtUtilities.disposeWidget((Widget)label);
    }

    public void testGetLnfValue() throws IntrospectionException {
        RienaDefaultLnf oldLnf = LnfManager.getLnf();
        RienaDefaultLnf lnf = new RienaDefaultLnf();
        LnfManager.setLnf((RienaDefaultLnf)lnf);
        try {
            lnf.setTheme((ILnfTheme)new MyTheme());
            Label label = new Label((Composite)this.shell, 0);
            PropertyDescriptor property = this.getForegroundProperty();
            Object value = ReflectionUtils.invokeHidden((Object)this.lnFUpdater, (String)"getLnfValue", (Object[])new Object[]{label, property});
            SwtUtilities.disposeWidget((Widget)label);
            LnFUpdaterTest.assertNotNull((Object)value);
            LnFUpdaterTest.assertTrue((boolean)(value instanceof Color));
            Color color = (Color)value;
            LnFUpdaterTest.assertEquals((int)1, (int)color.getRed());
            LnFUpdaterTest.assertEquals((int)2, (int)color.getGreen());
            LnFUpdaterTest.assertEquals((int)3, (int)color.getBlue());
            lnf.setTheme((ILnfTheme)new MyTheme());
            Text text = new Text((Composite)this.shell, 0);
            value = ReflectionUtils.invokeHidden((Object)this.lnFUpdater, (String)"getLnfValue", (Object[])new Object[]{text, property});
            SwtUtilities.disposeWidget((Widget)text);
            LnFUpdaterTest.assertNull((Object)value);
        }
        finally {
            LnfManager.setLnf((RienaDefaultLnf)oldLnf);
        }
    }

    public void testGetLnfStyleValue() throws IntrospectionException {
        RienaDefaultLnf oldLnf = LnfManager.getLnf();
        RienaDefaultLnf lnf = new RienaDefaultLnf();
        LnfManager.setLnf((RienaDefaultLnf)lnf);
        try {
            lnf.setTheme((ILnfTheme)new MyTheme());
            Label label = new Label((Composite)this.shell, 0);
            label.setData("lnfStyle", (Object)"section");
            PropertyDescriptor property = this.getForegroundProperty();
            Object value = ReflectionUtils.invokeHidden((Object)this.lnFUpdater, (String)"getLnfStyleValue", (Object[])new Object[]{label, property});
            SwtUtilities.disposeWidget((Widget)label);
            LnFUpdaterTest.assertNotNull((Object)value);
            LnFUpdaterTest.assertTrue((boolean)(value instanceof Color));
            Color color = (Color)value;
            LnFUpdaterTest.assertEquals((int)111, (int)color.getRed());
            LnFUpdaterTest.assertEquals((int)22, (int)color.getGreen());
            LnFUpdaterTest.assertEquals((int)3, (int)color.getBlue());
            lnf.setTheme((ILnfTheme)new MyTheme());
            label = new Label((Composite)this.shell, 0);
            label.setData("lnfStyle", (Object)"dummy");
            value = ReflectionUtils.invokeHidden((Object)this.lnFUpdater, (String)"getLnfStyleValue", (Object[])new Object[]{label, property});
            SwtUtilities.disposeWidget((Widget)label);
            LnFUpdaterTest.assertNull((Object)value);
            lnf.setTheme((ILnfTheme)new MyTheme());
            Text text = new Text((Composite)this.shell, 0);
            text.setData("lnfStyle", (Object)"section");
            value = ReflectionUtils.invokeHidden((Object)this.lnFUpdater, (String)"getLnfStyleValue", (Object[])new Object[]{text, property});
            SwtUtilities.disposeWidget((Widget)label);
            LnFUpdaterTest.assertNotNull((Object)value);
            LnFUpdaterTest.assertTrue((boolean)(value instanceof Color));
            color = (Color)value;
            LnFUpdaterTest.assertEquals((int)111, (int)color.getRed());
            LnFUpdaterTest.assertEquals((int)22, (int)color.getGreen());
            LnFUpdaterTest.assertEquals((int)3, (int)color.getBlue());
        }
        finally {
            LnfManager.setLnf((RienaDefaultLnf)oldLnf);
        }
    }

    public void testCheckUpdateAfterBind() {
        Composite comp1 = new Composite((Composite)this.shell, 0);
        Label label1 = new Label(comp1, 0);
        boolean retValue = (Boolean)ReflectionUtils.invokeHidden((Object)this.lnFUpdater, (String)"checkUpdateAfterBind", (Object[])new Object[]{label1});
        LnFUpdaterTest.assertFalse((boolean)retValue);
        ChoiceComposite choiceComp1 = new ChoiceComposite(comp1, 0, false);
        retValue = (Boolean)ReflectionUtils.invokeHidden((Object)this.lnFUpdater, (String)"checkUpdateAfterBind", (Object[])new Object[]{choiceComp1});
        LnFUpdaterTest.assertTrue((boolean)retValue);
        Label label2 = new Label((Composite)choiceComp1, 0);
        retValue = (Boolean)ReflectionUtils.invokeHidden((Object)this.lnFUpdater, (String)"checkUpdateAfterBind", (Object[])new Object[]{label2});
        LnFUpdaterTest.assertTrue((boolean)retValue);
    }

    public void testCheckPropertyUpdateView() {
        boolean retValue = (Boolean)ReflectionUtils.invokeHidden((Object)this.lnFUpdater, (String)"checkPropertyUpdateView", (Object[])new Object[0]);
        LnFUpdaterTest.assertFalse((boolean)retValue);
        System.setProperty("riena.lnf.update.view", "abc");
        retValue = (Boolean)ReflectionUtils.invokeHidden((Object)this.lnFUpdater, (String)"checkPropertyUpdateView", (Object[])new Object[0]);
        LnFUpdaterTest.assertFalse((boolean)retValue);
        System.setProperty("riena.lnf.update.view", "true");
        retValue = (Boolean)ReflectionUtils.invokeHidden((Object)this.lnFUpdater, (String)"checkPropertyUpdateView", (Object[])new Object[0]);
        LnFUpdaterTest.assertTrue((boolean)retValue);
        System.setProperty("riena.lnf.update.view", "false");
        retValue = (Boolean)ReflectionUtils.invokeHidden((Object)this.lnFUpdater, (String)"checkPropertyUpdateView", (Object[])new Object[0]);
        LnFUpdaterTest.assertFalse((boolean)retValue);
    }

    public void testUpdateUIControl() {
        RienaDefaultLnf oldLnf = LnfManager.getLnf();
        try {
            RienaDefaultLnf lnf = new RienaDefaultLnf();
            LnfManager.setLnf((RienaDefaultLnf)lnf);
            lnf.setTheme((ILnfTheme)new MyTheme());
            Label label = new Label((Composite)this.shell, 0);
            ReflectionUtils.invokeHidden((Object)this.lnFUpdater, (String)"updateUIControl", (Object[])new Object[]{label});
            Color labelColor = label.getForeground();
            Color themeColor = lnf.getColor("Label.foreground");
            LnFUpdaterTest.assertEquals((Object)themeColor, (Object)labelColor);
        }
        finally {
            LnfManager.setLnf((RienaDefaultLnf)oldLnf);
        }
    }

    public void testGetDefaultPropertyValue() throws IntrospectionException {
        Label label = new Label((Composite)this.shell, 0);
        PropertyDescriptor foregroundProperty = new PropertyDescriptor("foreground", Label.class);
        Object value = ReflectionUtils.invokeHidden((Object)this.lnFUpdater, (String)"getDefaultPropertyValue", (Object[])new Object[]{label, foregroundProperty});
        LnFUpdaterTest.assertEquals((Object)label.getForeground(), (Object)value);
    }

    public void testGetPropertyValue() throws IntrospectionException {
        Label label = new Label((Composite)this.shell, 0);
        label.setAlignment(131072);
        PropertyDescriptor property = new PropertyDescriptor("alignment", Label.class);
        Object value = ReflectionUtils.invokeHidden((Object)this.lnFUpdater, (String)"getPropertyValue", (Object[])new Object[]{label, property});
        LnFUpdaterTest.assertEquals((Object)131072, (Object)value);
    }

    public void testHasNoDefaultValue() throws IntrospectionException {
        Label label = new Label((Composite)this.shell, 0);
        PropertyDescriptor property = new PropertyDescriptor("text", Label.class);
        Boolean ret = (Boolean)ReflectionUtils.invokeHidden((Object)this.lnFUpdater, (String)"hasNoDefaultValue", (Object[])new Object[]{label, property});
        LnFUpdaterTest.assertFalse((boolean)ret);
        label.setText("Hello!");
        ret = (Boolean)ReflectionUtils.invokeHidden((Object)this.lnFUpdater, (String)"hasNoDefaultValue", (Object[])new Object[]{label, property});
        LnFUpdaterTest.assertTrue((boolean)ret);
    }

    public void testGetSimpleClassName() {
        Class controlClass = Label.class;
        String className = (String)ReflectionUtils.invokeHidden((Object)this.lnFUpdater, (String)"getSimpleClassName", (Object[])new Object[]{controlClass});
        LnFUpdaterTest.assertEquals((String)Label.class.getSimpleName(), (String)className);
        Composite innerControl = new Composite((Composite)this.shell, 0){

            public boolean setFocus() {
                return true;
            }
        };
        controlClass = innerControl.getClass();
        className = (String)ReflectionUtils.invokeHidden((Object)this.lnFUpdater, (String)"getSimpleClassName", (Object[])new Object[]{controlClass});
        LnFUpdaterTest.assertEquals((String)Composite.class.getSimpleName(), (String)className);
    }

    public void testCheckLnfKeys() {
        RienaDefaultLnf oldLnf = LnfManager.getLnf();
        try {
            RienaDefaultLnf lnf = new RienaDefaultLnf();
            LnfManager.setLnf((RienaDefaultLnf)lnf);
            ILnfTheme oldTheme = lnf.getTheme();
            MyTheme myTheme = new MyTheme();
            lnf.setTheme((ILnfTheme)myTheme);
            Label label = new Label((Composite)this.shell, 0);
            boolean ret = (Boolean)ReflectionUtils.invokeHidden((Object)this.lnFUpdater, (String)"checkLnfKeys", (Object[])new Object[]{label});
            lnf.setTheme(oldTheme);
            SwtUtilities.disposeWidget((Widget)label);
            LnFUpdaterTest.assertTrue((boolean)ret);
            lnf.setTheme((ILnfTheme)myTheme);
            Text text = new Text((Composite)this.shell, 0);
            ret = (Boolean)ReflectionUtils.invokeHidden((Object)this.lnFUpdater, (String)"checkLnfKeys", (Object[])new Object[]{text});
            lnf.setTheme(oldTheme);
            SwtUtilities.disposeWidget((Widget)text);
            LnFUpdaterTest.assertFalse((boolean)ret);
        }
        finally {
            LnfManager.setLnf((RienaDefaultLnf)oldLnf);
        }
    }

    private PropertyDescriptor getForegroundProperty() throws IntrospectionException {
        PropertyDescriptor[] properties;
        BeanInfo beanInfo = Introspector.getBeanInfo(Label.class);
        PropertyDescriptor[] propertyDescriptorArray = properties = beanInfo.getPropertyDescriptors();
        int n = properties.length;
        int n2 = 0;
        while (n2 < n) {
            PropertyDescriptor property = propertyDescriptorArray[n2];
            if (property.getName().equals("foreground")) {
                return property;
            }
            ++n2;
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MyTheme
    implements ILnfTheme {
        private MyTheme() {
        }

        public void addCustomColors(Map<String, ILnfResource> table) {
            table.put("Label.foreground", (ILnfResource)new ColorLnfResource(1, 2, 3));
            table.put("section.foreground", (ILnfResource)new ColorLnfResource(111, 22, 3));
        }

        public void addCustomFonts(Map<String, ILnfResource> table) {
        }

        public void addCustomImages(Map<String, ILnfResource> table) {
        }

        public void addCustomSettings(Map<String, Object> table) {
        }
    }
}

