/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.ui.ridgets.swt;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.core.databinding.beans.BeansObservables;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.riena.internal.ui.ridgets.swt.MarkerSupport;
import org.eclipse.riena.ui.ridgets.ITextRidget;
import org.eclipse.riena.ui.ridgets.swt.AbstractEditableRidget;
import org.eclipse.riena.ui.ridgets.swt.AbstractSWTRidget;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class TextRidget
extends AbstractEditableRidget
implements ITextRidget {
    private static final String EMPTY_STRING = "";
    protected final FocusListener focusListener;
    protected final KeyListener crKeyListener = new CRKeyListener();
    protected final ModifyListener modifyListener;
    protected final ValidationListener verifyListener;
    private String textValue = "";
    private boolean isDirectWriting = false;

    public TextRidget() {
        this.focusListener = new FocusManager();
        this.modifyListener = new SyncModifyListener();
        this.verifyListener = new ValidationListener();
        this.addPropertyChangeListener("enabled", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                TextRidget.this.forceTextToControl(TextRidget.this.getTextInternal());
            }
        });
        this.addPropertyChangeListener("output", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                TextRidget.this.updateEditable();
            }
        });
    }

    protected TextRidget(String initialValue) {
        this();
        Assert.isNotNull((Object)initialValue);
        this.textValue = initialValue;
    }

    protected IObservableValue getRidgetObservable() {
        return BeansObservables.observeValue((Object)((Object)this), (String)"text");
    }

    protected void checkUIControl(Object uiControl) {
        AbstractSWTRidget.assertType(uiControl, Text.class);
    }

    protected boolean isNotEmpty(String input) {
        return input.length() > 0;
    }

    protected final synchronized void bindUIControl() {
        Control control = this.getUIControl();
        if (control != null) {
            this.setUIText(this.getTextBasedOnEnablement(this.textValue));
            this.updateEditable();
            this.addListeners(control);
        }
    }

    protected final synchronized void unbindUIControl() {
        super.unbindUIControl();
        Control control = this.getUIControl();
        if (control != null) {
            this.removeListeners(control);
        }
    }

    protected synchronized void addListeners(Control control) {
        Text text = (Text)control;
        text.addKeyListener(this.crKeyListener);
        text.addFocusListener(this.focusListener);
        text.addModifyListener(this.modifyListener);
        text.addVerifyListener((VerifyListener)this.verifyListener);
    }

    protected synchronized void removeListeners(Control control) {
        Text text = (Text)control;
        text.removeKeyListener(this.crKeyListener);
        text.removeFocusListener(this.focusListener);
        text.removeModifyListener(this.modifyListener);
        text.removeVerifyListener((VerifyListener)this.verifyListener);
    }

    protected String getUIText() {
        return this.getTextWidget().getText();
    }

    protected void updateEditable() {
        Text control = this.getTextWidget();
        if (control != null && !control.isDisposed()) {
            control.setEditable(!this.isOutputOnly());
        }
    }

    protected void setUIText(String text) {
        this.getTextWidget().setText(text);
        this.getTextWidget().setSelection(0, 0);
    }

    protected void selectAll() {
        Text text = this.getTextWidget();
        if ((text.getStyle() & 2) == 0) {
            text.selectAll();
        }
    }

    public synchronized String getText() {
        return this.textValue;
    }

    public synchronized void setText(String text) {
        String oldValue = this.textValue;
        this.textValue = text != null ? text : EMPTY_STRING;
        this.forceTextToControl(this.textValue);
        this.disableMandatoryMarkers(this.isNotEmpty(this.textValue));
        IStatus onEdit = this.checkOnEditRules(this.textValue, new AbstractEditableRidget.ValidationCallback(this, false));
        if (onEdit.isOK()) {
            this.firePropertyChange("text", oldValue, this.textValue);
            this.firePropertyChange("textAfter", oldValue, this.textValue);
        }
    }

    public synchronized boolean revalidate() {
        if (this.getUIControl() != null) {
            this.textValue = this.getUIText();
        }
        this.forceTextToControl(this.textValue);
        this.disableMandatoryMarkers(this.isNotEmpty(this.textValue));
        IStatus status = this.checkAllRules(this.textValue, new AbstractEditableRidget.ValidationCallback(this, false));
        if (status.isOK()) {
            this.getValueBindingSupport().updateFromTarget();
        }
        return !this.isErrorMarked();
    }

    public synchronized void updateFromModel() {
        super.updateFromModel();
        this.checkAllRules(this.textValue, new AbstractEditableRidget.ValidationCallback(this, false));
    }

    public synchronized boolean isDirectWriting() {
        return this.isDirectWriting;
    }

    public synchronized void setDirectWriting(boolean directWriting) {
        if (this.isDirectWriting != directWriting) {
            this.isDirectWriting = directWriting;
        }
    }

    public final boolean isDisableMandatoryMarker() {
        return this.isNotEmpty(this.textValue);
    }

    public int getAlignment() {
        throw new UnsupportedOperationException("not implemented");
    }

    public final void setAlignment(int alignment) {
        throw new UnsupportedOperationException("not supported");
    }

    private String getTextBasedOnEnablement(String value) {
        boolean hideValue = !this.isEnabled() && MarkerSupport.HIDE_DISABLED_RIDGET_CONTENT;
        return hideValue ? EMPTY_STRING : value;
    }

    private synchronized void forceTextToControl(String newValue) {
        Control control = this.getUIControl();
        if (control != null) {
            Listener listener;
            Listener[] listeners;
            Listener[] listenerArray = listeners = control.getListeners(25);
            int n = listeners.length;
            int n2 = 0;
            while (n2 < n) {
                listener = listenerArray[n2];
                control.removeListener(25, listener);
                ++n2;
            }
            this.setUIText(this.getTextBasedOnEnablement(newValue));
            listenerArray = listeners;
            n = listeners.length;
            n2 = 0;
            while (n2 < n) {
                listener = listenerArray[n2];
                control.addListener(25, listener);
                ++n2;
            }
        }
    }

    private synchronized String getTextInternal() {
        return this.textValue;
    }

    private Text getTextWidget() {
        return (Text)this.getUIControl();
    }

    private synchronized void updateTextValue() {
        String oldValue = this.textValue;
        String newValue = this.getUIText();
        if (!oldValue.equals(newValue)) {
            this.textValue = newValue;
            if (this.checkOnEditRules(newValue, null).isOK()) {
                this.firePropertyChange("text", oldValue, newValue);
                this.firePropertyChange("textAfter", oldValue, newValue);
            }
        }
    }

    private synchronized void updateTextValueWhenDirectWriting() {
        if (this.isDirectWriting) {
            this.updateTextValue();
        }
    }

    private final class CRKeyListener
    extends KeyAdapter
    implements KeyListener {
        private CRKeyListener() {
        }

        public void keyReleased(KeyEvent e) {
            if (e.character == '\r') {
                TextRidget.this.updateTextValue();
            }
        }
    }

    private final class FocusManager
    implements FocusListener {
        private FocusManager() {
        }

        public void focusGained(FocusEvent e) {
            if (TextRidget.this.isFocusable() && !TextRidget.this.isOutputOnly()) {
                TextRidget.this.selectAll();
            }
        }

        public void focusLost(FocusEvent e) {
            TextRidget.this.updateTextValue();
        }
    }

    private final class SyncModifyListener
    implements ModifyListener {
        private SyncModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            TextRidget.this.updateTextValueWhenDirectWriting();
            String text = TextRidget.this.getUIText();
            TextRidget.this.disableMandatoryMarkers(TextRidget.this.isNotEmpty(text));
        }
    }

    private final class ValidationListener
    implements VerifyListener {
        private ValidationListener() {
        }

        public synchronized void verifyText(VerifyEvent e) {
            boolean doit;
            if (!e.doit) {
                return;
            }
            String newText = this.getText(e);
            IStatus status = TextRidget.this.checkOnEditRules(newText, new AbstractEditableRidget.ValidationCallback(TextRidget.this, true));
            e.doit = doit = status.getCode() != 1024;
        }

        private String getText(VerifyEvent e) {
            String oldText = TextRidget.this.getUIText();
            String newText = e.keyCode == 127 || e.keyCode == 8 ? String.valueOf(oldText.substring(0, e.start)) + oldText.substring(e.end) : String.valueOf(oldText.substring(0, e.start)) + e.text + oldText.substring(e.end);
            return newText;
        }
    }
}

