/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.ridgets.swt;

import java.net.URL;
import org.eclipse.core.databinding.beans.BeansObservables;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.riena.internal.ui.ridgets.swt.BasicMarkerSupport;
import org.eclipse.riena.ui.ridgets.AbstractMarkerSupport;
import org.eclipse.riena.ui.ridgets.ILabelRidget;
import org.eclipse.riena.ui.ridgets.swt.AbstractValueRidget;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;

public abstract class AbstractLabelRidget
extends AbstractValueRidget
implements ILabelRidget {
    private static final String EMPTY_STRING = "";
    private String text;
    private String icon;
    private URL iconLocation;
    private boolean textAlreadyInitialized = false;
    private boolean useRidgetIcon = false;

    protected AbstractMarkerSupport createMarkerSupport() {
        return new BasicMarkerSupport(this, this.propertyChangeSupport);
    }

    protected IObservableValue getRidgetObservable() {
        return BeansObservables.observeValue((Object)((Object)this), (String)"text");
    }

    protected void bindUIControl() {
        this.initText();
        this.updateUIText();
        this.updateUIIcon();
    }

    private void initText() {
        Control control;
        if (this.text == null && !this.textAlreadyInitialized && (control = this.getUIControl()) != null && !control.isDisposed()) {
            this.text = this.getUIControlText();
            if (this.text == null) {
                this.text = EMPTY_STRING;
            }
            this.textAlreadyInitialized = true;
        }
    }

    public String getIcon() {
        return this.icon;
    }

    public URL getIconLocation() {
        return this.iconLocation;
    }

    public String getText() {
        return this.text;
    }

    public boolean isDisableMandatoryMarker() {
        return true;
    }

    public void setIcon(String icon) {
        boolean oldUseRidgetIcon = this.useRidgetIcon;
        this.useRidgetIcon = true;
        String oldIcon = this.icon;
        this.icon = icon;
        if (this.hasChanged(oldIcon, icon) || !oldUseRidgetIcon) {
            this.updateUIIcon();
        }
    }

    public void setIconLocation(URL location) {
        this.useRidgetIcon = true;
        URL oldUrl = this.iconLocation;
        this.iconLocation = location;
        if (this.hasChanged(oldUrl, location)) {
            this.updateUIIcon();
        }
    }

    public void setText(String text) {
        String oldValue = this.text;
        this.text = text;
        this.updateUIText();
        this.firePropertyChange("text", oldValue, this.text);
    }

    protected abstract String getUIControlText();

    private void updateUIText() {
        if (this.getUIControl() != null) {
            this.setUIControlText(this.text);
        }
    }

    protected abstract void setUIControlText(String var1);

    private void updateUIIcon() {
        if (this.getUIControl() != null) {
            Image image = null;
            if (this.icon != null) {
                image = this.getManagedImage(this.icon);
            } else if (this.iconLocation != null) {
                String key = this.iconLocation.toExternalForm();
                image = this.getManagedImage(key);
            }
            if (image != null || this.useRidgetIcon) {
                this.setUIControlImage(image);
            }
        }
    }

    protected abstract void setUIControlImage(Image var1);

    private boolean hasChanged(URL oldValue, URL newValue) {
        String str2;
        if (oldValue == null && newValue == null) {
            return false;
        }
        if (oldValue == null || newValue == null) {
            return true;
        }
        String str1 = oldValue.toExternalForm();
        return !str1.equals(str2 = newValue.toExternalForm());
    }
}

