/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.ridgets;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.eclipse.core.runtime.Assert;
import org.eclipse.riena.core.util.ListenerList;
import org.eclipse.riena.ui.ridgets.IRidget;
import org.eclipse.riena.ui.ridgets.listener.FocusEvent;
import org.eclipse.riena.ui.ridgets.listener.IFocusListener;

public abstract class AbstractRidget
implements IRidget {
    public static final String PROPERTY_RIDGET = "ridget";
    protected PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private ListenerList<IFocusListener> focusListeners = new ListenerList(IFocusListener.class);
    protected boolean savedVisibleState = true;

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.addPropertyChangeListener(null, propertyChangeListener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener propertyChangeListener) {
        Assert.isNotNull((Object)propertyChangeListener);
        if (!this.hasListener(propertyName, propertyChangeListener)) {
            if (propertyName == null) {
                this.propertyChangeSupport.addPropertyChangeListener(propertyChangeListener);
            } else {
                this.propertyChangeSupport.addPropertyChangeListener(propertyName, propertyChangeListener);
            }
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.removePropertyChangeListener(null, propertyChangeListener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener propertyChangeListener) {
        Assert.isNotNull((Object)propertyChangeListener);
        if (propertyName == null) {
            this.propertyChangeSupport.removePropertyChangeListener(propertyChangeListener);
        } else {
            this.propertyChangeSupport.removePropertyChangeListener(propertyName, propertyChangeListener);
        }
    }

    public void addFocusListener(IFocusListener listener) {
        this.focusListeners.add((Object)listener);
    }

    public void removeFocusListener(IFocusListener listener) {
        this.focusListeners.remove((Object)listener);
    }

    public void updateFromModel() {
    }

    public final boolean isBlocked() {
        return false;
    }

    public final void setBlocked(boolean blocked) {
    }

    protected final void fireFocusLost(FocusEvent event) {
        IFocusListener[] iFocusListenerArray = (IFocusListener[])this.focusListeners.getListeners();
        int n = iFocusListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            IFocusListener focusListener = iFocusListenerArray[n2];
            focusListener.focusLost(event);
            ++n2;
        }
    }

    protected final void fireFocusGained(FocusEvent event) {
        IFocusListener[] iFocusListenerArray = (IFocusListener[])this.focusListeners.getListeners();
        int n = iFocusListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            IFocusListener focusListener = iFocusListenerArray[n2];
            focusListener.focusGained(event);
            ++n2;
        }
    }

    protected final void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
        this.propertyChangeSupport.firePropertyChange(propertyName, oldValue, newValue);
    }

    protected final void firePropertyChange(String propertyName, int oldValue, int newValue) {
        this.propertyChangeSupport.firePropertyChange(propertyName, oldValue, newValue);
    }

    protected final void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        this.propertyChangeSupport.firePropertyChange(propertyName, oldValue, newValue);
    }

    private boolean hasListener(String propertyName, Object listener) {
        boolean result = false;
        PropertyChangeListener[] listeners = this.propertyChangeSupport.getPropertyChangeListeners(propertyName);
        int i = 0;
        while (!result && i < listeners.length) {
            result = listeners[i] == listener;
            ++i;
        }
        return result;
    }
}

