/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.ridgets.uibinding;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.riena.core.wire.InjectExtension;
import org.eclipse.riena.ui.ridgets.ILabelRidget;
import org.eclipse.riena.ui.ridgets.IRidget;
import org.eclipse.riena.ui.ridgets.IRidgetContainer;
import org.eclipse.riena.ui.ridgets.uibinding.ICorrespondingLabelExtension;
import org.eclipse.riena.ui.ridgets.uibinding.ILabelFinderStrategy;
import org.eclipse.riena.ui.ridgets.uibinding.ILabelFinderStrategyExtension;

public class CorrespondingLabelMapper {
    private final IRidgetContainer ridgetContainer;
    private String labelPrefix = "label";
    private ILabelFinderStrategy labelFinderStrategy;

    public CorrespondingLabelMapper(IRidgetContainer ridgetContainer) {
        this.ridgetContainer = ridgetContainer;
        this.labelFinderStrategy = new DefaultLabelFinderStrategy();
    }

    @InjectExtension(min=0, max=1)
    public void setCorrespondingLabelConfig(ICorrespondingLabelExtension labelProperties) {
        if (labelProperties != null && labelProperties.getLabelPrefix() != null) {
            this.labelPrefix = labelProperties.getLabelPrefix();
        }
    }

    @InjectExtension(min=0, max=1)
    public void setLabelFinderStrategy(ILabelFinderStrategyExtension strategyProperties) {
        ILabelFinderStrategy customLabelFinderStrategy;
        if (strategyProperties != null && (customLabelFinderStrategy = strategyProperties.createFinderStrategy()) != null) {
            this.labelFinderStrategy = customLabelFinderStrategy;
            return;
        }
        this.labelFinderStrategy = new DefaultLabelFinderStrategy();
    }

    public boolean connectCorrespondingLabel(final IRidget ridget, String ridgetId) {
        final ILabelRidget labelRidget = this.labelFinderStrategy.findLabelRidget(this.ridgetContainer, ridgetId);
        if (labelRidget == null) {
            return false;
        }
        ridget.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if ("enabled".equals(evt.getPropertyName())) {
                    labelRidget.setEnabled(ridget.isEnabled());
                }
            }
        });
        return true;
    }

    private class DefaultLabelFinderStrategy
    implements ILabelFinderStrategy {
        private DefaultLabelFinderStrategy() {
        }

        public ILabelRidget findLabelRidget(IRidgetContainer iridgetContainer, String ridgetID) {
            String labelID = String.valueOf(CorrespondingLabelMapper.this.labelPrefix) + ridgetID;
            IRidget labelRidget = iridgetContainer.getRidget(labelID);
            if (labelRidget != null && labelRidget instanceof ILabelRidget) {
                return (ILabelRidget)labelRidget;
            }
            return null;
        }
    }
}

