/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.swt;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.util.Util;
import org.eclipse.riena.ui.swt.utils.SwtUtilities;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class DatePickerComposite
extends Composite {
    private static final int BUTTON_WIDTH = 16;
    private static final int BUTTON_HEIGHT = 16;
    private final Text textfield;
    private final Button pickerButton;
    private final DatePicker datePicker;
    private IDateConverterStrategy dateConverterStrategy;

    public DatePickerComposite(Composite parent, int textStyles) {
        super(parent, 2048);
        GridLayoutFactory.fillDefaults().numColumns(2).spacing(0, 0).applyTo((Composite)this);
        this.textfield = new Text((Composite)this, this.checkStyle(textStyles));
        this.setBackground(this.getDisplay().getSystemColor(1));
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)this.textfield);
        this.pickerButton = new Button((Composite)this, 1028);
        this.pickerButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!DatePickerComposite.this.textfield.isEnabled() || !DatePickerComposite.this.textfield.getEditable()) {
                    return;
                }
                if (!DatePickerComposite.this.datePicker.isVisible()) {
                    Point p = DatePickerComposite.this.textfield.toDisplay(((DatePickerComposite)DatePickerComposite.this).textfield.getLocation().x, ((DatePickerComposite)DatePickerComposite.this).textfield.getLocation().y);
                    DatePickerComposite.this.datePicker.setLocation(p.x, p.y + ((DatePickerComposite)DatePickerComposite.this).textfield.getBounds().height);
                    DatePickerComposite.this.datePicker.open(DatePickerComposite.this.parseDate(DatePickerComposite.this.textfield.getText()));
                } else {
                    DatePickerComposite.this.datePicker.close();
                }
            }
        });
        GridDataFactory.fillDefaults().grab(false, false).align(131072, 4).hint(16, 16).applyTo((Control)this.pickerButton);
        this.datePicker = new DatePicker(this);
        this.dateConverterStrategy = new RegexDateConverterStrategy(this.textfield);
    }

    public IDateConverterStrategy getDateConverterStrategy() {
        return this.dateConverterStrategy;
    }

    public void setDateConverterStrategy(IDateConverterStrategy dateConverterStrategy) {
        this.dateConverterStrategy = dateConverterStrategy;
    }

    public Text getTextfield() {
        return this.textfield;
    }

    public void dispose() {
        this.datePicker.dispose();
        super.dispose();
    }

    private int checkStyle(int style) {
        if ((style & 0x800) != 0) {
            style &= 0xFFFFF7FF;
        }
        return style;
    }

    private Button getPickerButton() {
        return this.pickerButton;
    }

    private Calendar parseDate(String dateString) {
        Calendar result = null;
        Date date = this.getDateConverterStrategy().getDateFromTextField(dateString);
        if (date != null) {
            result = Calendar.getInstance();
            result.setTime(date);
        }
        return result;
    }

    private static final class DatePicker {
        private static final int WIN32_CALENDAR_HEADER_HEIGHT = 45;
        private Shell shell;
        private DateTime calendar;
        private DatePickerComposite datePicker;

        protected DatePicker(final DatePickerComposite datePicker) {
            this.datePicker = datePicker;
            this.shell = new Shell(datePicker.getPickerButton().getDisplay(), 16392);
            this.shell.setBackground(this.shell.getDisplay().getSystemColor(2));
            GridLayoutFactory.fillDefaults().margins(1, 1).applyTo((Composite)this.shell);
            this.calendar = new DateTime((Composite)this.shell, 33792);
            this.calendar.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, true));
            this.shell.pack();
            this.calendar.addMouseListener((MouseListener)new MouseAdapter(){
                int win32clicks = this.init();

                public void mouseUp(MouseEvent e) {
                    if (e.button != 1) {
                        return;
                    }
                    if (Util.isWin32()) {
                        this.win32clicks = e.y < 45 ? Math.min(4, this.win32clicks + 1) : Math.max(this.win32clicks - 1, 0);
                    }
                    if (this.win32clicks == 0) {
                        Calendar cal = Calendar.getInstance();
                        cal.set(1, DatePicker.this.calendar.getYear());
                        cal.set(2, DatePicker.this.calendar.getMonth());
                        cal.set(5, DatePicker.this.calendar.getDay());
                        DatePicker.this.setDateToTextfield(cal.getTime());
                        this.win32clicks = this.init();
                        DatePicker.this.close();
                    }
                }

                private int init() {
                    return Util.isWin32() ? 1 : 0;
                }
            });
            this.calendar.addFocusListener((FocusListener)new FocusAdapter(){

                public void focusLost(FocusEvent e) {
                    Display display = e.widget.getDisplay();
                    Control focusControl = display.getCursorControl();
                    if (focusControl != datePicker.getPickerButton()) {
                        DatePicker.this.close();
                    }
                }
            });
        }

        public void dispose() {
            if (!SwtUtilities.isDisposed((Widget)this.shell)) {
                this.shell.dispose();
            }
        }

        public void setLocation(int x, int y) {
            this.shell.setLocation(x, y);
        }

        public boolean isVisible() {
            return this.shell.isVisible();
        }

        public void close() {
            this.shell.setVisible(false);
        }

        public void open(Calendar newDate) {
            if (this.isVisible()) {
                return;
            }
            this.shell.open();
            this.shell.setVisible(true);
            if (newDate == null) {
                newDate = Calendar.getInstance();
                newDate.setTime(new Date());
            }
            this.calendar.setYear(newDate.get(1));
            this.calendar.setMonth(newDate.get(2));
            this.calendar.setDay(newDate.get(5));
        }

        private void setDateToTextfield(Date date) {
            this.datePicker.getDateConverterStrategy().setDateToTextField(date);
        }
    }

    public static interface IDateConverterStrategy {
        public void setDateToTextField(Date var1);

        public Date getDateFromTextField(String var1);
    }

    private static class RegexDateConverterStrategy
    implements IDateConverterStrategy {
        private Text textfield;

        public RegexDateConverterStrategy(Text textfield) {
            this.textfield = textfield;
        }

        public void setDateToTextField(Date date) {
            String dateString = new SimpleDateFormat("dd.MM.yyyy").format(date);
            String oldText = this.textfield.getText();
            if (oldText.contains(":")) {
                Pattern pattern = Pattern.compile("([ \\d\\.]+)\\s+(.*?:.*?)");
                Matcher matcher = pattern.matcher(oldText);
                if (matcher.matches()) {
                    String oldTime = matcher.group(2);
                    this.textfield.setText(String.valueOf(dateString) + " " + oldTime);
                }
            } else {
                this.textfield.setText(dateString);
            }
            this.textfield.setFocus();
        }

        public Date getDateFromTextField(String dateString) {
            Calendar result = null;
            Pattern pattern = Pattern.compile("(\\d+)\\.(\\d+)\\.(\\d+).*?");
            Matcher matcher = pattern.matcher(dateString);
            if (matcher.matches() && matcher.groupCount() == 3) {
                int month = Integer.parseInt(matcher.group(2));
                --month;
                int year = Integer.parseInt(matcher.group(3));
                if (year < 100) {
                    year += 1900;
                }
                result = Calendar.getInstance();
                result.set(5, Integer.parseInt(matcher.group(1)));
                result.set(2, month);
                result.set(1, year);
                return result.getTime();
            }
            return null;
        }
    }
}

