/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.swt;

import org.eclipse.riena.ui.core.marker.DisabledMarker;
import org.eclipse.riena.ui.swt.EmbeddedTitleBar;
import org.eclipse.riena.ui.swt.IEmbeddedTitleBarListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;

public class ModuleTitleBar
extends EmbeddedTitleBar {
    public ModuleTitleBar(Composite parent, int style) {
        super(parent, style);
    }

    protected void addListeners() {
        super.addListeners();
        TitlebarMouseListener mouseListener = new TitlebarMouseListener();
        this.addMouseListener(mouseListener);
        this.addMouseMoveListener(mouseListener);
        this.addMouseTrackListener(mouseListener);
    }

    private void fireActivated(MouseEvent event) {
        IEmbeddedTitleBarListener[] iEmbeddedTitleBarListenerArray = (IEmbeddedTitleBarListener[])this.titleBarListeners.getListeners();
        int n = iEmbeddedTitleBarListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            IEmbeddedTitleBarListener listener = iEmbeddedTitleBarListenerArray[n2];
            listener.windowActivated(event);
            ++n2;
        }
    }

    private void fireClosed(MouseEvent event) {
        IEmbeddedTitleBarListener[] iEmbeddedTitleBarListenerArray = (IEmbeddedTitleBarListener[])this.titleBarListeners.getListeners();
        int n = iEmbeddedTitleBarListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            IEmbeddedTitleBarListener listener = iEmbeddedTitleBarListenerArray[n2];
            listener.windowClosed(event);
            ++n2;
        }
    }

    private class TitlebarMouseListener
    implements MouseListener,
    MouseTrackListener,
    MouseMoveListener {
        private TitlebarMouseListener() {
        }

        public void mouseUp(MouseEvent e) {
            if (!this.isEnabled()) {
                return;
            }
            if (!this.shouldIgnore(e)) {
                Point point = new Point(e.x, e.y);
                if (ModuleTitleBar.this.isOverClose(point)) {
                    ModuleTitleBar.this.fireClosed(e);
                } else {
                    ModuleTitleBar.this.fireActivated(e);
                    ModuleTitleBar.this.setPressed(false);
                }
            }
            this.updateCloseButtonState(e);
        }

        public void mouseDown(MouseEvent e) {
            if (!this.isEnabled()) {
                return;
            }
            if (!this.shouldIgnore(e)) {
                ModuleTitleBar.this.setPressed(true);
            }
            this.updateCloseButtonState(e);
        }

        public void mouseDoubleClick(MouseEvent e) {
        }

        public void mouseEnter(MouseEvent e) {
            if (!this.isEnabled()) {
                return;
            }
            ModuleTitleBar.this.setHover(true);
            this.updateCloseButtonState(e);
        }

        public void mouseExit(MouseEvent e) {
            if (!this.isEnabled()) {
                return;
            }
            ModuleTitleBar.this.setHover(false);
            this.updateCloseButtonState(e);
        }

        public void mouseHover(MouseEvent e) {
        }

        public void mouseMove(MouseEvent e) {
            this.updateCloseButtonState(e);
        }

        private void updateCloseButtonState(MouseEvent e) {
            Point point = new Point(e.x, e.y);
            if (ModuleTitleBar.this.isOverClose(point)) {
                ModuleTitleBar.this.setCloseButtonHover(ModuleTitleBar.this.isHover());
                ModuleTitleBar.this.setCloseButtonPressed(ModuleTitleBar.this.isPressed());
            } else {
                ModuleTitleBar.this.setCloseButtonHover(false);
                ModuleTitleBar.this.setCloseButtonPressed(false);
            }
        }

        protected boolean shouldIgnore(MouseEvent e) {
            return e.button != 1;
        }

        protected boolean isEnabled() {
            return ModuleTitleBar.this.getMarkersOfType(DisabledMarker.class).isEmpty();
        }
    }
}

