/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.swt;

import org.eclipse.riena.ui.swt.AbstractStatuslineComposite;
import org.eclipse.riena.ui.swt.lnf.LnfManager;
import org.eclipse.riena.ui.swt.utils.SwtUtilities;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Widget;

public class StatuslineNumber
extends AbstractStatuslineComposite {
    private CLabel numberLabel;

    public StatuslineNumber(Composite parent, int style) {
        super(parent, style | 0x80000);
    }

    protected void createContents() {
        this.numberLabel = new CLabel(this, 16384){

            public Point computeSize(int wHint, int hHint, boolean changed) {
                Point size = super.computeSize(wHint, hHint, changed);
                if (StatuslineNumber.this.getFixWidth() != 0) {
                    size.x = StatuslineNumber.this.getFixWidth();
                }
                return size;
            }
        };
        this.numberLabel.setText("0000000");
        this.numberLabel.setBackground(LnfManager.getLnf().getColor("statusline.background"));
    }

    protected int getFixWidth() {
        return 0;
    }

    public void dispose() {
        super.dispose();
        SwtUtilities.disposeWidget((Widget)this.numberLabel);
    }

    public void setNumber(int number) {
        if (number <= 0) {
            this.numberLabel.setText("");
            return;
        }
        String numberStrg = Integer.toString(number);
        StringBuilder sb = new StringBuilder(numberStrg);
        while (sb.length() < 7) {
            sb.insert(0, '0');
        }
        this.numberLabel.setText(sb.toString());
    }

    public void setNumber(String number) {
        if (number != null) {
            this.numberLabel.setText(number);
        } else {
            this.numberLabel.setText("");
        }
    }
}

