/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.swt.lnf;

import java.util.Collection;
import org.eclipse.riena.ui.core.marker.UIProcessFinishedMarker;
import org.eclipse.riena.ui.swt.lnf.ILnfRenderer;
import org.eclipse.riena.ui.swt.lnf.renderer.UIProcessFinishedFlasher;

public class FlasherSupportForRenderer {
    private ILnfRenderer renderer;
    private Runnable updater;

    public FlasherSupportForRenderer(ILnfRenderer renderer, Runnable updater) {
        this.renderer = renderer;
        this.updater = updater;
    }

    public void startFlasher() {
        Collection<UIProcessFinishedMarker> markers = this.renderer.getMarkersOfType(UIProcessFinishedMarker.class);
        for (UIProcessFinishedMarker processMarker : markers) {
            if (processMarker.isActivated()) continue;
            this.startFlasher(processMarker);
        }
    }

    public boolean isProcessMarkerVisible() {
        Collection<UIProcessFinishedMarker> markers = this.renderer.getMarkersOfType(UIProcessFinishedMarker.class);
        for (UIProcessFinishedMarker processMarker : markers) {
            if (!processMarker.isOn()) continue;
            return true;
        }
        return false;
    }

    public boolean isFlashing() {
        Collection<UIProcessFinishedMarker> markers = this.renderer.getMarkersOfType(UIProcessFinishedMarker.class);
        for (UIProcessFinishedMarker processMarker : markers) {
            if (!processMarker.isFlashing()) continue;
            return true;
        }
        return false;
    }

    private synchronized void startFlasher(UIProcessFinishedMarker processMarker) {
        UIProcessFinishedFlasher flasher = new UIProcessFinishedFlasher(processMarker, this.updater);
        processMarker.activate();
        flasher.start();
    }
}

