/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.swt.lnf;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.equinox.log.Logger;
import org.eclipse.riena.core.IRienaActivator;
import org.eclipse.riena.core.Log4r;
import org.eclipse.riena.core.util.ReflectionFailure;
import org.eclipse.riena.core.util.ReflectionUtils;
import org.eclipse.riena.core.util.StringUtils;
import org.eclipse.riena.internal.ui.swt.Activator;
import org.eclipse.riena.ui.swt.lnf.LnfManager;
import org.eclipse.riena.ui.swt.lnf.rienadefault.RienaDefaultLnf;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LnFUpdater {
    private static final Logger LOGGER = Log4r.getLogger((IRienaActivator)Activator.getDefault(), LnFUpdater.class);
    private static final String PROPERTY_RIENA_LNF_UPDATE_VIEW = "riena.lnf.update.view";
    private static final Map<Class<? extends Control>, PropertyDescriptor[]> CONTROL_PROPERTIES = new Hashtable<Class<? extends Control>, PropertyDescriptor[]>();
    private static final Map<Class<? extends Control>, Map<String, Object>> DEFAULT_PROPERTY_VALUES = new Hashtable<Class<? extends Control>, Map<String, Object>>();
    private static final List<Class<? extends Control>> CONTROLS_AFTER_BIND = new ArrayList<Class<? extends Control>>();

    public static void addControlsAfterBind(Class<? extends Control> controlClass) {
        if (!CONTROLS_AFTER_BIND.contains(controlClass)) {
            CONTROLS_AFTER_BIND.add(controlClass);
        }
    }

    public void updateUIControls(Composite parent) {
        Control[] controls;
        if (!this.checkPropertyUpdateView()) {
            return;
        }
        Control[] controlArray = controls = parent.getChildren();
        int n = controls.length;
        int n2 = 0;
        while (n2 < n) {
            Control uiControl = controlArray[n2];
            this.updateUIControl(uiControl);
            if (uiControl instanceof Composite) {
                this.updateUIControls((Composite)uiControl);
            }
            ++n2;
        }
    }

    public void updateUIControlsAfterBind(Composite parent) {
        this.updateAfterBind(parent);
        parent.layout();
    }

    private void updateAfterBind(Composite parent) {
        Control[] controls;
        if (!this.checkPropertyUpdateView()) {
            return;
        }
        Control[] controlArray = controls = parent.getChildren();
        int n = controls.length;
        int n2 = 0;
        while (n2 < n) {
            Control uiControl = controlArray[n2];
            if (this.checkUpdateAfterBind(uiControl)) {
                this.updateUIControl(uiControl);
            }
            if (uiControl instanceof Composite) {
                this.updateAfterBind((Composite)uiControl);
            }
            ++n2;
        }
    }

    private boolean checkUpdateAfterBind(Control uiControl) {
        if (uiControl == null) {
            return false;
        }
        if (CONTROLS_AFTER_BIND.contains(uiControl.getClass())) {
            return true;
        }
        if (uiControl.getParent() != null) {
            return this.checkUpdateAfterBind((Control)uiControl.getParent());
        }
        return false;
    }

    private boolean checkPropertyUpdateView() {
        return Boolean.getBoolean(PROPERTY_RIENA_LNF_UPDATE_VIEW);
    }

    private void updateUIControl(Control control) {
        PropertyDescriptor[] properties;
        if (!this.checkLnfKeys(control)) {
            return;
        }
        PropertyDescriptor[] propertyDescriptorArray = properties = this.getProperties(control);
        int n = properties.length;
        int n2 = 0;
        while (n2 < n) {
            int modifiers;
            Method setter;
            PropertyDescriptor property = propertyDescriptorArray[n2];
            Object newValue = this.getLnfValue(control, property);
            if (newValue != null && (setter = property.getWriteMethod()) != null && Modifier.isPublic(modifiers = setter.getModifiers()) && !this.hasNoDefaultValue(control, property)) {
                try {
                    setter.invoke((Object)control, newValue);
                }
                catch (IllegalArgumentException e) {
                    LOGGER.log(2, this.getErrorMessage(control, property), (Throwable)e);
                }
                catch (IllegalAccessException e) {
                    LOGGER.log(2, this.getErrorMessage(control, property), (Throwable)e);
                }
                catch (InvocationTargetException e) {
                    LOGGER.log(2, this.getErrorMessage(control, property), (Throwable)e);
                }
            }
            ++n2;
        }
    }

    private boolean checkLnfKeys(Control control) {
        String style;
        RienaDefaultLnf lnf = LnfManager.getLnf();
        Class<?> controlClass = control.getClass();
        String className = this.getSimpleClassName(controlClass);
        if (!StringUtils.isEmpty((CharSequence)className)) {
            className = String.valueOf(className) + ".";
            Set<String> keys = lnf.getResourceTable().keySet();
            for (String key : keys) {
                if (!key.startsWith(className)) continue;
                return true;
            }
        }
        if (!StringUtils.isEmpty((CharSequence)(style = (String)control.getData("lnfStyle")))) {
            style = String.valueOf(style) + ".";
            Set<String> keys = lnf.getResourceTable().keySet();
            for (String key : keys) {
                if (!key.startsWith(style)) continue;
                return true;
            }
        }
        return false;
    }

    private String getSimpleClassName(Class<? extends Control> controlClass) {
        if (StringUtils.isEmpty((CharSequence)controlClass.getSimpleName())) {
            if (Control.class.isAssignableFrom(controlClass.getSuperclass())) {
                Class<? extends Control> superClass = controlClass.getSuperclass();
                return this.getSimpleClassName(superClass);
            }
            return null;
        }
        return controlClass.getSimpleName();
    }

    private boolean hasNoDefaultValue(Control control, PropertyDescriptor property) {
        Method getter = property.getReadMethod();
        if (getter != null) {
            Object defaultValue = this.getDefaultPropertyValue(control, property);
            Object currentValue = this.getPropertyValue(control, property);
            if (defaultValue != null && !defaultValue.equals(currentValue)) {
                return true;
            }
        }
        return false;
    }

    private Object getDefaultPropertyValue(Control control, PropertyDescriptor property) {
        Map<String, Object> defaultValues;
        Class<?> controlClass = control.getClass();
        if (!DEFAULT_PROPERTY_VALUES.containsKey(controlClass)) {
            Control defaultControl = null;
            try {
                defaultControl = (Control)ReflectionUtils.newInstanceHidden(controlClass, (Object[])new Object[]{control.getParent(), control.getStyle()});
            }
            catch (ReflectionFailure failure) {
                LOGGER.log(1, "Cannot create an instance of \"" + controlClass.getName() + "\"", (Throwable)failure);
                defaultControl = null;
            }
            if (defaultControl != null) {
                PropertyDescriptor[] properties = this.getProperties(control);
                Hashtable<String, Object> defaults = new Hashtable<String, Object>(properties.length);
                PropertyDescriptor[] propertyDescriptorArray = properties;
                int n = properties.length;
                int n2 = 0;
                while (n2 < n) {
                    PropertyDescriptor defaultProperty = propertyDescriptorArray[n2];
                    Object value = this.getPropertyValue(defaultControl, defaultProperty);
                    if (value != null) {
                        defaults.put(defaultProperty.getName(), value);
                    }
                    ++n2;
                }
                defaultControl.dispose();
                DEFAULT_PROPERTY_VALUES.put(controlClass, defaults);
            }
        }
        if ((defaultValues = DEFAULT_PROPERTY_VALUES.get(controlClass)) == null) {
            return null;
        }
        return defaultValues.get(property.getName());
    }

    private Object getPropertyValue(Control control, PropertyDescriptor property) {
        Method getter = property.getReadMethod();
        if (getter != null) {
            try {
                return ReflectionUtils.invokeHidden((Object)control, (String)property.getReadMethod().getName(), (Object[])new Object[0]);
            }
            catch (ReflectionFailure failure) {
                if (control.getClass().getName().equals("org.eclipse.swt.nebula.widgets.compositetable.CompositeTable")) {
                    return null;
                }
                String message = "Cannot get the value of the property \"" + property.getName() + "\" of the class \"" + control.getClass().getName() + "\".";
                LOGGER.log(1, message, (Throwable)failure);
                return null;
            }
        }
        return null;
    }

    private String getErrorMessage(Control control, PropertyDescriptor property) {
        Class<?> controlClass = control.getClass();
        StringBuilder sb = new StringBuilder("Cannot update property ");
        sb.append("\"" + property.getName() + "\"");
        sb.append(" of the class ");
        sb.append("\"" + controlClass.getName() + "\"");
        return sb.toString();
    }

    private PropertyDescriptor[] getProperties(Control control) {
        Class<?> controlClass = control.getClass();
        if (!CONTROL_PROPERTIES.containsKey(controlClass)) {
            try {
                BeanInfo beanInfo = Introspector.getBeanInfo(controlClass);
                PropertyDescriptor[] properties = beanInfo.getPropertyDescriptors();
                CONTROL_PROPERTIES.put(controlClass, properties);
            }
            catch (IntrospectionException introspectionException) {
                CONTROL_PROPERTIES.put(controlClass, new PropertyDescriptor[0]);
            }
        }
        return CONTROL_PROPERTIES.get(controlClass);
    }

    private Object getLnfValue(Control control, PropertyDescriptor property) {
        Object lnfValue = this.getLnfStyleValue(control, property);
        if (lnfValue == null) {
            Class<?> controlClass = control.getClass();
            RienaDefaultLnf lnf = LnfManager.getLnf();
            String controlName = this.getSimpleClassName(controlClass);
            String lnfKey = String.valueOf(controlName) + "." + property.getName();
            lnfValue = lnf.getResource(lnfKey);
        }
        return lnfValue;
    }

    private Object getLnfStyleValue(Control control, PropertyDescriptor property) {
        String style = (String)control.getData("lnfStyle");
        if (StringUtils.isEmpty((CharSequence)style)) {
            return null;
        }
        RienaDefaultLnf lnf = LnfManager.getLnf();
        String lnfKey = String.valueOf(style) + "." + property.getName();
        return lnf.getResource(lnfKey);
    }
}

