/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.swt.lnf.renderer;

import org.eclipse.riena.ui.swt.lnf.AbstractLnfRenderer;
import org.eclipse.riena.ui.swt.lnf.LnfManager;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;

public class DialogBorderRenderer
extends AbstractLnfRenderer {
    private static final int BORDER_WIDTH = 2;

    protected Boolean hideOsBorder() {
        return LnfManager.getLnf().getBooleanSetting("Dialog.hideOsBorder");
    }

    protected Color getInnerBorderColorBottom() {
        return this.getLnfColor("Dialog.innerBorderBottomRightColor");
    }

    protected Color getInnerBorderColorRight() {
        return this.getLnfColor("Dialog.innerBorderBottomRightColor");
    }

    protected Color getInnerBorderColorTop() {
        return this.getLnfColor("Dialog.innerBorderTopLeftColor");
    }

    protected Color getInnerBorderColorLeft() {
        return this.getLnfColor("Dialog.innerBorderTopLeftColor");
    }

    protected Color getBorderColorBottom() {
        return this.getLnfColor("Dialog.bottomRightColor");
    }

    protected Color getBorderColorRight() {
        return this.getLnfColor("Dialog.bottomRightColor");
    }

    protected Color getBorderColorTop() {
        return this.getLnfColor("Dialog.borderTopLeftColor");
    }

    protected Color getBorderColorLeft() {
        return this.getLnfColor("Dialog.borderTopLeftColor");
    }

    protected Color getLnfColor(String key) {
        return LnfManager.getLnf().getColor(key);
    }

    public void paint(GC gc, Object value) {
        if (!this.hideOsBorder().booleanValue()) {
            return;
        }
        gc.setAdvanced(true);
        gc.setAntialias(1);
        Color borderColor = this.getBorderColorTop();
        gc.setForeground(borderColor);
        int x = this.getBounds().x;
        int y = this.getBounds().y;
        int w = this.getWidth();
        gc.drawLine(x, y, x + w, y);
        borderColor = this.getBorderColorBottom();
        gc.setForeground(borderColor);
        y = this.getBounds().y + this.getHeight();
        gc.drawLine(x, y, x + w, y);
        borderColor = this.getBorderColorLeft();
        gc.setForeground(borderColor);
        x = this.getBounds().x;
        y = this.getBounds().y;
        int h = this.getHeight();
        gc.drawLine(x, y, x, y + h);
        borderColor = this.getBorderColorRight();
        gc.setForeground(borderColor);
        x = this.getBounds().x + this.getWidth();
        gc.drawLine(x, y, x, y + h);
        borderColor = this.getInnerBorderColorTop();
        gc.setForeground(borderColor);
        x = this.getBounds().x + 1;
        y = this.getBounds().y + 1;
        w = this.getWidth() - 2;
        gc.drawLine(x, y, x + w, y);
        borderColor = this.getInnerBorderColorBottom();
        gc.setForeground(borderColor);
        y = this.getBounds().y + this.getHeight() - 1;
        gc.drawLine(x, y, x + w, y);
        borderColor = this.getInnerBorderColorLeft();
        gc.setForeground(borderColor);
        x = this.getBounds().x + 1;
        y = this.getBounds().y + 1;
        h = this.getHeight() - 2;
        gc.drawLine(x, y, x, y + h);
        borderColor = this.getInnerBorderColorRight();
        gc.setForeground(borderColor);
        x = this.getBounds().x + this.getWidth() - 1;
        y = this.getBounds().y + 2;
        h = this.getHeight() - 4;
        gc.drawLine(x, y, x, y + h);
    }

    public void dispose() {
    }

    private int getHeight() {
        return this.getBounds().height - 1;
    }

    private int getWidth() {
        return this.getBounds().width - 1;
    }

    public int getBorderWidth() {
        if (this.hideOsBorder().booleanValue()) {
            return 2;
        }
        return 0;
    }
}

