/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.swt.utils;

import java.net.URL;
import org.eclipse.equinox.log.Logger;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.riena.core.IRienaActivator;
import org.eclipse.riena.core.Log4r;
import org.eclipse.riena.core.util.StringUtils;
import org.eclipse.riena.core.wire.InjectExtension;
import org.eclipse.riena.core.wire.Wire;
import org.eclipse.riena.internal.ui.swt.Activator;
import org.eclipse.riena.ui.swt.utils.IImagePathExtension;
import org.eclipse.riena.ui.swt.utils.ImageFileExtension;
import org.eclipse.riena.ui.swt.utils.ImageState;
import org.eclipse.swt.graphics.Image;

public final class ImageStore {
    private static final Logger LOGGER = Log4r.getLogger((IRienaActivator)Activator.getDefault(), ImageStore.class);
    private static ImageStore store;
    private static Image missingImage;
    private IImagePathExtension[] iconPathes;

    private ImageStore() {
    }

    public static synchronized ImageStore getInstance() {
        if (store == null) {
            store = new ImageStore();
            if (Activator.getDefault() != null) {
                Wire.instance((Object)store).andStart(Activator.getDefault().getContext());
            }
        }
        return store;
    }

    public Image getImage(String imageName) {
        return this.getImage(imageName, ImageState.NORMAL);
    }

    public Image getImage(String imageName, ImageFileExtension fileExtension) {
        return this.getImage(imageName, ImageState.NORMAL, fileExtension);
    }

    public Image getImage(String imageName, ImageState state) {
        return this.getImage(imageName, state, ImageFileExtension.PNG);
    }

    public Image getImage(String imageName, ImageState state, ImageFileExtension fileExtension) {
        String fullName = this.getFullName(imageName, state, fileExtension);
        return this.loadImage(fullName);
    }

    private String getFullName(String imageName, ImageState state, ImageFileExtension fileExtension) {
        if (StringUtils.isEmpty((CharSequence)imageName)) {
            return null;
        }
        String fullName = imageName;
        if (state != null) {
            fullName = String.valueOf(fullName) + state.getStateNameExtension();
        }
        if (imageName.indexOf(46) < 0 && fileExtension != null) {
            fullName = String.valueOf(fullName) + "." + fileExtension.getFileNameExtension();
        }
        return fullName;
    }

    private synchronized Image loadImage(String fullName) {
        if (StringUtils.isEmpty((CharSequence)fullName)) {
            return null;
        }
        if (Activator.getDefault() == null) {
            return null;
        }
        ImageRegistry imageRegistry = Activator.getDefault().getImageRegistry();
        Image image = imageRegistry.get(fullName);
        if (image == null || image.isDisposed()) {
            ImageDescriptor descriptor = this.getImageDescriptor(fullName);
            if (descriptor == null) {
                return null;
            }
            imageRegistry.remove(fullName);
            imageRegistry.put(fullName, descriptor);
            image = imageRegistry.get(fullName);
        }
        return image;
    }

    private ImageDescriptor getImageDescriptor(String fullName) {
        IImagePathExtension[] iImagePathExtensionArray = this.iconPathes;
        int n = this.iconPathes.length;
        int n2 = 0;
        while (n2 < n) {
            IImagePathExtension iconPath = iImagePathExtensionArray[n2];
            String fullPath = String.valueOf(iconPath.getPath()) + '/' + fullName;
            URL url = iconPath.getContributingBundle().getResource(fullPath);
            if (url != null) {
                return ImageDescriptor.createFromURL((URL)url);
            }
            ++n2;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("Image resource \"");
        sb.append(fullName);
        sb.append("\" not found in:");
        IImagePathExtension[] iImagePathExtensionArray2 = this.iconPathes;
        int n3 = this.iconPathes.length;
        n = 0;
        while (n < n3) {
            IImagePathExtension iconPath = iImagePathExtensionArray2[n];
            sb.append("\n  ");
            sb.append(iconPath.getContributingBundle().getLocation());
            sb.append(iconPath.getPath());
            ++n;
        }
        LOGGER.log(2, sb.toString());
        return null;
    }

    public synchronized Image getMissingImage() {
        if (missingImage == null) {
            missingImage = ImageDescriptor.getMissingImageDescriptor().createImage();
        }
        return missingImage;
    }

    @InjectExtension
    public void update(IImagePathExtension[] iconPathes) {
        this.iconPathes = iconPathes;
    }
}

