/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.swt.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.riena.core.util.StringUtils;
import org.eclipse.riena.ui.common.IComplexComponent;
import org.eclipse.riena.ui.ridgets.uibinding.IBindingPropertyLocator;
import org.eclipse.riena.ui.swt.utils.IPropertyNameProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Widget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SWTBindingPropertyLocator
implements IBindingPropertyLocator {
    public static final String BINDING_PROPERTY = "binding_property";
    private static SWTBindingPropertyLocator locator;

    private SWTBindingPropertyLocator() {
    }

    public static SWTBindingPropertyLocator getInstance() {
        if (locator == null) {
            locator = new SWTBindingPropertyLocator();
        }
        return locator;
    }

    public static List<Object> getControlsWithBindingProperty(Composite composite) {
        HashMap<String, Control> map = new HashMap<String, Control>();
        SWTBindingPropertyLocator.collectControlsWithBindingProperty(composite, map);
        return new ArrayList<Object>(map.values());
    }

    public String locateBindingProperty(Object uiControl) {
        if (uiControl instanceof Widget) {
            Widget widget = (Widget)uiControl;
            if (widget.isDisposed()) {
                return null;
            }
            return this.locateBindingProperty(widget);
        }
        if (uiControl instanceof IPropertyNameProvider) {
            return ((IPropertyNameProvider)uiControl).getPropertyName();
        }
        return null;
    }

    public void setBindingProperty(Object uiControl, String id) {
        if (uiControl instanceof Widget) {
            Widget control = (Widget)uiControl;
            if (control.isDisposed()) {
                return;
            }
            control.setData(BINDING_PROPERTY, (Object)id);
        } else if (uiControl instanceof IPropertyNameProvider) {
            ((IPropertyNameProvider)uiControl).setPropertyName(id);
        }
    }

    private static void collectControlsWithBindingProperty(Composite parent, Map<String, Control> result) {
        SWTBindingPropertyLocator locator = SWTBindingPropertyLocator.getInstance();
        Control[] controlArray = parent.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            String bindingProperty = locator.locateBindingProperty((Widget)control);
            if (StringUtils.isGiven((CharSequence)bindingProperty)) {
                if (result.containsKey(bindingProperty)) {
                    Control firstControl = result.get(bindingProperty);
                    String msg = String.format("Binding property '%s' used by several widgets: %s and %s", bindingProperty, firstControl, control);
                    throw new RuntimeException(msg);
                }
                result.put(bindingProperty, control);
            }
            if (control instanceof Composite) {
                SWTBindingPropertyLocator.collectControlsWithBindingProperty((Composite)control, result);
            }
            ++n2;
        }
    }

    private String locateBindingProperty(Widget widget) {
        String parentProperty;
        Composite parent;
        String fullProperty = (String)widget.getData(BINDING_PROPERTY);
        if (StringUtils.isEmpty((CharSequence)fullProperty)) {
            fullProperty = "";
        } else if (widget instanceof Control && (parent = ((Control)widget).getParent()) != null && !StringUtils.isEmpty((CharSequence)(parentProperty = this.locateBindingProperty((Widget)parent))) && parent instanceof IComplexComponent) {
            fullProperty = String.valueOf(parentProperty) + "." + fullProperty;
        }
        return fullProperty;
    }
}

