/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.communication.core.ssl;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.KeyStore;
import java.security.Provider;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.eclipse.equinox.log.Logger;
import org.eclipse.riena.core.IRienaActivator;
import org.eclipse.riena.core.Log4r;
import org.eclipse.riena.core.util.Iter;
import org.eclipse.riena.core.wire.InjectExtension;
import org.eclipse.riena.internal.communication.core.Activator;
import org.eclipse.riena.internal.communication.core.ssl.ISSLPropertiesExtension;
import org.osgi.framework.Bundle;

public class SSLConfiguration {
    private String protocol;
    private String keystore;
    private String password;
    private HostnameVerifier hostnameVerifier;
    private Bundle contributingBundle;
    private boolean configured;
    private String previousHttpsProtocol;
    private HostnameVerifier previousHostnameVerifier;
    private SSLSocketFactory previousSSLSocketFactor;
    private static final String JRE_CACERTS_MARKER = "#jre-cacerts#";
    private static final String HTTPS_PROTOCOLS_PROPERTY_KEY = "https.protocols";
    private static final Logger LOGGER = Log4r.getLogger((IRienaActivator)Activator.getDefault(), SSLConfiguration.class);

    @InjectExtension(min=0, max=1)
    public void configure(ISSLPropertiesExtension sslProperties) {
        if (this.configured && sslProperties == null) {
            this.restore();
            return;
        }
        this.configured = false;
        if (sslProperties == null) {
            LOGGER.log(3, "No configuration given!.");
            return;
        }
        this.protocol = sslProperties.getProtocol();
        this.keystore = sslProperties.getKeystore();
        this.password = sslProperties.getPassword();
        this.contributingBundle = sslProperties.getContributingBundle();
        LOGGER.log(3, "Configuring SSL protocol '" + this.protocol + "' with keystore '" + this.keystore + "'.");
        if (this.keystore == null || this.keystore.length() == 0 || this.protocol == null || this.protocol.length() == 0) {
            LOGGER.log(2, "Neither keystore nor protocol given!");
            return;
        }
        this.previousHttpsProtocol = System.getProperty(HTTPS_PROTOCOLS_PROPERTY_KEY);
        System.setProperty(HTTPS_PROTOCOLS_PROPERTY_KEY, this.protocol);
        try {
            Provider[] providers = Security.getProviders();
            if (providers == null) {
                LOGGER.log(2, "Security did not find any providers. This might be a problem. Check imported jar files for sunjce_provider.jar!");
            } else {
                LOGGER.log(3, "Security found " + providers.length + " security providers.");
                int i = 0;
                while (i < providers.length) {
                    LOGGER.log(4, "Security provider[" + i + "]: " + providers[i].getName());
                    ++i;
                }
            }
            KeyStore keyStore = KeyStore.getInstance("JKS");
            URL keystoreUrl = this.getKeystoreUrl();
            if (keystoreUrl == null) {
                LOGGER.log(1, "Specified keystore '" + this.keystore + "' can not be found. SSL not initialized.");
                return;
            }
            LOGGER.log(4, "Keystore is '" + keystoreUrl + "'.");
            char[] passwordChars = this.password == null ? null : this.password.toCharArray();
            keyStore.load(keystoreUrl.openStream(), passwordChars);
            Enumeration<String> enumeration = keyStore.aliases();
            if (enumeration == null) {
                LOGGER.log(1, "Found no certificate.");
                throw new Exception("Found no certificate.");
            }
            for (String alias : Iter.able(enumeration)) {
                LOGGER.log(4, "Found certificate: " + alias);
                Certificate certificate = keyStore.getCertificate(alias);
                if (certificate instanceof X509Certificate) {
                    X509Certificate x509Certificate = (X509Certificate)certificate;
                    LOGGER.log(4, "  Subject: " + x509Certificate.getSubjectDN());
                    LOGGER.log(4, "  Issuer : " + x509Certificate.getIssuerDN());
                    LOGGER.log(4, "  Valid from " + x509Certificate.getNotBefore() + " to " + x509Certificate.getNotAfter());
                    continue;
                }
                LOGGER.log(4, "  " + certificate);
            }
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance("SunX509");
            trustManagerFactory.init(keyStore);
            TrustManager[] trustManagers = trustManagerFactory.getTrustManagers();
            SSLContext sslContext = SSLContext.getInstance("SSL");
            sslContext.init(null, trustManagers, null);
            LOGGER.log(4, "SSLContext protocol: " + sslContext.getProtocol());
            LOGGER.log(4, "SSLContext SocketFactory: " + sslContext.getSocketFactory());
            this.previousSSLSocketFactor = HttpsURLConnection.getDefaultSSLSocketFactory();
            HttpsURLConnection.setDefaultSSLSocketFactory(sslContext.getSocketFactory());
            this.hostnameVerifier = sslProperties.createHostnameVerifier();
            if (this.hostnameVerifier == null) {
                this.hostnameVerifier = new StrictHostnameVerifier();
            } else {
                LOGGER.log(4, "Using custom host name verifier " + this.hostnameVerifier.getClass().getName());
            }
            this.previousHostnameVerifier = HttpsURLConnection.getDefaultHostnameVerifier();
            HttpsURLConnection.setDefaultHostnameVerifier(this.hostnameVerifier);
            LOGGER.log(3, "Configuring the SSL protocol finished!");
            this.configured = true;
        }
        catch (Exception ex) {
            LOGGER.log(1, "Configuration of SSL protocol failed. SSL will not work properly!", (Throwable)ex);
        }
    }

    private URL getKeystoreUrl() throws MalformedURLException {
        if (this.keystore.equals(JRE_CACERTS_MARKER)) {
            String jreDir = System.getProperty("java.home");
            LOGGER.log(4, "Attempting to load keystore from cacerts of the jre: " + jreDir);
            File cacertFile = new File(new File(new File(new File(jreDir), "lib"), "security"), "cacerts");
            return cacertFile.canRead() ? cacertFile.toURL() : null;
        }
        URL keystoreUrl = this.contributingBundle.getEntry(this.keystore);
        if (keystoreUrl != null) {
            return keystoreUrl;
        }
        keystoreUrl = this.contributingBundle.getResource(this.keystore);
        if (keystoreUrl != null) {
            return keystoreUrl;
        }
        File keystoreFile = new File(this.keystore);
        if (keystoreFile.canRead()) {
            return keystoreFile.toURL();
        }
        return new URL(this.keystore);
    }

    public boolean isConfigured() {
        return this.configured;
    }

    private void restore() {
        if (this.previousHttpsProtocol != null) {
            System.setProperty(HTTPS_PROTOCOLS_PROPERTY_KEY, this.previousHttpsProtocol);
        }
        if (this.previousSSLSocketFactor != null) {
            HttpsURLConnection.setDefaultSSLSocketFactory(this.previousSSLSocketFactor);
        }
        if (this.previousHostnameVerifier != null) {
            HttpsURLConnection.setDefaultHostnameVerifier(this.previousHostnameVerifier);
        }
    }

    public String toString() {
        return "SSLConfiguration [keystore=" + this.keystore + ", protocol=" + this.protocol + ", hostnameVerifier=" + this.hostnameVerifier + "]";
    }

    public static final class StrictHostnameVerifier
    implements HostnameVerifier {
        public boolean verify(String hostname, SSLSession session) {
            LOGGER.log(1, "Hostname '" + hostname + "' does not match the certificate\u00b4s host name (" + session.getPeerHost() + ")!");
            return false;
        }
    }
}

