/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.core.injector.service;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.equinox.log.Logger;
import org.eclipse.riena.core.Log4r;
import org.eclipse.riena.core.injector.IStoppable;
import org.eclipse.riena.core.injector.InjectionFailure;
import org.eclipse.riena.core.injector.service.ServiceDescriptor;
import org.eclipse.riena.core.util.WeakRef;
import org.eclipse.riena.internal.core.injector.ObjectCounter;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.SynchronousBundleListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ServiceInjector
implements IStoppable {
    public static final String DEFAULT_BIND_METHOD_NAME = "bind";
    public static final String DEFAULT_UNBIND_METHOD_NAME = "unbind";
    private final ServiceDescriptor serviceDesc;
    private final WeakRef<Object> targetRef;
    private final Class<?> targetClass;
    private BundleContext context;
    private final String filter;
    private String bindMethodName;
    private String unbindMethodName;
    private Method bindMethod;
    private Method unbindMethod;
    private boolean onceOnly;
    private State state = State.INITIAL;
    private ServiceListener serviceListener;
    private BundleListener bundleListener;
    private static final OnceOnlyTracker ONCE_ONLY_METHODS = new OnceOnlyTracker();
    private static final Logger LOGGER = Log4r.getLogger(ServiceInjector.class);

    ServiceInjector(ServiceDescriptor serviceDesc, Object target) {
        this.serviceDesc = serviceDesc;
        this.targetRef = new WeakRef<Object>(target, new Runnable(){

            public void run() {
                ServiceInjector.this.stop();
            }
        });
        this.targetClass = target.getClass();
        StringBuilder bob = new StringBuilder().append("(").append("objectClass").append("=").append(serviceDesc.getServiceClassName()).append(")");
        if (serviceDesc.getFilter() != null) {
            bob.insert(0, "(&");
            bob.append(serviceDesc.getFilter());
            bob.append(')');
        }
        this.filter = bob.toString();
    }

    public ServiceInjector andStart(BundleContext context) {
        Assert.isNotNull((Object)context, (String)"Bundle context must be not null.");
        Assert.isTrue((this.state == State.INITIAL ? 1 : 0) != 0, (String)"ServiceInjector already started or stopped!");
        this.state = State.STARTING;
        this.context = context;
        this.retrieveBindAndUnbindMethods();
        boolean bl = this.onceOnly = Modifier.isStatic(this.bindMethod.getModifiers()) && Modifier.isStatic(this.unbindMethod.getModifiers()) || this.onceOnly;
        if (this.onceOnly && ONCE_ONLY_METHODS.registerAndGetCount(this, this.bindMethod) > 1) {
            this.state = State.STARTED;
            return this;
        }
        this.doStart();
        this.registerBundleListener();
        this.state = State.STARTED;
        return this;
    }

    protected boolean isOnceOnly() {
        return this.onceOnly;
    }

    private void retrieveBindAndUnbindMethods() {
        Class<?> serviceClass;
        if (this.bindMethod != null) {
            if (this.bindMethod.getParameterTypes().length != 1) {
                throw new InjectionFailure("Specified bind method '" + this.bindMethod + "' expects exactly one parameter.");
            }
            serviceClass = this.bindMethod.getParameterTypes()[0];
        } else {
            if (this.bindMethodName == null) {
                this.bindMethodName = DEFAULT_BIND_METHOD_NAME;
            }
            if (this.serviceDesc.getServiceClass() != null) {
                serviceClass = this.serviceDesc.getServiceClass();
                this.bindMethod = this.findBestMethod(this.targetClass, this.bindMethodName, serviceClass);
            } else {
                this.bindMethod = this.findBestMethod(this.targetClass, this.bindMethodName, this.serviceDesc.getServiceClassName());
                serviceClass = this.bindMethod.getParameterTypes()[0];
            }
        }
        if (this.unbindMethodName == null) {
            this.unbindMethodName = DEFAULT_UNBIND_METHOD_NAME;
        }
        this.unbindMethod = this.findBestMethod(this.targetClass, this.unbindMethodName, serviceClass);
    }

    /*
     * Unable to fully structure code
     */
    private Method findBestMethod(Class<?> targetClass, String methodName, String serviceClassName) {
        try {
            return this.findBestMethod(targetClass, methodName, targetClass.getClassLoader().loadClass(serviceClassName));
        }
        catch (ClassNotFoundException v0) {
            var7_4 = targetClass.getMethods();
            var6_5 = var7_4.length;
            var5_6 = 0;
            ** while (var5_6 < var6_5)
        }
lbl-1000:
        // 1 sources

        {
            method = var7_4[var5_6];
            if (method.getName().equals(methodName) && method.getParameterTypes().length == 1 && method.getParameterTypes()[0].getName().equals(serviceClassName)) {
                return method;
            }
            ++var5_6;
            continue;
        }
lbl13:
        // 1 sources

        throw new InjectionFailure("Could not find specified un/bind method: " + targetClass.getName() + "#" + methodName + "(" + serviceClassName + ") by service class name.");
    }

    private Method findBestMethod(Class<?> targetClass, String methodName, Class<?> serviceClass) {
        Class<?> superWalker = serviceClass;
        while (superWalker != null) {
            Method result = this.findMethod(targetClass, methodName, superWalker);
            if (result != null) {
                return result;
            }
            Class<?>[] classArray = superWalker.getInterfaces();
            int n = classArray.length;
            int n2 = 0;
            while (n2 < n) {
                Class<?> interfaceWalker = classArray[n2];
                result = this.findMethod(targetClass, methodName, interfaceWalker);
                if (result != null) {
                    return result;
                }
                ++n2;
            }
            superWalker = superWalker.getSuperclass();
        }
        throw new InjectionFailure("Could not find specified un/bind method: " + targetClass.getName() + "#" + methodName + "(" + serviceClass.getName() + ") by service class.");
    }

    private Method findMethod(Class<?> targetClass, String methodName, Class<?> serviceClass) {
        try {
            return targetClass.getMethod(methodName, serviceClass);
        }
        catch (SecurityException e) {
            throw new InjectionFailure("Could not find specified un/bind method: " + targetClass.getName() + "#" + methodName + "(" + serviceClass.getName() + ") by service class.", e);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    protected abstract void doStart();

    @Override
    public synchronized void stop() {
        if (this.state != State.STARTED) {
            return;
        }
        this.state = State.STOPPING;
        if (this.onceOnly) {
            ServiceInjector firstInjector = ONCE_ONLY_METHODS.unregisterAndGetFirstInjector(this.bindMethod);
            if (firstInjector == null) {
                this.state = State.STOPPED;
                return;
            }
            if (firstInjector != this) {
                firstInjector.stopContinue();
                this.state = State.STOPPED;
                return;
            }
        }
        this.stopContinue();
    }

    private void stopContinue() {
        this.unregisterBundleListener();
        this.unregisterServiceListener();
        this.doStop();
        this.state = State.STOPPED;
    }

    protected abstract void doStop();

    public ServiceInjector bind(String bindMethodName) {
        Assert.isTrue((this.state == State.INITIAL ? 1 : 0) != 0, (String)"ServiceInjector already started or stopped!");
        this.bindMethodName = bindMethodName;
        return this;
    }

    public ServiceInjector bind(Method bindMethod) {
        Assert.isTrue((this.state == State.INITIAL ? 1 : 0) != 0, (String)"ServiceInjector already started or stopped!");
        this.bindMethod = bindMethod;
        return this;
    }

    public ServiceInjector onceOnly() {
        Assert.isTrue((this.state == State.INITIAL ? 1 : 0) != 0, (String)"ServiceInjector already started or stopped!");
        this.onceOnly = true;
        return this;
    }

    public synchronized ServiceInjector unbind(String unbindMethodName) {
        Assert.isTrue((this.state == State.INITIAL ? 1 : 0) != 0, (String)"ServiceInjector already started or stopped!");
        this.unbindMethodName = unbindMethodName;
        return this;
    }

    private void registerServiceListener() {
        if (this.serviceListener != null) {
            return;
        }
        this.serviceListener = new InjectorServiceListener();
        try {
            this.context.addServiceListener(this.serviceListener, this.filter);
        }
        catch (InvalidSyntaxException e) {
            throw new InjectionFailure("The specified filter has syntax errors.", e);
        }
    }

    private void unregisterServiceListener() {
        if (this.serviceListener == null) {
            return;
        }
        this.context.removeServiceListener(this.serviceListener);
    }

    private void registerBundleListener() {
        if (this.bundleListener == null) {
            this.bundleListener = new InjectorBundleListener();
        }
        this.context.addBundleListener(this.bundleListener);
    }

    private void unregisterBundleListener() {
        if (this.bundleListener != null) {
            this.context.removeBundleListener(this.bundleListener);
            this.bundleListener = null;
        }
    }

    protected void handleEvent(ServiceEvent event) {
        switch (event.getType()) {
            case 1: {
                this.doBind(event.getServiceReference());
                break;
            }
            case 4: {
                this.doUnbind(event.getServiceReference());
                break;
            }
        }
    }

    protected abstract void doBind(ServiceReference var1);

    protected abstract void doUnbind(ServiceReference var1);

    protected ServiceReference[] getServiceReferences() {
        try {
            ServiceReference[] serviceReferences = this.context.getServiceReferences(this.serviceDesc.getServiceClassName(), this.filter);
            this.registerServiceListener();
            return serviceReferences;
        }
        catch (InvalidSyntaxException e) {
            throw new InjectionFailure("The specified filter has syntax errors.", e);
        }
    }

    protected void invokeBindMethod(ServiceReference serviceRef) {
        if (serviceRef == null) {
            return;
        }
        Object service = this.context.getService(serviceRef);
        if (service == null) {
            return;
        }
        this.invoke(this.bindMethod, service);
    }

    protected void invokeUnbindMethod(ServiceReference serviceRef) {
        if (serviceRef == null) {
            return;
        }
        Object service = this.context.getService(serviceRef);
        if (service == null) {
            return;
        }
        this.invoke(this.unbindMethod, service);
        this.context.ungetService(serviceRef);
        this.context.ungetService(serviceRef);
    }

    private void invoke(Method method, Object service) {
        Assert.isNotNull((Object)method);
        Assert.isNotNull((Object)service);
        Object target = this.targetRef.get();
        if (target == null) {
            return;
        }
        Throwable t = null;
        String cause = null;
        try {
            method.invoke(target, service);
        }
        catch (SecurityException e) {
            t = e;
            cause = "Security exception on invoking '";
        }
        catch (IllegalArgumentException e) {
            t = e;
            cause = "Illegal argument exception on invoking '";
        }
        catch (IllegalAccessException e) {
            t = e;
            cause = "Illegal access exception on invoking '";
        }
        catch (InvocationTargetException e) {
            t = e.getTargetException();
            cause = "Invocation target exception on invoking '";
        }
        if (t != null) {
            String message = String.valueOf(cause) + method + "' on '" + this.targetClass.getName() + "'.";
            LOGGER.log(1, message, t);
            throw new InjectionFailure(message, t);
        }
    }

    class InjectorBundleListener
    implements SynchronousBundleListener {
        InjectorBundleListener() {
        }

        public void bundleChanged(BundleEvent event) {
            if (event.getBundle() != ServiceInjector.this.context.getBundle()) {
                return;
            }
            if (event.getType() == 256) {
                ServiceInjector.this.stop();
            }
        }
    }

    class InjectorServiceListener
    implements ServiceListener {
        InjectorServiceListener() {
        }

        public void serviceChanged(ServiceEvent event) {
            int eventType = event.getType();
            if (eventType == 1 || eventType == 4) {
                ServiceInjector.this.handleEvent(event);
            }
        }
    }

    private static class OnceOnlyTracker {
        private final ObjectCounter<Method> counter = new ObjectCounter();
        private final Map<Method, ServiceInjector> firstInjectors = new HashMap<Method, ServiceInjector>();

        private OnceOnlyTracker() {
        }

        public synchronized int registerAndGetCount(ServiceInjector serviceInjector, Method bindMethod) {
            int count = this.counter.incrementAndGetCount(bindMethod);
            if (count == 1) {
                this.firstInjectors.put(bindMethod, serviceInjector);
            }
            return count;
        }

        public synchronized ServiceInjector unregisterAndGetFirstInjector(Method bindMethod) {
            if (this.counter.decrementAndGetCount(bindMethod) == 0) {
                return this.firstInjectors.remove(bindMethod);
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum State {
        INITIAL,
        STARTING,
        STARTED,
        STOPPING,
        STOPPED;

    }
}

