/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.core;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.riena.core.IRienaActivator;
import org.eclipse.riena.core.Log4r;
import org.eclipse.riena.core.RienaConstants;
import org.eclipse.riena.core.RienaPlugin;
import org.eclipse.riena.core.exception.IExceptionHandlerManager;
import org.eclipse.riena.core.wire.Wire;
import org.eclipse.riena.internal.core.StartupsSafeRunnable;
import org.eclipse.riena.internal.core.exceptionmanager.SimpleExceptionHandlerManager;
import org.eclipse.riena.internal.core.logging.LoggerProvider;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;

public class Activator
extends RienaPlugin {
    public static final String PLUGIN_ID = "org.eclipse.riena.core";
    private boolean active = false;
    private static Activator plugin;

    public Activator() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        LoggerProvider.instance().start();
        this.logStage();
        this.startStartupListener();
        this.startExceptionHandling();
    }

    private void logStage() {
        String stage;
        IStringVariableManager variableManager = VariablesPlugin.getDefault().getStringVariableManager();
        try {
            stage = variableManager.performStringSubstitution("Riena is running in stage '${riena.stage}'.");
        }
        catch (CoreException coreException) {
            stage = "No stage information set.";
        }
        Log4r.getLogger((IRienaActivator)this, Activator.class).log(3, stage);
    }

    private void startStartupListener() {
        StartupBundleListener bundleListener = new StartupBundleListener();
        this.getContext().addBundleListener((BundleListener)bundleListener);
    }

    private void startExceptionHandling() {
        SimpleExceptionHandlerManager handlerManager = new SimpleExceptionHandlerManager();
        Wire.instance(handlerManager).andStart(this.getContext());
        this.getContext().registerService(IExceptionHandlerManager.class.getName(), (Object)handlerManager, RienaConstants.newDefaultServiceProperties());
    }

    public void stop(BundleContext context) throws Exception {
        this.active = false;
        plugin = null;
        LoggerProvider.instance().stop();
        super.stop(context);
    }

    public static Activator getDefault() {
        return plugin;
    }

    public boolean isActive() {
        return this.active;
    }

    private class StartupBundleListener
    implements BundleListener {
        private StartupBundleListener() {
        }

        public void bundleChanged(BundleEvent event) {
            if (Activator.getDefault() == null) {
                return;
            }
            if (event.getBundle() == Activator.this.getContext().getBundle() && event.getType() == 2) {
                Activator.this.active = true;
                StartupsSafeRunnable safeRunnable = new StartupsSafeRunnable();
                Wire.instance(safeRunnable).andStart(Activator.this.getContext());
                SafeRunner.run((ISafeRunnable)safeRunnable);
                Activator.this.getContext().removeBundleListener((BundleListener)this);
            }
        }
    }
}

