/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.core.wire;

import java.lang.reflect.Method;
import org.eclipse.core.runtime.Assert;
import org.eclipse.riena.core.injector.Inject;
import org.eclipse.riena.core.injector.service.ServiceDescriptor;
import org.eclipse.riena.core.injector.service.ServiceInjector;
import org.eclipse.riena.core.wire.InjectService;

public class ServiceInjectorBuilder {
    private final Object bean;
    private final Method method;
    private final InjectService annotation;

    public ServiceInjectorBuilder(Object bean, Method method) {
        Assert.isLegal((bean != null ? 1 : 0) != 0, (String)"bean must not be null");
        Assert.isLegal((method != null ? 1 : 0) != 0, (String)"method must not be null");
        this.bean = bean;
        this.method = method;
        this.annotation = method.getAnnotation(InjectService.class);
        Assert.isLegal((this.annotation != null ? 1 : 0) != 0, (String)"annotation must not be null");
    }

    public ServiceInjector build() {
        ServiceDescriptor descriptor;
        if (this.annotation.serviceName().length() != 0) {
            descriptor = Inject.service(this.annotation.serviceName());
        } else if (this.annotation.service() != Void.class) {
            descriptor = Inject.service(this.annotation.service());
        } else {
            Class<?>[] types = this.method.getParameterTypes();
            Assert.isLegal((types.length == 1 ? 1 : 0) != 0, (String)("only one parameter allowed on \u00b4bind\u00b4 method: " + this.method));
            descriptor = Inject.service(types[0]);
        }
        if (this.annotation.useRanking()) {
            descriptor = descriptor.useRanking();
        } else if (this.annotation.useFilter().length() != 0) {
            descriptor = descriptor.useFilter(this.annotation.useFilter());
        }
        ServiceInjector injector = descriptor.into(this.bean).bind(this.method);
        String unbind = this.annotation.unbind().length() != 0 ? this.annotation.unbind() : "un" + this.method.getName();
        injector.unbind(unbind);
        if (this.annotation.onceOnly()) {
            injector.onceOnly();
        }
        return injector;
    }
}

