/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.example.client.controllers;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.riena.beans.common.Person;
import org.eclipse.riena.core.marker.IMarker;
import org.eclipse.riena.navigation.IModuleNode;
import org.eclipse.riena.navigation.INavigationNode;
import org.eclipse.riena.navigation.ISubModuleNode;
import org.eclipse.riena.navigation.NavigationNodeId;
import org.eclipse.riena.navigation.listener.INavigationNodeListener;
import org.eclipse.riena.navigation.listener.SubModuleNodeListener;
import org.eclipse.riena.navigation.model.SubModuleNode;
import org.eclipse.riena.navigation.ui.controllers.SubModuleController;
import org.eclipse.riena.ui.core.marker.OutputMarker;
import org.eclipse.riena.ui.core.marker.ValidationTime;
import org.eclipse.riena.ui.ridgets.IActionListener;
import org.eclipse.riena.ui.ridgets.IActionRidget;
import org.eclipse.riena.ui.ridgets.IComboRidget;
import org.eclipse.riena.ui.ridgets.IDateTextRidget;
import org.eclipse.riena.ui.ridgets.INumericTextRidget;
import org.eclipse.riena.ui.ridgets.ISingleChoiceRidget;
import org.eclipse.riena.ui.ridgets.ITextRidget;
import org.eclipse.riena.ui.ridgets.validation.MaxLength;
import org.eclipse.riena.ui.workarea.WorkareaManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OnePersonSubModuleController
extends SubModuleController {
    private static List<String> countries;
    private static int personCounter;
    private Person person;
    private INumericTextRidget customerNumber;
    private ITextRidget lastName;
    private ITextRidget firstName;
    private IDateTextRidget birthday;
    private ITextRidget birthplace;
    private ITextRidget street;
    private IComboRidget country;
    private INumericTextRidget postalcode;
    private ITextRidget town;
    private ISingleChoiceRidget gender;

    public OnePersonSubModuleController() {
        this(null);
    }

    public OnePersonSubModuleController(ISubModuleNode navigationNode) {
        super(navigationNode);
    }

    private void createPerson() {
        this.person = new Person("Mustermann", "Erika");
        this.person.setNumber(Integer.valueOf(personCounter));
        this.person.setBirthday("12.08.1964");
        this.person.setBirthplace("Berlin");
        this.person.setGender("female");
        this.person.getAddress().setStreetAndNumber("Heidestra\u00dfe 17");
        this.person.getAddress().setCountry(Locale.GERMANY.getCountry());
        this.person.getAddress().setPostalCode(81739);
        this.person.getAddress().setTown("M\u00fcnchen");
    }

    public void afterBind() {
        super.afterBind();
        this.updateAllRidgetsFromModel();
        this.updateTitle();
    }

    public synchronized List<String> getCountries() {
        if (countries == null) {
            countries = new ArrayList<String>();
            countries.add(Locale.FRANCE.getCountry());
            countries.add(Locale.CANADA.getCountry());
            countries.add(Locale.GERMANY.getCountry());
            countries.add(Locale.ITALY.getCountry());
            countries.add(Locale.UK.getCountry());
            countries.add(Locale.US.getCountry());
            String defCountry = Locale.getDefault().getCountry();
            if (!countries.contains(defCountry)) {
                countries.add(defCountry);
            }
        }
        return countries;
    }

    private void updateTitle() {
        String label = this.person.toString();
        if (this.person.getNumber() > 0) {
            label = "#" + this.person.getNumber() + " " + label;
        }
        ((ISubModuleNode)this.getNavigationNode()).setLabel(label);
    }

    public void configureRidgets() {
        this.customerNumber = (INumericTextRidget)this.getRidget("customerNumber");
        this.customerNumber.addMarker((IMarker)new OutputMarker());
        this.customerNumber.setGrouping(false);
        this.lastName = (ITextRidget)this.getRidget("lastName");
        this.lastName.setMandatory(true);
        this.firstName = (ITextRidget)this.getRidget("firstName");
        this.firstName.setMandatory(true);
        this.birthday = (IDateTextRidget)this.getRidget("birthday");
        this.birthday.setFormat("dd.MM.yyyy");
        this.birthplace = (ITextRidget)this.getRidget("birthplace");
        this.gender = (ISingleChoiceRidget)this.getRidget("gender");
        this.street = (ITextRidget)this.getRidget("street");
        this.country = (IComboRidget)this.getRidget("country");
        this.postalcode = (INumericTextRidget)this.getRidget("postalCode");
        this.postalcode.setGrouping(false);
        this.postalcode.addValidationRule((IValidator)new MaxLength(5), ValidationTime.ON_UI_CONTROL_EDIT);
        this.town = (ITextRidget)this.getRidget("town");
        IActionRidget show = (IActionRidget)this.getRidget("show");
        IActionRidget next = (IActionRidget)this.getRidget("next");
        final IActionRidget jumpBack = (IActionRidget)this.getRidget("jumpBack");
        this.createPerson();
        this.person.addPropertyChangeListener((PropertyChangeListener)new NameChangeListener());
        this.customerNumber.bindToModel((Object)this.person, "number");
        this.lastName.bindToModel((Object)this.person, "lastname");
        this.firstName.bindToModel((Object)this.person, "firstname");
        this.birthday.bindToModel((Object)this.person, "birthday");
        this.birthplace.bindToModel((Object)this.person, "birthplace");
        ArrayList<String> genders = new ArrayList<String>(2);
        genders.add("female");
        genders.add("male");
        this.gender.bindToModel(genders, genders, (Object)this.person, "gender");
        this.street.bindToModel((Object)this.person.getAddress(), "streetAndNumber");
        this.country.bindToModel((Object)this, "countries", String.class, null, (Object)this.person.getAddress(), "country");
        this.postalcode.bindToModel((Object)this.person.getAddress(), "postalCode");
        this.town.bindToModel((Object)this.person.getAddress(), "town");
        show.addListener((IActionListener)new ShowActionListener());
        next.addListener((IActionListener)new NextActionListener());
        jumpBack.addListener((IActionListener)new JumpBackActionListener());
        ((ISubModuleNode)this.getNavigationNode()).addListener((INavigationNodeListener)new SubModuleNodeListener(){

            public void afterActivated(ISubModuleNode source) {
                super.afterActivated((INavigationNode)source);
                jumpBack.setEnabled(((ISubModuleNode)OnePersonSubModuleController.this.getNavigationNode()).isJumpTarget());
            }
        });
    }

    protected INavigationNode<?> createNextPersonSubModule() {
        SubModuleNode nextSubModuleNode = new SubModuleNode(new NavigationNodeId("onePerson", Integer.toString(personCounter++)), "nextPersonLabel");
        nextSubModuleNode.setIcon("person.gif");
        WorkareaManager.getInstance().registerDefinition((INavigationNode)nextSubModuleNode, OnePersonSubModuleController.class, (Object)"org.eclipse.riena.example.client.views.OnePersonSubModuleView").setRequiredPreparation(true);
        return nextSubModuleNode;
    }

    private class JumpBackActionListener
    implements IActionListener {
        private JumpBackActionListener() {
        }

        public void callback() {
            ((ISubModuleNode)OnePersonSubModuleController.this.getNavigationNode()).jumpBack();
        }
    }

    private class NameChangeListener
    implements PropertyChangeListener {
        private NameChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("lastname") || evt.getPropertyName().equals("firstname")) {
                OnePersonSubModuleController.this.updateTitle();
            }
        }
    }

    private class NextActionListener
    implements IActionListener {
        private NextActionListener() {
        }

        public void callback() {
            ISubModuleNode nextSubModuleNode = (ISubModuleNode)OnePersonSubModuleController.this.createNextPersonSubModule();
            IModuleNode parent = (IModuleNode)((ISubModuleNode)OnePersonSubModuleController.this.getNavigationNode()).getParent();
            parent.addChild((INavigationNode)nextSubModuleNode);
        }
    }

    private class ShowActionListener
    implements IActionListener {
        private ShowActionListener() {
        }

        public void callback() {
            System.out.println("lastname: " + OnePersonSubModuleController.this.person.getLastname());
            System.out.println("firstname: " + OnePersonSubModuleController.this.person.getFirstname());
            System.out.println("birthday: " + OnePersonSubModuleController.this.person.getBirthday());
            System.out.println("birthplace: " + OnePersonSubModuleController.this.person.getBirthplace());
            System.out.println("gender: " + OnePersonSubModuleController.this.person.getGender());
            System.out.println("streetAndNumber: " + OnePersonSubModuleController.this.person.getAddress().getStreetAndNumber());
            System.out.println("country: " + OnePersonSubModuleController.this.person.getAddress().getCountry());
            System.out.println("postalCode: " + OnePersonSubModuleController.this.person.getAddress().getPostalCode());
            System.out.println("town: " + OnePersonSubModuleController.this.person.getAddress().getTown());
        }
    }
}

