/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.example.client.controllers;

import org.eclipse.riena.navigation.ISubModuleNode;
import org.eclipse.riena.navigation.ui.controllers.SubModuleController;
import org.eclipse.riena.ui.ridgets.IActionListener;
import org.eclipse.riena.ui.ridgets.IActionRidget;
import org.eclipse.riena.ui.ridgets.IToggleButtonRidget;

public class RidgetsSubModuleController
extends SubModuleController {
    private static final String ICON_SAMPLE = "sample.gif";
    private static final String ICON_RED = "ledred.png";
    private static final String ICON_GREEN = "ledlightgreen.png";
    private RidgetsModel model = new RidgetsModel();

    public RidgetsSubModuleController() {
        this(null);
    }

    public RidgetsSubModuleController(ISubModuleNode navigationNode) {
        super(navigationNode);
        this.model.setToggleOneSelected(true);
        this.model.setToggleTwoSelected(false);
        this.model.setCheckOneSelected(true);
    }

    public void configureRidgets() {
        super.configureRidgets();
        IToggleButtonRidget toggleOne = (IToggleButtonRidget)this.getRidget(IToggleButtonRidget.class, "toggleOne");
        toggleOne.setText("&Toggle 1");
        toggleOne.setIcon(ICON_SAMPLE);
        toggleOne.bindToModel((Object)this.model, "toggleOneSelected");
        toggleOne.updateFromModel();
        IToggleButtonRidget toggleTwo = (IToggleButtonRidget)this.getRidget(IToggleButtonRidget.class, "toggleTwo");
        toggleTwo.setText("&Toggle 2");
        toggleTwo.bindToModel((Object)this.model, "toggleTwoSelected");
        toggleTwo.updateFromModel();
        IToggleButtonRidget checkOne = (IToggleButtonRidget)this.getRidget(IToggleButtonRidget.class, "checkOne");
        checkOne.setText("C&heck 1");
        checkOne.bindToModel((Object)this.model, "checkOneSelected");
        checkOne.updateFromModel();
        final IActionRidget buttonOne = (IActionRidget)this.getRidget(IActionRidget.class, "buttonOne");
        buttonOne.setText("Button 1");
        buttonOne.setIcon(ICON_SAMPLE);
        buttonOne.addListener(new IActionListener(){

            public void callback() {
                buttonOne.setIcon(RidgetsSubModuleController.ICON_RED);
                System.out.println("Button clicked...");
            }
        });
        final IActionRidget buttonTwo = (IActionRidget)this.getRidget(IActionRidget.class, "buttonTwo");
        buttonTwo.setText("Button 2");
        buttonTwo.addListener(new IActionListener(){

            public void callback() {
                buttonTwo.setIcon(RidgetsSubModuleController.ICON_GREEN);
                System.out.println("Button clicked...");
            }
        });
        IActionListener actionListener = new IActionListener(){

            public void callback() {
                System.out.println("Button clicked...");
            }
        };
        IActionRidget imageButton = (IActionRidget)this.getRidget("imageButton");
        imageButton.setIcon("imageBtn");
        imageButton.addListener(actionListener);
        IActionRidget arrowButton = (IActionRidget)this.getRidget("arrowButton");
        arrowButton.setIcon("arrowRight");
        arrowButton.addListener(actionListener);
        IActionRidget arrowHotButton = (IActionRidget)this.getRidget("arrowHotButton");
        arrowHotButton.setIcon("arrowRight");
        arrowHotButton.addListener(actionListener);
    }

    private static final class RidgetsModel {
        private boolean toggleOneSelected;
        private boolean toggleTwoSelected;
        private boolean checkOneSelected;

        private RidgetsModel() {
        }

        public boolean isToggleOneSelected() {
            return this.toggleOneSelected;
        }

        public void setToggleOneSelected(boolean toggleOneSelected) {
            this.toggleOneSelected = toggleOneSelected;
        }

        public void setToggleTwoSelected(boolean toggleTwoSelected) {
            this.toggleTwoSelected = toggleTwoSelected;
        }

        public boolean isToggleTwoSelected() {
            return this.toggleTwoSelected;
        }

        public boolean isCheckOneSelected() {
            return this.checkOneSelected;
        }

        public void setCheckOneSelected(boolean checkOneSelected) {
            this.checkOneSelected = checkOneSelected;
        }
    }
}

