/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.example.ping.client.ridgets;

import org.eclipse.core.databinding.beans.BeansObservables;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.riena.example.ping.client.widgets.ProgressBarWidget;
import org.eclipse.riena.ui.ridgets.swt.AbstractSWTRidget;
import org.eclipse.riena.ui.ridgets.swt.AbstractValueRidget;
import org.eclipse.swt.graphics.Color;

public class ProgressbarRidget
extends AbstractValueRidget {
    protected static final String PROPERTY_SELECTION = "selection";
    protected static final String PROPERTY_MINIMUM = "minimum";
    protected static final String PROPERTY_MAXIMUM = "maximum";
    protected static final String PROPERTY_FOREGROUND = "foreground";
    protected static final String PROPERTY_BACKGROUND = "background";
    private Integer selection;
    private Integer minimum;
    private Integer maximum;
    private Color foreground;
    private Color background;
    private boolean foregroundAlreadyInitialized;
    private boolean backgroundAlreadyInitialized;
    private boolean selectionAlreadyInitialized;
    private boolean minimumAlreadyInitialized;
    private boolean maximumAlreadyInitialized;

    protected IObservableValue getRidgetObservable() {
        return BeansObservables.observeValue((Object)((Object)this), (String)PROPERTY_SELECTION);
    }

    protected void bindUIControl() {
        this.initMinimum();
        this.updateUIMinimum();
        this.initMaximum();
        this.updateUIMaximum();
        this.initSelection();
        this.updateUISelection();
        this.initForeground();
        this.updateUIForeground();
        this.initBackground();
        this.updateUIBackground();
    }

    protected void checkUIControl(Object uiControl) {
        AbstractSWTRidget.assertType((Object)uiControl, ProgressBarWidget.class);
    }

    public boolean isDisableMandatoryMarker() {
        return true;
    }

    protected ProgressBarWidget getProgressBarWidget() {
        return (ProgressBarWidget)this.getUIControl();
    }

    public int getMinimum() {
        if (this.minimum == null) {
            return 0;
        }
        return this.minimum;
    }

    public void setMinimum(int minimum) {
        Integer oldMinimum = this.minimum;
        this.minimum = minimum;
        this.updateUIMinimum();
        this.firePropertyChange(PROPERTY_MINIMUM, oldMinimum, minimum);
    }

    private void updateUIMinimum() {
        if (this.getUIControl() != null) {
            this.getProgressBarWidget().setMinimum(this.minimum);
        }
    }

    private void initMinimum() {
        if (this.minimum == null && !this.minimumAlreadyInitialized && this.getProgressBarWidget() != null && !this.getProgressBarWidget().isDisposed()) {
            this.minimum = this.getProgressBarWidget().getMinimum();
            this.minimumAlreadyInitialized = true;
        }
    }

    public int getMaximum() {
        if (this.maximum == null) {
            return 0;
        }
        return this.maximum;
    }

    public void setMaximum(int maximum) {
        Integer oldMaximum = this.maximum;
        this.maximum = maximum;
        this.updateUIMaximum();
        this.firePropertyChange(PROPERTY_MAXIMUM, oldMaximum, maximum);
    }

    private void updateUIMaximum() {
        if (this.getUIControl() != null) {
            this.getProgressBarWidget().setMaximum(this.maximum);
        }
    }

    private void initMaximum() {
        if (this.maximum == null && !this.maximumAlreadyInitialized && this.getProgressBarWidget() != null && !this.getProgressBarWidget().isDisposed()) {
            this.maximum = this.getProgressBarWidget().getMaximum();
            this.maximumAlreadyInitialized = true;
        }
    }

    public int getSelection() {
        if (this.selection == null) {
            return 0;
        }
        return this.selection;
    }

    public void setSelection(int selection) {
        Integer oldSelection = this.selection;
        this.selection = selection;
        this.updateUISelection();
        this.firePropertyChange(PROPERTY_SELECTION, oldSelection, selection);
    }

    private void updateUISelection() {
        if (this.getUIControl() != null) {
            this.getProgressBarWidget().setSelection(this.selection);
        }
    }

    private void initSelection() {
        if (this.selection == null && !this.selectionAlreadyInitialized && this.getProgressBarWidget() != null && !this.getProgressBarWidget().isDisposed()) {
            this.selection = this.getProgressBarWidget().getSelection();
            this.selectionAlreadyInitialized = true;
        }
    }

    public Color getForeground() {
        return this.foreground;
    }

    public void setForeground(Color foreground) {
        Color oldForeground = this.foreground;
        this.foreground = foreground;
        this.updateUIForeground();
        this.firePropertyChange(PROPERTY_FOREGROUND, oldForeground, foreground);
    }

    private void updateUIForeground() {
        if (this.getUIControl() != null) {
            this.getProgressBarWidget().setForeground(this.foreground);
        }
    }

    private void initForeground() {
        if (this.foreground == null && !this.foregroundAlreadyInitialized && this.getProgressBarWidget() != null && !this.getProgressBarWidget().isDisposed()) {
            this.foreground = this.getProgressBarWidget().getForeground();
            this.foregroundAlreadyInitialized = true;
        }
    }

    public Color getBackground() {
        return this.background;
    }

    public void setBackground(Color background) {
        Color oldBackground = this.background;
        this.background = background;
        this.updateUIBackground();
        this.firePropertyChange(PROPERTY_BACKGROUND, oldBackground, background);
    }

    private void updateUIBackground() {
        if (this.getUIControl() != null) {
            this.getProgressBarWidget().setBackground(this.background);
        }
    }

    private void initBackground() {
        if (this.background == null && !this.backgroundAlreadyInitialized && this.getProgressBarWidget() != null && !this.getProgressBarWidget().isDisposed()) {
            this.background = this.getProgressBarWidget().getBackground();
            this.backgroundAlreadyInitialized = true;
        }
    }
}

