/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.navigation.ui.swt.handlers;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.riena.navigation.ApplicationNodeManager;
import org.eclipse.riena.navigation.IApplicationNode;
import org.eclipse.riena.navigation.IModuleGroupNode;
import org.eclipse.riena.navigation.IModuleNode;
import org.eclipse.riena.navigation.INavigationNode;
import org.eclipse.riena.navigation.ISubApplicationNode;
import org.eclipse.riena.navigation.ISubModuleNode;
import org.eclipse.riena.navigation.model.NavigationModelFailure;
import org.eclipse.ui.AbstractSourceProvider;
import org.eclipse.ui.services.IServiceLocator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NavigationSourceProvider
extends AbstractSourceProvider {
    private static final String ACTIVE_SUB_APPLICATION_NODE_ID = "activeSubApplicationNodeId";
    private static final String ACTIVE_MODULE_GROUP_NODE_ID = "activeModuleGroupNodeId";
    private static final String ACTIVE_MODULE_NODE_ID = "activeModuleNodeId";
    private static final String ACTIVE_SUB_MODULE_NODE_ID = "activeSubModuleNodeId";
    private static final int ACTIVE_NODE_ID = 0x10000000;
    private static final String[] PROVIDED_SOURCE_NAMES = new String[]{"activeSubApplicationNodeId", "activeModuleGroupNodeId", "activeModuleNodeId", "activeSubModuleNodeId"};
    private static NavigationSourceProvider sourceProvider;

    public void initialize(IServiceLocator locator) {
        super.initialize(locator);
        sourceProvider = this;
    }

    public void dispose() {
        sourceProvider = null;
    }

    public final Map<String, String> getCurrentState() {
        HashMap<String, String> state = new HashMap<String, String>();
        String id = this.getTypeNodeId((INavigationNode<?>)ApplicationNodeManager.locateActiveSubApplicationNode());
        state.put(ACTIVE_SUB_APPLICATION_NODE_ID, id);
        id = this.getTypeNodeId((INavigationNode<?>)ApplicationNodeManager.locateActiveModuleGroupNode());
        state.put(ACTIVE_MODULE_GROUP_NODE_ID, id);
        id = this.getTypeNodeId((INavigationNode<?>)ApplicationNodeManager.locateActiveModuleNode());
        state.put(ACTIVE_MODULE_NODE_ID, id);
        id = this.getTypeNodeId((INavigationNode<?>)ApplicationNodeManager.locateActiveSubModuleNode());
        state.put(ACTIVE_SUB_MODULE_NODE_ID, id);
        return state;
    }

    public String[] getProvidedSourceNames() {
        return PROVIDED_SOURCE_NAMES;
    }

    void fireSourceChange(INavigationNode<?> node) {
        this.fireSourceChanged(0x10000000, this.getPovidesSourceName(node), this.getTypeNodeId(node));
    }

    private String getTypeNodeId(INavigationNode<?> node) {
        if (node != null && node.getNodeId() != null) {
            return node.getNodeId().getTypeId();
        }
        return "";
    }

    public String getPovidesSourceName(INavigationNode<?> node) {
        if (node == null) {
            return null;
        }
        if (node instanceof ISubApplicationNode) {
            return ACTIVE_SUB_APPLICATION_NODE_ID;
        }
        if (node instanceof IModuleGroupNode) {
            return ACTIVE_MODULE_GROUP_NODE_ID;
        }
        if (node instanceof IModuleNode) {
            return ACTIVE_MODULE_NODE_ID;
        }
        if (node instanceof ISubModuleNode) {
            return ACTIVE_SUB_MODULE_NODE_ID;
        }
        throw new NavigationModelFailure("Unsupported instance of INavigationNode: " + node);
    }

    public static void activeNodeChanged(INavigationNode<?> node) {
        if (sourceProvider != null) {
            sourceProvider.fireSourceChange(node);
            if (node.getParent() != null && !(node.getParent() instanceof IApplicationNode)) {
                NavigationSourceProvider.activeNodeChanged(node.getParent());
            }
        }
    }
}

