/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.core.injector.extension;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.List;
import junit.framework.AssertionFailedError;
import org.eclipse.riena.core.injector.Inject;
import org.eclipse.riena.core.injector.extension.ConfigurableThingMultipleData;
import org.eclipse.riena.core.injector.extension.ExtensionInjector;
import org.eclipse.riena.core.util.ReflectionUtils;
import org.eclipse.riena.core.util.WeakRef;
import org.eclipse.riena.internal.core.test.RienaTestCase;
import org.eclipse.riena.internal.core.test.collect.NonUITestCase;

@NonUITestCase
public class ExtensionInjectorWeakRefTest
extends RienaTestCase {
    public void testWeakRefFail() throws IOException {
        try {
            this.testWeakRef(false);
            ExtensionInjectorWeakRefTest.fail();
        }
        catch (AssertionFailedError assertionFailedError) {
            this.ok();
        }
    }

    public void testWeakRefSucceed() throws IOException {
        this.testWeakRef(true);
    }

    private void testWeakRef(boolean withNulling) throws IOException {
        this.printTestName();
        this.addPluginXml(ExtensionInjectorWeakRefTest.class, "plugin.xml");
        this.addPluginXml(ExtensionInjectorWeakRefTest.class, "plugin_ext1.xml");
        this.addPluginXml(ExtensionInjectorWeakRefTest.class, "plugin_ext2.xml");
        this.addPluginXml(ExtensionInjectorWeakRefTest.class, "plugin_ext3.xml");
        try {
            ConfigurableThingMultipleData target = new ConfigurableThingMultipleData();
            ExtensionInjector injector = Inject.extension((String)"core.test.extpoint").into((Object)target).andStart(this.getContext());
            try {
                ExtensionInjectorWeakRefTest.assertEquals((int)3, (int)target.getData().length);
                target = null;
                this.runOutOfMemory();
                WeakRef ref = (WeakRef)ReflectionUtils.getHidden((Object)injector, (String)"targetRef");
                ExtensionInjectorWeakRefTest.assertNull((Object)ref.get());
                List injectorListeners = (List)ReflectionUtils.getHidden((Object)injector, (String)"injectorListeners");
                ExtensionInjectorWeakRefTest.assertEquals((int)0, (int)injectorListeners.size());
            }
            finally {
                injector.stop();
            }
        }
        finally {
            this.removeExtension("core.test.extpoint.id1");
            this.removeExtension("core.test.extpoint.id2");
            this.removeExtension("core.test.extpoint.id3");
            this.removeExtensionPoint("core.test.extpoint");
        }
    }

    private void runOutOfMemory() throws IOException {
        try {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            while (true) {
                os.write(new byte[0x100000]);
            }
        }
        catch (OutOfMemoryError outOfMemoryError) {
            System.gc();
            return;
        }
    }
}

