/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.core.util;

import java.util.Hashtable;
import java.util.Map;
import org.eclipse.riena.core.util.Literal;
import org.eclipse.riena.core.util.PropertiesUtils;
import org.eclipse.riena.internal.core.test.RienaTestCase;
import org.eclipse.riena.internal.core.test.collect.NonUITestCase;

@NonUITestCase
public class PropertiesUtilsTest
extends RienaTestCase {
    public void testAsMapNullString() {
        Map map = PropertiesUtils.asMap(null, (String[])new String[0]);
        PropertiesUtilsTest.assertEquals((int)0, (int)map.size());
    }

    public void testAsMapWithHashtable() {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put("a", "1");
        hashtable.put("b", "2");
        Map map = PropertiesUtils.asMap(hashtable, (String[])new String[0]);
        PropertiesUtilsTest.assertEquals((int)2, (int)map.size());
        PropertiesUtilsTest.assertEquals((String)"1", (String)((String)map.get("a")));
        PropertiesUtilsTest.assertEquals((String)"2", (String)((String)map.get("b")));
    }

    public void testAsMapWithHashtableWithExpectation() {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put("a", "1");
        hashtable.put("b", "2");
        Map map = PropertiesUtils.asMap(hashtable, (String[])new String[]{"a", "b"});
        PropertiesUtilsTest.assertEquals((int)2, (int)map.size());
        PropertiesUtilsTest.assertEquals((String)"1", (String)((String)map.get("a")));
        PropertiesUtilsTest.assertEquals((String)"2", (String)((String)map.get("b")));
    }

    public void testAsMapEmptyString() {
        Map map = PropertiesUtils.asMap((Object)"", (String[])new String[0]);
        PropertiesUtilsTest.assertEquals((int)0, (int)map.size());
    }

    public void testAsMap() {
        Map map = PropertiesUtils.asMap((Object)"a=1;b=2", (String[])new String[0]);
        PropertiesUtilsTest.assertEquals((int)2, (int)map.size());
        PropertiesUtilsTest.assertEquals((String)"1", (String)((String)map.get("a")));
        PropertiesUtilsTest.assertEquals((String)"2", (String)((String)map.get("b")));
    }

    public void testAsMapWithExpectationFullfill() {
        Map map = PropertiesUtils.asMap((Object)"a=1;b=2", (String[])new String[]{"a", "b"});
        PropertiesUtilsTest.assertEquals((String)"1", (String)((String)map.get("a")));
        PropertiesUtilsTest.assertEquals((String)"2", (String)((String)map.get("b")));
    }

    public void testAsMapWithExpectationFails() {
        try {
            PropertiesUtils.asMap((Object)"a=1;b=2", (String[])new String[]{"a", "c"});
            PropertiesUtilsTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.ok();
        }
    }

    public void testAsMapIgnoreWhitespace() {
        Map map = PropertiesUtils.asMap((Object)" a= 1 ;  b = 2   ", (String[])new String[0]);
        PropertiesUtilsTest.assertEquals((String)"1", (String)((String)map.get("a")));
        PropertiesUtilsTest.assertEquals((String)"2", (String)((String)map.get("b")));
    }

    public void testAsMapFailMissingEquals() {
        try {
            PropertiesUtils.asMap((Object)" a: 1 ;  b = 2   ", (String[])new String[0]);
            PropertiesUtilsTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.ok();
        }
    }

    public void testAsMapWithDefaults() {
        Map map = PropertiesUtils.asMap((Object)"a=5", (Map)Literal.map((Object)"a", (Object)"1").map((Object)"b", (Object)"2").map((Object)"c", (Object)"3"), (String[])new String[0]);
        PropertiesUtilsTest.assertEquals((int)3, (int)map.size());
        PropertiesUtilsTest.assertEquals((String)"5", (String)((String)map.get("a")));
        PropertiesUtilsTest.assertEquals((String)"2", (String)((String)map.get("b")));
        PropertiesUtilsTest.assertEquals((String)"3", (String)((String)map.get("c")));
    }

    public void testAsMapWithDefaultsAndNoData() {
        Map map = PropertiesUtils.asMap(null, (Map)Literal.map((Object)"a", (Object)"1").map((Object)"b", (Object)"2").map((Object)"c", (Object)"3"), (String[])new String[0]);
        PropertiesUtilsTest.assertEquals((int)3, (int)map.size());
        PropertiesUtilsTest.assertEquals((String)"1", (String)((String)map.get("a")));
        PropertiesUtilsTest.assertEquals((String)"2", (String)((String)map.get("b")));
        PropertiesUtilsTest.assertEquals((String)"3", (String)((String)map.get("c")));
    }

    public void testAsArrayEmpty() {
        PropertiesUtilsTest.assertEquals((int)0, (int)PropertiesUtils.asArray((Object)"").length);
        PropertiesUtilsTest.assertEquals((int)0, (int)PropertiesUtils.asArray(null).length);
    }

    public void testAsArrayWithContent() {
        String[] actual = PropertiesUtils.asArray((Object)"a,b,c");
        PropertiesUtilsTest.assertEquals((int)3, (int)actual.length);
        PropertiesUtilsTest.assertEquals((String)"a", (String)actual[0]);
        PropertiesUtilsTest.assertEquals((String)"b", (String)actual[1]);
        PropertiesUtilsTest.assertEquals((String)"c", (String)actual[2]);
    }

    public void testAsArrayWithContentPlusFinalComma() {
        String[] actual = PropertiesUtils.asArray((Object)"a,");
        PropertiesUtilsTest.assertEquals((int)2, (int)actual.length);
        PropertiesUtilsTest.assertEquals((String)"a", (String)actual[0]);
        PropertiesUtilsTest.assertEquals((String)"", (String)actual[1]);
    }

    public void testAsArrayWithEmptyContentWithinCommas() {
        String[] actual = PropertiesUtils.asArray((Object)"a,b,,c");
        PropertiesUtilsTest.assertEquals((int)4, (int)actual.length);
        PropertiesUtilsTest.assertEquals((String)"a", (String)actual[0]);
        PropertiesUtilsTest.assertEquals((String)"b", (String)actual[1]);
        PropertiesUtilsTest.assertEquals((String)"", (String)actual[2]);
        PropertiesUtilsTest.assertEquals((String)"c", (String)actual[3]);
    }

    public void testAsArrayWithOnlyEmptyContentWithinCommas() {
        String[] actual = PropertiesUtils.asArray((Object)",,,");
        PropertiesUtilsTest.assertEquals((int)4, (int)actual.length);
        PropertiesUtilsTest.assertEquals((String)"", (String)actual[0]);
        PropertiesUtilsTest.assertEquals((String)"", (String)actual[1]);
        PropertiesUtilsTest.assertEquals((String)"", (String)actual[2]);
        PropertiesUtilsTest.assertEquals((String)"", (String)actual[3]);
    }

    public void testAsArrayWithOnlyOneComma() {
        String[] actual = PropertiesUtils.asArray((Object)",");
        PropertiesUtilsTest.assertEquals((int)2, (int)actual.length);
        PropertiesUtilsTest.assertEquals((String)"", (String)actual[0]);
        PropertiesUtilsTest.assertEquals((String)"", (String)actual[1]);
    }

    public void testAsArrayWithBackslashComma() {
        String[] actual = PropertiesUtils.asArray((Object)"1,2\\,3,4");
        PropertiesUtilsTest.assertEquals((int)3, (int)actual.length);
        PropertiesUtilsTest.assertEquals((String)"1", (String)actual[0]);
        PropertiesUtilsTest.assertEquals((String)"2,3", (String)actual[1]);
        PropertiesUtilsTest.assertEquals((String)"4", (String)actual[2]);
    }

    public void testAsArrayWithBackslashBackSlashComma() {
        String[] actual = PropertiesUtils.asArray((Object)"1,2\\,3,\\\\,4");
        PropertiesUtilsTest.assertEquals((int)4, (int)actual.length);
        PropertiesUtilsTest.assertEquals((String)"1", (String)actual[0]);
        PropertiesUtilsTest.assertEquals((String)"2,3", (String)actual[1]);
        PropertiesUtilsTest.assertEquals((String)"\\", (String)actual[2]);
        PropertiesUtilsTest.assertEquals((String)"4", (String)actual[3]);
    }

    public void testAsArrayWithUnknownEscapeCharacter() {
        try {
            PropertiesUtils.asArray((Object)"1,2\\n,3,\\\\,4");
            PropertiesUtilsTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.ok();
        }
    }
}

