/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.core.wire;

import java.util.HashMap;
import org.eclipse.riena.core.wire.AnnoExtBeanB;
import org.eclipse.riena.core.wire.AnnoServiceBeanA;
import org.eclipse.riena.core.wire.AnnoServiceBeanB;
import org.eclipse.riena.core.wire.Bean;
import org.eclipse.riena.core.wire.BeanOnBean;
import org.eclipse.riena.core.wire.BeanOnBeanWiring;
import org.eclipse.riena.core.wire.BeanWiring;
import org.eclipse.riena.core.wire.BeanWiringMock;
import org.eclipse.riena.core.wire.NoWirableBean;
import org.eclipse.riena.core.wire.Schtonk;
import org.eclipse.riena.core.wire.SequenceUtil;
import org.eclipse.riena.core.wire.Stunk;
import org.eclipse.riena.core.wire.Wire;
import org.eclipse.riena.core.wire.WirePuller;
import org.eclipse.riena.internal.core.test.RienaTestCase;
import org.eclipse.riena.internal.core.test.collect.NonUITestCase;
import org.eclipse.riena.internal.tests.Activator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

@NonUITestCase
public class WireTest
extends RienaTestCase {
    private BundleContext context = Activator.getDefault().getContext();
    private ServiceRegistration schtonkReg;
    private ServiceRegistration stunkReg;

    protected void setUp() throws Exception {
        super.setUp();
        this.schtonkReg = this.context.registerService(Schtonk.class.getName(), (Object)new Schtonk(), null);
        this.stunkReg = this.context.registerService(Stunk.class.getName(), (Object)new Stunk(), null);
    }

    protected void tearDown() throws Exception {
        this.schtonkReg.unregister();
        this.stunkReg.unregister();
        super.tearDown();
    }

    public void testWiringBean() {
        Bean bean = new Bean();
        WirePuller puller = Wire.instance((Object)bean).andStart(this.context);
        WireTest.assertTrue((boolean)bean.hasSchtonk());
        puller.stop();
    }

    public void testWiringDeeplyAndCheckSequenceConstraint() {
        BeanOnBean beanOnBean = new BeanOnBean();
        SequenceUtil.init();
        WirePuller puller = Wire.instance((Object)beanOnBean).andStart(this.context);
        SequenceUtil.assertExpected(BeanWiring.class, BeanOnBeanWiring.class);
        WireTest.assertTrue((boolean)beanOnBean.hasSchtonk());
        WireTest.assertTrue((boolean)beanOnBean.hasStunk());
        SequenceUtil.init();
        puller.stop();
        SequenceUtil.assertExpected(BeanOnBeanWiring.class, BeanWiring.class);
    }

    public void testWiringDeeply() {
        NoWirableBean noWirableBean = new NoWirableBean();
        SequenceUtil.init();
        WirePuller puller = Wire.instance((Object)noWirableBean).andStart(this.context);
        SequenceUtil.assertExpected(BeanWiring.class);
        WireTest.assertTrue((boolean)noWirableBean.hasSchtonk());
        puller.stop();
    }

    public void testWireMocking() {
        HashMap<Class<Bean>, Class<BeanWiringMock>> wiringMocks = new HashMap<Class<Bean>, Class<BeanWiringMock>>();
        wiringMocks.put(Bean.class, BeanWiringMock.class);
        WirePuller.injectWiringMocks(wiringMocks);
        Bean bean = new Bean();
        WirePuller puller = Wire.instance((Object)bean).andStart(this.context);
        WireTest.assertTrue((boolean)bean.isSchtonkSchtonk());
        puller.stop();
        WirePuller.injectWiringMocks(null);
    }

    public void testAnnotatedServiceWiring() {
        AnnoServiceBeanB beanB = new AnnoServiceBeanB();
        SequenceUtil.init();
        WirePuller puller = Wire.instance((Object)beanB).andStart(this.context);
        SequenceUtil.assertExpected(AnnoServiceBeanA.class, AnnoServiceBeanB.class);
        SequenceUtil.init();
        puller.stop();
        SequenceUtil.assertExpected(AnnoServiceBeanB.class, AnnoServiceBeanA.class);
    }

    public void testAnnotatedExtensionWiring() {
        this.addPluginXml(WireTest.class, "plugin.xml");
        this.addPluginXml(WireTest.class, "plugin_ext.xml");
        try {
            AnnoExtBeanB beanB = new AnnoExtBeanB();
            SequenceUtil.init();
            WirePuller puller = Wire.instance((Object)beanB).andStart(this.context);
            SequenceUtil.assertExpected("textA", "infoB");
            SequenceUtil.init();
            puller.stop();
            SequenceUtil.assertExpected("-IDataB", "-IDataA");
        }
        finally {
            this.removeExtension("core.test.extpoint.idA");
            this.removeExtension("core.test.extpoint.idB");
        }
    }
}

