/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.ui.ridgets.swt;

import org.eclipse.riena.internal.core.test.RienaTestCase;
import org.eclipse.riena.internal.core.test.collect.UITestCase;
import org.eclipse.riena.ui.swt.ChoiceComposite;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

@UITestCase
public class ChoiceCompositeTest
extends RienaTestCase {
    private Shell shell;

    protected void setUp() throws Exception {
        super.setUp();
        Display display = Display.getDefault();
        this.shell = new Shell(display);
        this.shell.setLayout((Layout)new FillLayout());
        this.shell.setSize(130, 100);
        this.shell.setLocation(0, 0);
        this.shell.open();
    }

    protected void tearDown() throws Exception {
        this.shell.dispose();
        this.shell = null;
        super.tearDown();
    }

    public void testConstructor() {
        try {
            new ChoiceComposite(null, 0, false);
            ChoiceCompositeTest.fail();
        }
        catch (RuntimeException runtimeException) {
            this.ok();
        }
        ChoiceComposite control1 = new ChoiceComposite((Composite)this.shell, 0, false);
        ChoiceCompositeTest.assertFalse((boolean)control1.isMultipleSelection());
        ChoiceComposite control2 = new ChoiceComposite((Composite)this.shell, 0, true);
        ChoiceCompositeTest.assertTrue((boolean)control2.isMultipleSelection());
    }

    public void testSetOrientation() {
        ChoiceComposite control = new ChoiceComposite((Composite)this.shell, 0, false);
        ChoiceCompositeTest.assertEquals((int)512, (int)control.getOrientation());
        control.setOrientation(256);
        ChoiceCompositeTest.assertEquals((int)256, (int)control.getOrientation());
        ChoiceCompositeTest.assertTrue((boolean)(control.getLayout() instanceof RowLayout));
        ChoiceCompositeTest.assertEquals((int)256, (int)((RowLayout)control.getLayout()).type);
        control.setOrientation(512);
        ChoiceCompositeTest.assertEquals((int)512, (int)control.getOrientation());
        ChoiceCompositeTest.assertTrue((boolean)(control.getLayout() instanceof FillLayout));
        ChoiceCompositeTest.assertEquals((int)512, (int)((FillLayout)control.getLayout()).type);
        try {
            control.setOrientation(0);
            ChoiceCompositeTest.fail();
        }
        catch (RuntimeException runtimeException) {
            ChoiceCompositeTest.assertEquals((int)512, (int)control.getOrientation());
        }
    }

    public void testSetForeground() {
        ChoiceComposite control = new ChoiceComposite((Composite)this.shell, 0, false);
        Button child1 = new Button((Composite)control, 16);
        Color colorGreen = control.getDisplay().getSystemColor(5);
        ChoiceCompositeTest.assertTrue((!colorGreen.equals((Object)control.getForeground()) ? 1 : 0) != 0);
        control.setForeground(colorGreen);
        ChoiceCompositeTest.assertEquals((Object)colorGreen, (Object)control.getForeground());
        ChoiceCompositeTest.assertEquals((Object)colorGreen, (Object)child1.getForeground());
    }

    public void testSetBackground() {
        ChoiceComposite control = new ChoiceComposite((Composite)this.shell, 0, false);
        Button child1 = new Button((Composite)control, 16);
        Color colorRed = control.getDisplay().getSystemColor(3);
        ChoiceCompositeTest.assertTrue((!colorRed.equals((Object)control.getBackground()) ? 1 : 0) != 0);
        control.setBackground(colorRed);
        ChoiceCompositeTest.assertEquals((Object)colorRed, (Object)control.getBackground());
        ChoiceCompositeTest.assertEquals((Object)colorRed, (Object)child1.getBackground());
    }

    public void testSetEnabled() {
        ChoiceComposite control = new ChoiceComposite((Composite)this.shell, 0, false);
        Button child1 = new Button((Composite)control, 16);
        ChoiceCompositeTest.assertTrue((boolean)control.getEnabled());
        ChoiceCompositeTest.assertTrue((boolean)child1.getEnabled());
        control.setEnabled(false);
        ChoiceCompositeTest.assertFalse((boolean)control.getEnabled());
        ChoiceCompositeTest.assertFalse((boolean)child1.getEnabled());
        control.setEnabled(true);
        ChoiceCompositeTest.assertTrue((boolean)control.getEnabled());
        ChoiceCompositeTest.assertTrue((boolean)child1.getEnabled());
    }
}

