/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.ui.ridgets.swt;

import java.beans.PropertyChangeEvent;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.riena.core.marker.AbstractMarker;
import org.eclipse.riena.core.marker.IMarker;
import org.eclipse.riena.internal.ui.ridgets.swt.AbstractSWTRidgetTest;
import org.eclipse.riena.internal.ui.ridgets.swt.TextRidget;
import org.eclipse.riena.ui.core.marker.ErrorMarker;
import org.eclipse.riena.ui.core.marker.ErrorMessageMarker;
import org.eclipse.riena.ui.core.marker.IMarkerPropertyChangeEvent;
import org.eclipse.riena.ui.core.marker.MandatoryMarker;
import org.eclipse.riena.ui.ridgets.IMarkableRidget;
import org.eclipse.riena.ui.ridgets.IRidget;
import org.eclipse.riena.ui.ridgets.ITextRidget;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public class MarkableRidgetTest
extends AbstractSWTRidgetTest {
    protected Control createWidget(Composite parent) {
        return new Text(parent, 4);
    }

    protected IRidget createRidget() {
        return new TextRidget();
    }

    protected IMarkableRidget getRidget() {
        return (IMarkableRidget)super.getRidget();
    }

    public void testSetEnabled() {
        IMarkableRidget ridget = this.getRidget();
        MarkableRidgetTest.assertTrue((boolean)ridget.isEnabled());
        ridget.setEnabled(false);
        MarkableRidgetTest.assertFalse((boolean)ridget.isEnabled());
        ridget.setEnabled(true);
        MarkableRidgetTest.assertTrue((boolean)ridget.isEnabled());
    }

    public void testSetErrorMarked() {
        IMarkableRidget ridget = this.getRidget();
        MarkableRidgetTest.assertFalse((boolean)ridget.isErrorMarked());
        ridget.setErrorMarked(true);
        MarkableRidgetTest.assertTrue((boolean)ridget.isErrorMarked());
        ridget.setErrorMarked(false);
        MarkableRidgetTest.assertFalse((boolean)ridget.isErrorMarked());
    }

    public void testSetMandatory() {
        IMarkableRidget ridget = this.getRidget();
        MarkableRidgetTest.assertFalse((boolean)ridget.isMandatory());
        ridget.setMandatory(true);
        MarkableRidgetTest.assertTrue((boolean)ridget.isMandatory());
        ridget.setMandatory(false);
        MarkableRidgetTest.assertFalse((boolean)ridget.isMandatory());
    }

    public void testIsDisableMandatoryMarker() {
        IMarkableRidget ridget = this.getRidget();
        ridget.setMandatory(true);
        MarkableRidgetTest.assertFalse((boolean)ridget.isDisableMandatoryMarker());
        MarkableRidgetTest.assertTrue((boolean)ridget.isMandatory());
        ((ITextRidget)ridget).setText("foo");
        MarkableRidgetTest.assertTrue((boolean)ridget.isDisableMandatoryMarker());
        MarkableRidgetTest.assertTrue((boolean)ridget.isMandatory());
        ((ITextRidget)ridget).setText("   ");
        MarkableRidgetTest.assertTrue((boolean)ridget.isDisableMandatoryMarker());
        MarkableRidgetTest.assertTrue((boolean)ridget.isMandatory());
        ((ITextRidget)ridget).setText("");
        MarkableRidgetTest.assertFalse((boolean)ridget.isDisableMandatoryMarker());
        MarkableRidgetTest.assertTrue((boolean)ridget.isMandatory());
    }

    public void testSetOutputOnly() {
        IMarkableRidget ridget = this.getRidget();
        MarkableRidgetTest.assertFalse((boolean)ridget.isOutputOnly());
        ridget.setOutputOnly(true);
        MarkableRidgetTest.assertTrue((boolean)ridget.isOutputOnly());
        ridget.setOutputOnly(false);
        MarkableRidgetTest.assertFalse((boolean)ridget.isOutputOnly());
    }

    public void testAddMarker() throws Exception {
        IMarkableRidget ridget = this.getRidget();
        ErrorMarker marker1 = new ErrorMarker();
        MandatoryMarker marker2 = new MandatoryMarker();
        this.expectNoPropertyChangeEvent();
        ridget.addMarker(null);
        this.verifyPropertyChangeEvents();
        Collection markers = ridget.getMarkers();
        MarkableRidgetTest.assertEquals((int)0, (int)markers.size());
        Collection<MandatoryMarker> newValue = new HashSet<ErrorMarker>();
        newValue.add((MandatoryMarker)marker1);
        this.expectPropertyChangeEvents(new ExpectedMarkerPropertyChangeEvent(ridget.getMarkers(), newValue, false));
        ridget.addMarker((IMarker)marker1);
        this.verifyPropertyChangeEvents();
        newValue = ridget.getMarkers();
        markers = ridget.getMarkers();
        MarkableRidgetTest.assertEquals((int)1, (int)markers.size());
        MarkableRidgetTest.assertTrue((boolean)markers.contains(marker1));
        newValue.add(marker2);
        this.expectPropertyChangeEvents(new ExpectedMarkerPropertyChangeEvent(ridget.getMarkers(), newValue, false));
        ridget.addMarker((IMarker)marker2);
        this.verifyPropertyChangeEvents();
        markers = ridget.getMarkers();
        MarkableRidgetTest.assertEquals((int)2, (int)markers.size());
        MarkableRidgetTest.assertTrue((boolean)markers.contains(marker1));
        MarkableRidgetTest.assertTrue((boolean)markers.contains(marker2));
        this.expectNoPropertyChangeEvent();
        ridget.addMarker((IMarker)marker2);
        this.verifyPropertyChangeEvents();
        markers = ridget.getMarkers();
        MarkableRidgetTest.assertEquals((int)2, (int)markers.size());
        MarkableRidgetTest.assertTrue((boolean)markers.contains(marker1));
        MarkableRidgetTest.assertTrue((boolean)markers.contains(marker2));
        this.resetPropertyChangeEvents();
    }

    public void testRemoveMarker() throws Exception {
        IMarkableRidget ridget = this.getRidget();
        ErrorMarker marker1 = new ErrorMarker();
        MandatoryMarker marker2 = new MandatoryMarker();
        AbstractMarker marker3 = new AbstractMarker(){};
        ridget.addMarker((IMarker)marker1);
        ridget.addMarker((IMarker)marker2);
        this.expectNoPropertyChangeEvent();
        ridget.removeMarker(null);
        ridget.removeMarker((IMarker)marker3);
        this.verifyPropertyChangeEvents();
        HashSet newValue = new HashSet(ridget.getMarkers());
        newValue.remove(marker1);
        this.expectPropertyChangeEvents(new ExpectedMarkerPropertyChangeEvent(ridget.getMarkers(), newValue, false));
        ridget.removeMarker((IMarker)marker1);
        this.verifyPropertyChangeEvents();
        Collection markers = ridget.getMarkers();
        MarkableRidgetTest.assertEquals((int)1, (int)markers.size());
        MarkableRidgetTest.assertTrue((boolean)markers.contains(marker2));
        this.expectNoPropertyChangeEvent();
        marker1.setAttribute("TestAttribute", (Object)"TestValue");
        this.verifyPropertyChangeEvents();
        this.resetPropertyChangeEvents();
    }

    public void testRemoveAllMarkers() throws Exception {
        IMarkableRidget ridget = this.getRidget();
        ErrorMarker marker1 = new ErrorMarker();
        MandatoryMarker marker2 = new MandatoryMarker();
        ridget.addMarker((IMarker)marker1);
        ridget.addMarker((IMarker)marker2);
        HashSet newValue = new HashSet(ridget.getMarkers());
        newValue.clear();
        this.expectPropertyChangeEvents(new ExpectedMarkerPropertyChangeEvent(ridget.getMarkers(), newValue, false));
        ridget.removeAllMarkers();
        this.verifyPropertyChangeEvents();
        Collection markers = ridget.getMarkers();
        MarkableRidgetTest.assertEquals((int)0, (int)markers.size());
        this.expectNoPropertyChangeEvent();
        ridget.removeAllMarkers();
        marker1.setAttribute("TestAttribute", (Object)"TestValue");
        this.verifyPropertyChangeEvents();
        markers = ridget.getMarkers();
        MarkableRidgetTest.assertEquals((int)0, (int)markers.size());
    }

    public void testGetMarkers() throws Exception {
        IMarkableRidget ridget = this.getRidget();
        ErrorMarker marker = new ErrorMarker();
        Collection markers = ridget.getMarkers();
        MarkableRidgetTest.assertNotNull((Object)markers);
        ridget.addMarker((IMarker)marker);
        Collection markers2 = ridget.getMarkers();
        MarkableRidgetTest.assertEquals((int)0, (int)markers.size());
        MarkableRidgetTest.assertEquals((int)1, (int)markers2.size());
    }

    public void testGetMarkersOfType() throws Exception {
        IMarkableRidget ridget = this.getRidget();
        ErrorMarker errorMarker = new ErrorMarker();
        MandatoryMarker mandatoryMarker = new MandatoryMarker();
        Collection markers = ridget.getMarkersOfType(null);
        MarkableRidgetTest.assertNotNull((Object)markers);
        MarkableRidgetTest.assertEquals((int)0, (int)markers.size());
        markers = ridget.getMarkersOfType(ErrorMarker.class);
        MarkableRidgetTest.assertEquals((int)0, (int)markers.size());
        markers = ridget.getMarkersOfType(MandatoryMarker.class);
        MarkableRidgetTest.assertEquals((int)0, (int)markers.size());
        ridget.addMarker((IMarker)errorMarker);
        ridget.addMarker((IMarker)mandatoryMarker);
        markers = ridget.getMarkersOfType(ErrorMarker.class);
        Iterator iterator = markers.iterator();
        MarkableRidgetTest.assertTrue((boolean)iterator.hasNext());
        MarkableRidgetTest.assertSame((Object)errorMarker, iterator.next());
        MarkableRidgetTest.assertFalse((boolean)iterator.hasNext());
        markers = ridget.getMarkersOfType(MandatoryMarker.class);
        iterator = markers.iterator();
        MarkableRidgetTest.assertTrue((boolean)iterator.hasNext());
        MarkableRidgetTest.assertSame((Object)mandatoryMarker, iterator.next());
        MarkableRidgetTest.assertFalse((boolean)iterator.hasNext());
        markers = ridget.getMarkersOfType(null);
        MarkableRidgetTest.assertNotNull((Object)markers);
        MarkableRidgetTest.assertEquals((int)0, (int)markers.size());
    }

    public void testFireMarkerAttributeEvents() throws Exception {
        IMarkableRidget ridget = this.getRidget();
        ErrorMessageMarker errorMessageMarker = new ErrorMessageMarker("Message");
        ridget.addMarker((IMarker)errorMessageMarker);
        this.expectPropertyChangeEvents(new ExpectedMarkerPropertyChangeEvent(null, (Object)ridget.getMarkers(), true));
        errorMessageMarker.setAttribute("message", (Object)"NewMessage");
        this.verifyPropertyChangeEvents();
        HashSet newValue = new HashSet(ridget.getMarkers());
        newValue.remove(errorMessageMarker);
        this.expectPropertyChangeEvents(new ExpectedMarkerPropertyChangeEvent(ridget.getMarkers(), newValue, false));
        ridget.removeMarker((IMarker)errorMessageMarker);
        this.verifyPropertyChangeEvents();
        this.expectNoPropertyChangeEvent();
        errorMessageMarker.setAttribute("message", (Object)"YetAnotherMessage");
        this.verifyPropertyChangeEvents();
    }

    private class ExpectedMarkerPropertyChangeEvent
    extends PropertyChangeEvent
    implements IMarkerPropertyChangeEvent {
        private static final long serialVersionUID = 4711L;
        private boolean attributeRelated;

        public ExpectedMarkerPropertyChangeEvent(Object oldValue, Object newValue, boolean attributeRelated) {
            super(MarkableRidgetTest.this.getRidget(), "marker", oldValue, newValue);
            this.attributeRelated = attributeRelated;
        }

        public boolean isAttributeRelated() {
            return this.attributeRelated;
        }
    }
}

