/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.ui.ridgets.swt;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.riena.beans.common.AbstractBean;
import org.eclipse.riena.core.RienaStatus;
import org.eclipse.riena.core.marker.IMarker;
import org.eclipse.riena.internal.ui.ridgets.swt.AbstractSWTRidgetTest;
import org.eclipse.riena.internal.ui.ridgets.swt.MasterDetailsRidget;
import org.eclipse.riena.internal.ui.swt.test.UITestHelper;
import org.eclipse.riena.ui.core.marker.MandatoryMarker;
import org.eclipse.riena.ui.core.marker.ValidationTime;
import org.eclipse.riena.ui.ridgets.AbstractMasterDetailsDelegate;
import org.eclipse.riena.ui.ridgets.IMasterDetailsDelegate;
import org.eclipse.riena.ui.ridgets.IMasterDetailsRidget;
import org.eclipse.riena.ui.ridgets.IRidget;
import org.eclipse.riena.ui.ridgets.IRidgetContainer;
import org.eclipse.riena.ui.ridgets.ITextRidget;
import org.eclipse.riena.ui.ridgets.swt.uibinding.SwtControlRidgetMapper;
import org.eclipse.riena.ui.ridgets.uibinding.DefaultBindingManager;
import org.eclipse.riena.ui.ridgets.uibinding.IBindingManager;
import org.eclipse.riena.ui.ridgets.uibinding.IBindingPropertyLocator;
import org.eclipse.riena.ui.ridgets.uibinding.IControlRidgetMapper;
import org.eclipse.riena.ui.ridgets.validation.MinLength;
import org.eclipse.riena.ui.swt.MasterDetailsComposite;
import org.eclipse.riena.ui.swt.utils.SWTBindingPropertyLocator;
import org.eclipse.riena.ui.swt.utils.UIControlsFactory;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MasterDetailsRidgetTest
extends AbstractSWTRidgetTest {
    private static final IBindingManager BINDING_MAN = new DefaultBindingManager((IBindingPropertyLocator)SWTBindingPropertyLocator.getInstance(), (IControlRidgetMapper)SwtControlRidgetMapper.getInstance());
    private final String[] columnProperties = new String[]{"column1", "column2"};
    private final String[] columnHeaders = new String[]{"TestColumn1Header", "TestColumn2Header"};
    private List<MDBean> input;
    private MDDelegate delegate;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.input = this.createInput(3);
        MasterDetailsRidget ridget = this.getRidget();
        List uiControls = this.getWidget().getUIControls();
        BINDING_MAN.injectRidgets((IRidgetContainer)ridget, uiControls);
        BINDING_MAN.bind((IRidgetContainer)ridget, uiControls);
        this.delegate = new MDDelegate();
        ridget.setDelegate((IMasterDetailsDelegate)this.delegate);
        this.getShell().setSize(300, 300);
    }

    @Override
    protected void tearDown() throws Exception {
        this.delegate = null;
        this.input = null;
        super.tearDown();
    }

    @Override
    protected Widget createWidget(Composite parent) {
        return new MDWidget(parent, 0);
    }

    @Override
    protected IRidget createRidget() {
        return new MasterDetailsRidget();
    }

    protected MDWidget getWidget() {
        return (MDWidget)super.getWidget();
    }

    protected MasterDetailsRidget getRidget() {
        return (MasterDetailsRidget)super.getRidget();
    }

    public void testRidgetMapping() {
        SwtControlRidgetMapper mapper = SwtControlRidgetMapper.getInstance();
        MasterDetailsRidgetTest.assertSame(MasterDetailsRidget.class, (Object)mapper.getRidgetClass((Object)this.getWidget()));
    }

    public void testBindToModel() {
        MasterDetailsRidget ridget = this.getRidget();
        MDWidget composite = this.getWidget();
        Table table = composite.getTable();
        MasterDetailsRidgetTest.assertEquals((int)0, (int)table.getItemCount());
        this.bindToModel(false);
        MasterDetailsRidgetTest.assertEquals((int)0, (int)table.getItemCount());
        ridget.updateFromModel();
        MasterDetailsRidgetTest.assertEquals((int)2, (int)table.getColumnCount());
        MasterDetailsRidgetTest.assertEquals((int)3, (int)table.getItemCount());
        MasterDetailsRidgetTest.assertEquals((String)"TestColumn1Header", (String)table.getColumn(0).getText());
        MasterDetailsRidgetTest.assertEquals((String)"TestColumn2Header", (String)table.getColumn(1).getText());
        this.assertContent(table, 3);
    }

    public void testSetUIControl() {
        MasterDetailsRidget ridget = this.getRidget();
        Table table = this.getWidget().getTable();
        MasterDetailsComposite mdComposite2 = (MasterDetailsComposite)this.createWidget((Composite)this.getShell());
        Table table2 = mdComposite2.getTable();
        MasterDetailsRidgetTest.assertEquals((int)0, (int)table.getItemCount());
        this.bindToModel(true);
        MasterDetailsRidgetTest.assertEquals((int)3, (int)table.getItemCount());
        this.bindUIControl((IMasterDetailsRidget)ridget, mdComposite2);
        this.input.remove(0);
        ridget.updateFromModel();
        MasterDetailsRidgetTest.assertEquals((int)3, (int)table.getItemCount());
        MasterDetailsRidgetTest.assertEquals((int)2, (int)table2.getItemCount());
        this.unbindUIControl((IMasterDetailsRidget)ridget, mdComposite2);
        this.input.remove(0);
        ridget.updateFromModel();
        MasterDetailsRidgetTest.assertEquals((int)3, (int)table.getItemCount());
        MasterDetailsRidgetTest.assertEquals((int)2, (int)table2.getItemCount());
        try {
            ridget.setUIControl((Object)new Table((Composite)this.getShell(), 2));
            MasterDetailsRidgetTest.fail();
        }
        catch (RuntimeException runtimeException) {
            this.ok("does not allow SWT.MULTI");
        }
    }

    public void testAddBean() {
        MasterDetailsRidget ridget = this.getRidget();
        MDWidget widget = this.getWidget();
        ITextRidget txtColumn1 = (ITextRidget)ridget.getRidget(ITextRidget.class, "txtColumn1");
        ITextRidget txtColumn2 = (ITextRidget)ridget.getRidget(ITextRidget.class, "txtColumn2");
        ridget.setApplyTriggersNew(false);
        this.bindToModel(true);
        int oldSize = this.input.size();
        ridget.setSelection((Object)this.input.get(0));
        MasterDetailsRidgetTest.assertEquals((String)"TestR0C1", (String)widget.txtColumn1.getText());
        MasterDetailsRidgetTest.assertEquals((String)"TestR0C2", (String)widget.txtColumn2.getText());
        ridget.handleAdd();
        MasterDetailsRidgetTest.assertTrue((boolean)txtColumn1.isEnabled());
        MasterDetailsRidgetTest.assertTrue((boolean)txtColumn2.isEnabled());
        MasterDetailsRidgetTest.assertTrue((boolean)widget.txtColumn1.isFocusControl());
        MasterDetailsRidgetTest.assertEquals((int)oldSize, (int)this.input.size());
        MasterDetailsRidgetTest.assertEquals((String)"", (String)widget.txtColumn1.getText());
        MasterDetailsRidgetTest.assertEquals((String)"", (String)widget.txtColumn2.getText());
        widget.txtColumn1.setFocus();
        UITestHelper.sendString((Display)widget.getDisplay(), (String)"A\r");
        widget.txtColumn2.setFocus();
        UITestHelper.sendString((Display)widget.getDisplay(), (String)"B\r");
        ridget.handleApply();
        MDBean newEntry = this.input.get(oldSize);
        MasterDetailsRidgetTest.assertEquals((int)(oldSize + 1), (int)this.input.size());
        MasterDetailsRidgetTest.assertEquals((String)"A", (String)newEntry.column1);
        MasterDetailsRidgetTest.assertEquals((String)"B", (String)newEntry.column2);
        MasterDetailsRidgetTest.assertEquals((Object)((Object)newEntry), (Object)ridget.getSelection());
        MasterDetailsRidgetTest.assertFalse((boolean)txtColumn1.isEnabled());
        MasterDetailsRidgetTest.assertFalse((boolean)txtColumn2.isEnabled());
        MasterDetailsRidgetTest.assertEquals((String)"", (String)widget.txtColumn1.getText());
        MasterDetailsRidgetTest.assertEquals((String)"", (String)widget.txtColumn2.getText());
    }

    public void testAddBeanAndApplyTriggersNew() {
        MasterDetailsRidget ridget = this.getRidget();
        MDWidget widget = this.getWidget();
        ITextRidget txtColumn1 = (ITextRidget)ridget.getRidget(ITextRidget.class, "txtColumn1");
        ITextRidget txtColumn2 = (ITextRidget)ridget.getRidget(ITextRidget.class, "txtColumn2");
        ridget.setApplyTriggersNew(true);
        this.bindToModel(true);
        int oldSize = this.input.size();
        ridget.setSelection((Object)this.input.get(0));
        MasterDetailsRidgetTest.assertEquals((String)"TestR0C1", (String)widget.txtColumn1.getText());
        MasterDetailsRidgetTest.assertEquals((String)"TestR0C2", (String)widget.txtColumn2.getText());
        ridget.handleAdd();
        MasterDetailsRidgetTest.assertTrue((boolean)txtColumn1.isEnabled());
        MasterDetailsRidgetTest.assertTrue((boolean)txtColumn2.isEnabled());
        MasterDetailsRidgetTest.assertTrue((boolean)widget.txtColumn1.isFocusControl());
        MasterDetailsRidgetTest.assertEquals((int)oldSize, (int)this.input.size());
        MasterDetailsRidgetTest.assertEquals((String)"", (String)widget.txtColumn1.getText());
        MasterDetailsRidgetTest.assertEquals((String)"", (String)widget.txtColumn2.getText());
        widget.txtColumn1.setFocus();
        UITestHelper.sendString((Display)widget.getDisplay(), (String)"A\r");
        widget.txtColumn2.setFocus();
        UITestHelper.sendString((Display)widget.getDisplay(), (String)"B\r");
        ridget.handleApply();
        MDBean newEntry = this.input.get(oldSize);
        MasterDetailsRidgetTest.assertEquals((int)(oldSize + 1), (int)this.input.size());
        MasterDetailsRidgetTest.assertEquals((String)"A", (String)newEntry.column1);
        MasterDetailsRidgetTest.assertEquals((String)"B", (String)newEntry.column2);
        MasterDetailsRidgetTest.assertNull((Object)ridget.getSelection());
        MasterDetailsRidgetTest.assertTrue((boolean)txtColumn1.isEnabled());
        MasterDetailsRidgetTest.assertTrue((boolean)txtColumn2.isEnabled());
        MasterDetailsRidgetTest.assertEquals((String)"", (String)widget.txtColumn1.getText());
        MasterDetailsRidgetTest.assertEquals((String)"", (String)widget.txtColumn2.getText());
    }

    public void testDeleteBean() {
        MasterDetailsRidget ridget = this.getRidget();
        MDWidget widget = this.getWidget();
        Table table = widget.getTable();
        ITextRidget txtColumn1 = (ITextRidget)ridget.getRidget(ITextRidget.class, "txtColumn1");
        ITextRidget txtColumn2 = (ITextRidget)ridget.getRidget(ITextRidget.class, "txtColumn2");
        this.bindToModel(true);
        MasterDetailsRidgetTest.assertEquals((int)3, (int)this.input.size());
        this.assertContent(table, 3);
        MDBean toDelete = this.input.get(2);
        ridget.setSelection((Object)toDelete);
        MasterDetailsRidgetTest.assertTrue((boolean)txtColumn1.isEnabled());
        MasterDetailsRidgetTest.assertTrue((boolean)txtColumn2.isEnabled());
        ridget.handleRemove();
        MasterDetailsRidgetTest.assertEquals((int)2, (int)this.input.size());
        this.assertContent(table, 2);
        MasterDetailsRidgetTest.assertFalse((boolean)this.input.contains((Object)toDelete));
        MasterDetailsRidgetTest.assertFalse((boolean)txtColumn1.isEnabled());
        MasterDetailsRidgetTest.assertFalse((boolean)txtColumn2.isEnabled());
    }

    public void testModifyBean() {
        MasterDetailsRidget ridget = this.getRidget();
        MDWidget widget = this.getWidget();
        Table table = widget.getTable();
        this.bindToModel(true);
        this.assertContent(table, 3);
        MasterDetailsRidgetTest.assertEquals((int)3, (int)this.input.size());
        ridget.setSelection((Object)this.input.get(1));
        widget.txtColumn1.setFocus();
        UITestHelper.sendString((Display)widget.getDisplay(), (String)"A\r");
        widget.txtColumn2.setFocus();
        UITestHelper.sendString((Display)widget.getDisplay(), (String)"B\r");
        ridget.handleApply();
        MasterDetailsRidgetTest.assertEquals((int)3, (int)this.input.size());
        MasterDetailsRidgetTest.assertEquals((String)"A", (String)this.input.get(1).getColumn1());
        MasterDetailsRidgetTest.assertEquals((String)"B", (String)this.input.get(1).getColumn2());
    }

    public void testSetSelection() {
        MasterDetailsRidget ridget = this.getRidget();
        this.bindToModel(true);
        MasterDetailsRidgetTest.assertEquals(null, (Object)ridget.getSelection());
        ridget.setSelection((Object)this.input.get(0));
        MasterDetailsRidgetTest.assertEquals((Object)((Object)this.input.get(0)), (Object)ridget.getSelection());
        ridget.setSelection(null);
        MasterDetailsRidgetTest.assertEquals(null, (Object)ridget.getSelection());
    }

    public void testSetSelectionUpdatesUI() {
        MasterDetailsRidget ridget = this.getRidget();
        MDWidget widget = this.getWidget();
        this.bindToModel(true);
        ridget.setSelection((Object)this.input.get(1));
        MasterDetailsRidgetTest.assertEquals((int)1, (int)widget.getTable().getSelectionCount());
        MasterDetailsRidgetTest.assertEquals((String)"TestR1C1", (String)widget.txtColumn1.getText());
        MasterDetailsRidgetTest.assertEquals((String)"TestR1C2", (String)widget.txtColumn2.getText());
        ridget.setSelection(null);
        MasterDetailsRidgetTest.assertEquals((int)0, (int)widget.getTable().getSelectionCount());
        MasterDetailsRidgetTest.assertEquals((String)"", (String)widget.txtColumn1.getText());
        MasterDetailsRidgetTest.assertEquals((String)"", (String)widget.txtColumn2.getText());
    }

    public void testSetSelectionRevealsSelection() {
        MasterDetailsRidget ridget = this.getRidget();
        MDWidget widget = this.getWidget();
        this.input = this.createInput(42);
        this.bindToModel(true);
        MasterDetailsRidgetTest.assertEquals((int)0, (int)widget.getTable().getTopIndex());
        ridget.setSelection((Object)this.input.get(30));
        MasterDetailsRidgetTest.assertTrue((widget.getTable().getTopIndex() > 0 ? 1 : 0) != 0);
    }

    public void testUpdateFromModelPreservesSelection() {
        MasterDetailsRidget ridget = this.getRidget();
        this.bindToModel(true);
        MDBean item2 = this.input.get(2);
        ridget.setSelection((Object)item2);
        MasterDetailsRidgetTest.assertSame((Object)((Object)item2), (Object)ridget.getSelection());
        this.input.remove((Object)this.input.get(1));
        MasterDetailsRidgetTest.assertSame((Object)((Object)item2), (Object)ridget.getSelection());
        ridget.updateFromModel();
        MasterDetailsRidgetTest.assertSame((Object)((Object)item2), (Object)ridget.getSelection());
    }

    public void testUpdateFromModelRemovesSelection() {
        MasterDetailsRidget ridget = this.getRidget();
        this.bindToModel(true);
        MDBean item2 = this.input.get(2);
        ridget.setSelection((Object)item2);
        MasterDetailsRidgetTest.assertSame((Object)((Object)item2), (Object)ridget.getSelection());
        this.input.remove((Object)this.input.get(2));
        MasterDetailsRidgetTest.assertSame((Object)((Object)item2), (Object)ridget.getSelection());
        ridget.updateFromModel();
        MasterDetailsRidgetTest.assertNull((Object)ridget.getSelection());
    }

    public void testUpdateSelectionFromRidgetOnRebind() {
        MasterDetailsRidget ridget = this.getRidget();
        MDWidget widget = this.getWidget();
        this.unbindUIControl((IMasterDetailsRidget)ridget, widget);
        this.bindToModel(true);
        ridget.setSelection((Object)this.input.get(0));
        MasterDetailsRidgetTest.assertEquals((int)0, (int)widget.getTable().getSelectionCount());
        MasterDetailsRidgetTest.assertEquals((String)"", (String)widget.txtColumn1.getText());
        MasterDetailsRidgetTest.assertEquals((String)"", (String)widget.txtColumn2.getText());
        MDWidget widget2 = (MDWidget)this.createWidget((Composite)this.getShell());
        this.bindUIControl((IMasterDetailsRidget)ridget, widget2);
        MasterDetailsRidgetTest.assertEquals((int)1, (int)widget2.getTable().getSelectionCount());
        MasterDetailsRidgetTest.assertEquals((String)"TestR0C1", (String)widget2.txtColumn1.getText());
        MasterDetailsRidgetTest.assertEquals((String)"TestR0C2", (String)widget2.txtColumn2.getText());
    }

    public void testSetSelectionFiresEvents() {
        MasterDetailsRidget ridget = this.getRidget();
        MDBean item0 = this.input.get(0);
        FTPropertyChangeListener listener = new FTPropertyChangeListener();
        this.bindToModel(true);
        ridget.addPropertyChangeListener("selection", (PropertyChangeListener)listener);
        ridget.setSelection((Object)item0);
        List oldSelection = Collections.EMPTY_LIST;
        List newSelection = Arrays.asList(new Object[]{item0});
        this.assertPropertyChangeEvent(1, oldSelection, newSelection, listener);
        ridget.setSelection((Object)item0);
        MasterDetailsRidgetTest.assertEquals((int)1, (int)listener.count);
        MDBean item1 = this.input.get(1);
        ridget.setSelection((Object)item1);
        oldSelection = newSelection;
        newSelection = Arrays.asList(new Object[]{item1});
        this.assertPropertyChangeEvent(2, oldSelection, newSelection, listener);
        ridget.setSelection(null);
        oldSelection = newSelection;
        newSelection = Collections.EMPTY_LIST;
        this.assertPropertyChangeEvent(3, oldSelection, newSelection, listener);
    }

    public void testHandleSelectionChange() {
        MasterDetailsRidget ridget = this.getRidget();
        this.bindToModel(true);
        ITextRidget txtColumn1 = (ITextRidget)ridget.getRidget(ITextRidget.class, "txtColumn1");
        ITextRidget txtColumn2 = (ITextRidget)ridget.getRidget(ITextRidget.class, "txtColumn2");
        MDBean item0 = this.input.get(0);
        ridget.setSelection((Object)item0);
        MasterDetailsRidgetTest.assertTrue((boolean)txtColumn1.isEnabled());
        MasterDetailsRidgetTest.assertTrue((boolean)txtColumn2.isEnabled());
        ridget.setSelection(null);
        MasterDetailsRidgetTest.assertFalse((boolean)txtColumn1.isEnabled());
        MasterDetailsRidgetTest.assertFalse((boolean)txtColumn2.isEnabled());
        this.delegate.isTxtColumn1IsEnabled = false;
        ridget.setSelection((Object)item0);
        MasterDetailsRidgetTest.assertFalse((boolean)txtColumn1.isEnabled());
        MasterDetailsRidgetTest.assertTrue((boolean)txtColumn2.isEnabled());
        ridget.setSelection(null);
        MasterDetailsRidgetTest.assertFalse((boolean)txtColumn1.isEnabled());
        MasterDetailsRidgetTest.assertFalse((boolean)txtColumn2.isEnabled());
    }

    public void testDeselectOnApplyWithOneItem() {
        MasterDetailsRidget ridget = this.getRidget();
        this.input = this.createInput(1);
        this.bindToModel(true);
        MDBean item0 = this.input.get(0);
        ridget.setSelection((Object)item0);
        MasterDetailsRidgetTest.assertEquals((Object)((Object)item0), (Object)ridget.getSelection());
        ridget.handleApply();
        MasterDetailsRidgetTest.assertEquals(null, (Object)ridget.getSelection());
    }

    public void testDirectWritingHidesApply() {
        MasterDetailsRidget ridget = this.getRidget();
        MDWidget control = this.getWidget();
        MasterDetailsRidgetTest.assertFalse((boolean)ridget.isDirectWriting());
        MasterDetailsRidgetTest.assertTrue((boolean)control.getButtonApply().isVisible());
        ridget.setDirectWriting(true);
        MasterDetailsRidgetTest.assertTrue((boolean)ridget.isDirectWriting());
        MasterDetailsRidgetTest.assertFalse((boolean)control.getButtonApply().isVisible());
        ridget.setDirectWriting(false);
        MasterDetailsRidgetTest.assertFalse((boolean)ridget.isDirectWriting());
        MasterDetailsRidgetTest.assertTrue((boolean)control.getButtonApply().isVisible());
    }

    public void testDirectWritingUpdatesTableWithoutApply() {
        MasterDetailsRidget ridget = this.getRidget();
        MDWidget widget = this.getWidget();
        this.bindToModel(true);
        ridget.setDirectWriting(true);
        MDBean row0 = this.input.get(0);
        ridget.setSelection((Object)row0);
        MasterDetailsRidgetTest.assertEquals((String)"TestR0C1", (String)row0.column1);
        MasterDetailsRidgetTest.assertEquals((String)"TestR0C2", (String)row0.column2);
        MasterDetailsRidgetTest.assertEquals((String)"TestR0C1", (String)widget.txtColumn1.getText());
        MasterDetailsRidgetTest.assertEquals((String)"TestR0C2", (String)widget.txtColumn2.getText());
        widget.txtColumn1.setFocus();
        UITestHelper.sendString((Display)widget.getDisplay(), (String)"A\r");
        widget.txtColumn2.setFocus();
        UITestHelper.sendString((Display)widget.getDisplay(), (String)"B\r");
        MasterDetailsRidgetTest.assertEquals((String)"A", (String)row0.column1);
        MasterDetailsRidgetTest.assertEquals((String)"B", (String)row0.column2);
    }

    public void testDirectWritingAddsToTableWithoutApply() {
        MasterDetailsRidget ridget = this.getRidget();
        MDWidget widget = this.getWidget();
        Table table = widget.getTable();
        this.bindToModel(true);
        ridget.setDirectWriting(true);
        MasterDetailsRidgetTest.assertEquals((int)3, (int)this.input.size());
        MasterDetailsRidgetTest.assertEquals((int)3, (int)table.getItemCount());
        ridget.handleAdd();
        MasterDetailsRidgetTest.assertEquals((int)4, (int)this.input.size());
        MasterDetailsRidgetTest.assertEquals((int)4, (int)table.getItemCount());
        MDBean row4 = (MDBean)((Object)ridget.getSelection());
        MasterDetailsRidgetTest.assertEquals((String)"", (String)row4.column1);
        MasterDetailsRidgetTest.assertEquals((String)"", (String)row4.column2);
    }

    public void testDirectWritingWithRequiresNoErrors() {
        MasterDetailsRidget ridget = this.getRidget();
        ridget.setApplyRequiresNoErrors(true);
        ridget.setDirectWriting(true);
        this.delegate.txtColumn1.addValidationRule((IValidator)new MinLength(3), ValidationTime.ON_UI_CONTROL_EDIT);
        this.bindToModel(true);
        ridget.handleAdd();
        MDBean bean = (MDBean)((Object)ridget.getSelection());
        MasterDetailsRidgetTest.assertEquals((String)"", (String)bean.column1);
        MasterDetailsRidgetTest.assertEquals((String)"", (String)bean.column2);
        this.delegate.txtColumn2.setText("beta");
        MasterDetailsRidgetTest.assertEquals((String)"", (String)bean.column1);
        MasterDetailsRidgetTest.assertEquals((String)"", (String)bean.column2);
        this.delegate.txtColumn1.setText("alpha");
        MasterDetailsRidgetTest.assertEquals((String)"alpha", (String)bean.column1);
        MasterDetailsRidgetTest.assertEquals((String)"beta", (String)bean.column2);
    }

    public void testDirectWritingWithRequiresNoMandatories() {
        MasterDetailsRidget ridget = this.getRidget();
        ridget.setApplyRequiresNoMandatories(true);
        ridget.setDirectWriting(true);
        this.delegate.txtColumn1.setMandatory(true);
        this.delegate.txtColumn2.setMandatory(true);
        this.bindToModel(true);
        ridget.handleAdd();
        MDBean bean = (MDBean)((Object)ridget.getSelection());
        MasterDetailsRidgetTest.assertEquals((String)"", (String)bean.column1);
        MasterDetailsRidgetTest.assertEquals((String)"", (String)bean.column2);
        this.delegate.txtColumn1.setText("alpha");
        MasterDetailsRidgetTest.assertEquals((String)"", (String)bean.column1);
        MasterDetailsRidgetTest.assertEquals((String)"", (String)bean.column2);
        this.delegate.txtColumn2.setText("beta");
        MasterDetailsRidgetTest.assertEquals((String)"alpha", (String)bean.column1);
        MasterDetailsRidgetTest.assertEquals((String)"beta", (String)bean.column2);
    }

    public void testDirectWritingValidationCheck() {
        MasterDetailsRidget ridget = this.getRidget();
        ridget.setApplyRequiresNoMandatories(true);
        ridget.setDirectWriting(true);
        this.bindToModel(true);
        this.delegate.validationResult = "error";
        ridget.handleAdd();
        MDBean bean = (MDBean)((Object)ridget.getSelection());
        MasterDetailsRidgetTest.assertEquals((String)"", (String)bean.column1);
        MasterDetailsRidgetTest.assertEquals((String)"", (String)bean.column2);
        this.delegate.txtColumn1.setText("alpha");
        MasterDetailsRidgetTest.assertEquals((String)"", (String)bean.column1);
        MasterDetailsRidgetTest.assertEquals((String)"", (String)bean.column2);
        this.delegate.validationResult = null;
        this.delegate.txtColumn2.setText("beta");
        MasterDetailsRidgetTest.assertEquals((String)"alpha", (String)bean.column1);
        MasterDetailsRidgetTest.assertEquals((String)"beta", (String)bean.column2);
    }

    public void testOneColumnFullWidget() {
        MDWidget widget = this.getWidget();
        Table table = widget.getTable();
        MasterDetailsRidgetTest.assertEquals((int)0, (int)table.getColumnCount());
        WritableList list = new WritableList(this.input, MDBean.class);
        String[] colProps = new String[]{"column1"};
        String[] colHeaders = new String[]{"The Header"};
        this.getRidget().bindToModel((IObservableList)list, MDBean.class, colProps, colHeaders);
        MasterDetailsRidgetTest.assertEquals((int)1, (int)table.getColumnCount());
        MasterDetailsRidgetTest.assertEquals((String)"The Header", (String)table.getColumn(0).getText());
        MasterDetailsRidgetTest.assertEquals((int)table.getClientArea().width, (int)table.getColumn(0).getWidth());
    }

    public void testAutoCreateTableColumns() {
        MasterDetailsRidget ridget = this.getRidget();
        Table table = this.getWidget().getTable();
        MasterDetailsRidgetTest.assertEquals((int)0, (int)table.getColumnCount());
        WritableList list = new WritableList(this.input, MDBean.class);
        String[] columnProperties3 = new String[]{"column1", "column2", "column1"};
        ridget.bindToModel((IObservableList)list, MDBean.class, columnProperties3, null);
        MasterDetailsRidgetTest.assertEquals((int)3, (int)table.getColumnCount());
        MasterDetailsRidgetTest.assertTrue((boolean)(table.getParent().getLayout() instanceof TableColumnLayout));
        String[] columnProperties1 = new String[]{"column2"};
        ridget.bindToModel((IObservableList)list, MDBean.class, columnProperties1, null);
        MasterDetailsRidgetTest.assertEquals((int)1, (int)table.getColumnCount());
        MasterDetailsRidgetTest.assertTrue((boolean)(table.getParent().getLayout() instanceof TableColumnLayout));
    }

    public void testDelegateItemCreated() {
        MasterDetailsRidget ridget = this.getRidget();
        this.bindToModel(true);
        MasterDetailsRidgetTest.assertEquals((int)0, (int)this.delegate.createCount);
        ridget.handleAdd();
        MasterDetailsRidgetTest.assertEquals((int)1, (int)this.delegate.createCount);
        MDBean lastItem = (MDBean)((Object)this.delegate.lastItem);
        MasterDetailsRidgetTest.assertEquals((String)this.delegate.getWorkingCopy().column1, (String)lastItem.column1);
        MasterDetailsRidgetTest.assertEquals((String)this.delegate.getWorkingCopy().column2, (String)lastItem.column2);
    }

    public void testDelegateItemRemoved() {
        MasterDetailsRidget ridget = this.getRidget();
        this.bindToModel(true);
        MasterDetailsRidgetTest.assertEquals((int)0, (int)this.delegate.removeCount);
        MDBean first = this.input.get(0);
        ridget.setSelection((Object)first);
        ridget.handleRemove();
        MasterDetailsRidgetTest.assertEquals((int)1, (int)this.delegate.removeCount);
        MasterDetailsRidgetTest.assertEquals((Object)((Object)first), (Object)this.delegate.lastItem);
    }

    public void testDelegateItemApplied() {
        MasterDetailsRidget ridget = this.getRidget();
        MDWidget widget = this.getWidget();
        this.bindToModel(true);
        MasterDetailsRidgetTest.assertEquals((int)0, (int)this.delegate.applyCount);
        MasterDetailsRidgetTest.assertEquals((int)0, (int)this.delegate.prepareCount);
        MasterDetailsRidgetTest.assertEquals((int)0, (int)this.delegate.selectionCount);
        MDBean first = this.input.get(0);
        ridget.setSelection((Object)first);
        MasterDetailsRidgetTest.assertEquals((int)0, (int)this.delegate.applyCount);
        MasterDetailsRidgetTest.assertEquals((int)1, (int)this.delegate.prepareCount);
        MasterDetailsRidgetTest.assertEquals((int)1, (int)this.delegate.selectionCount);
        widget.txtColumn1.setFocus();
        UITestHelper.sendString((Display)widget.getDisplay(), (String)"A\r");
        ridget.handleApply();
        MasterDetailsRidgetTest.assertEquals((int)1, (int)this.delegate.applyCount);
        MasterDetailsRidgetTest.assertEquals((int)1, (int)this.delegate.prepareCount);
        MasterDetailsRidgetTest.assertEquals((int)1, (int)this.delegate.selectionCount);
    }

    public void testDelegateItemSelected() {
        this.bindToModel(true);
        MasterDetailsRidgetTest.assertEquals((int)0, (int)this.delegate.prepareCount);
        MasterDetailsRidgetTest.assertEquals((int)0, (int)this.delegate.selectionCount);
        MasterDetailsRidgetTest.assertNull((Object)this.delegate.lastItem);
        MDBean first = this.input.get(0);
        this.getRidget().setSelection((Object)first);
        MasterDetailsRidgetTest.assertEquals((int)1, (int)this.delegate.prepareCount);
        MasterDetailsRidgetTest.assertEquals((int)1, (int)this.delegate.selectionCount);
        MasterDetailsRidgetTest.assertEquals((Object)((Object)first), (Object)this.delegate.lastItem);
    }

    public void testReselectingSelectedRowIsIgnored() {
        this.bindToModel(true);
        MDWidget widget = this.getWidget();
        MDBean first = this.input.get(0);
        MasterDetailsRidgetTest.assertEquals((int)0, (int)this.delegate.prepareCount);
        MasterDetailsRidgetTest.assertEquals((int)0, (int)this.delegate.selectionCount);
        MasterDetailsRidgetTest.assertNull((Object)this.delegate.lastItem);
        Table table = widget.getTable();
        table.setSelection(0);
        Event event1 = this.createSelectionEvent(widget, (Object)first);
        table.notifyListeners(13, event1);
        Event event2 = this.createSelectionEvent(widget, (Object)first);
        table.notifyListeners(13, event2);
        MasterDetailsRidgetTest.assertEquals((int)1, (int)this.delegate.prepareCount);
        MasterDetailsRidgetTest.assertEquals((int)1, (int)this.delegate.selectionCount);
        MasterDetailsRidgetTest.assertEquals((Object)((Object)first), (Object)this.delegate.lastItem);
    }

    public void testSuggestNewEntry() {
        this.bindToModel(true);
        MasterDetailsRidget ridget = this.getRidget();
        MDWidget widget = this.getWidget();
        MasterDetailsRidgetTest.assertEquals((String)"", (String)widget.txtColumn1.getText());
        MasterDetailsRidgetTest.assertEquals((String)"", (String)widget.txtColumn2.getText());
        MasterDetailsRidgetTest.assertEquals((boolean)false, (boolean)widget.getButtonApply().isEnabled());
        MDBean newEntry = new MDBean("col1", "col2");
        ridget.suggestNewEntry((Object)newEntry);
        MasterDetailsRidgetTest.assertEquals((String)"col1", (String)widget.txtColumn1.getText());
        MasterDetailsRidgetTest.assertEquals((String)"col2", (String)widget.txtColumn2.getText());
        MasterDetailsRidgetTest.assertTrue((boolean)widget.getButtonApply().isEnabled());
        MasterDetailsRidgetTest.assertFalse((boolean)this.input.contains((Object)newEntry));
    }

    public void testUpdateApplyButton() {
        this.bindToModel(true);
        MasterDetailsRidget ridget = this.getRidget();
        MDWidget widget = this.getWidget();
        MDBean first = this.input.get(0);
        ridget.setSelection((Object)first);
        MasterDetailsRidgetTest.assertFalse((boolean)widget.getButtonApply().isEnabled());
        first.column1 = "col1";
        ridget.updateApplyButton();
        MasterDetailsRidgetTest.assertTrue((boolean)widget.getButtonApply().isEnabled());
    }

    public void testUpdateEnabled() {
        this.bindToModel(true);
        MasterDetailsRidget ridget = this.getRidget();
        MDWidget widget = this.getWidget();
        MDBean first = this.input.get(0);
        ridget.setSelection((Object)first);
        MasterDetailsRidgetTest.assertTrue((boolean)widget.getButtonNew().isEnabled());
        MasterDetailsRidgetTest.assertTrue((boolean)widget.getButtonRemove().isEnabled());
        MasterDetailsRidgetTest.assertFalse((boolean)widget.getButtonApply().isEnabled());
        MasterDetailsRidgetTest.assertNotNull((Object)ridget.getSelection());
        MasterDetailsRidgetTest.assertTrue((boolean)this.delegate.txtColumn1.isEnabled());
        MasterDetailsRidgetTest.assertTrue((boolean)this.delegate.txtColumn2.isEnabled());
        ridget.setEnabled(false);
        MasterDetailsRidgetTest.assertFalse((boolean)widget.getButtonNew().isEnabled());
        MasterDetailsRidgetTest.assertFalse((boolean)widget.getButtonRemove().isEnabled());
        MasterDetailsRidgetTest.assertFalse((boolean)widget.getButtonApply().isEnabled());
        MasterDetailsRidgetTest.assertNull((Object)ridget.getSelection());
        MasterDetailsRidgetTest.assertFalse((boolean)this.delegate.txtColumn1.isEnabled());
        MasterDetailsRidgetTest.assertFalse((boolean)this.delegate.txtColumn2.isEnabled());
        ridget.setEnabled(true);
        MasterDetailsRidgetTest.assertTrue((boolean)widget.getButtonNew().isEnabled());
        MasterDetailsRidgetTest.assertFalse((boolean)widget.getButtonRemove().isEnabled());
        MasterDetailsRidgetTest.assertFalse((boolean)widget.getButtonApply().isEnabled());
        MasterDetailsRidgetTest.assertNull((Object)ridget.getSelection());
        MasterDetailsRidgetTest.assertFalse((boolean)this.delegate.txtColumn1.isEnabled());
        MasterDetailsRidgetTest.assertFalse((boolean)this.delegate.txtColumn2.isEnabled());
    }

    public void testApplyRequiresNoErrors() {
        this.bindToModel(true);
        MasterDetailsRidget ridget = this.getRidget();
        MDBean first = this.input.get(0);
        ridget.setSelection((Object)first);
        Control applyButton = this.getWidget().getButtonApply();
        ITextRidget txtColumn1 = (ITextRidget)ridget.getRidget(ITextRidget.class, "txtColumn1");
        txtColumn1.addValidationRule((IValidator)new MinLength(5), ValidationTime.ON_UPDATE_TO_MODEL);
        txtColumn1.setText("abc");
        MasterDetailsRidgetTest.assertTrue((boolean)txtColumn1.isErrorMarked());
        MasterDetailsRidgetTest.assertFalse((boolean)ridget.isApplyRequiresNoErrors());
        MasterDetailsRidgetTest.assertTrue((boolean)applyButton.isEnabled());
        ridget.setApplyRequiresNoErrors(true);
        MasterDetailsRidgetTest.assertTrue((boolean)txtColumn1.isErrorMarked());
        MasterDetailsRidgetTest.assertTrue((boolean)ridget.isApplyRequiresNoErrors());
        MasterDetailsRidgetTest.assertFalse((boolean)applyButton.isEnabled());
        txtColumn1.setText("abcdef");
        MasterDetailsRidgetTest.assertFalse((boolean)txtColumn1.isErrorMarked());
        MasterDetailsRidgetTest.assertTrue((boolean)ridget.isApplyRequiresNoErrors());
        MasterDetailsRidgetTest.assertTrue((boolean)applyButton.isEnabled());
        txtColumn1.setText("abc");
        ridget.setApplyRequiresNoErrors(false);
        MasterDetailsRidgetTest.assertTrue((boolean)txtColumn1.isErrorMarked());
        MasterDetailsRidgetTest.assertFalse((boolean)ridget.isApplyRequiresNoErrors());
        MasterDetailsRidgetTest.assertTrue((boolean)applyButton.isEnabled());
    }

    public void testApplyRequiresNoMandatories() {
        this.bindToModel(true);
        MasterDetailsRidget ridget = this.getRidget();
        MDBean first = this.input.get(0);
        ridget.setSelection((Object)first);
        Control applyButton = this.getWidget().getButtonApply();
        ITextRidget txtColumn1 = (ITextRidget)ridget.getRidget(ITextRidget.class, "txtColumn1");
        MandatoryMarker marker = new MandatoryMarker();
        txtColumn1.addMarker((IMarker)marker);
        txtColumn1.setText("");
        MasterDetailsRidgetTest.assertTrue((boolean)txtColumn1.isMandatory());
        MasterDetailsRidgetTest.assertFalse((boolean)marker.isDisabled());
        MasterDetailsRidgetTest.assertFalse((boolean)ridget.isApplyRequiresNoMandatories());
        MasterDetailsRidgetTest.assertTrue((boolean)applyButton.isEnabled());
        ridget.setApplyRequiresNoMandatories(true);
        MasterDetailsRidgetTest.assertTrue((boolean)txtColumn1.isMandatory());
        MasterDetailsRidgetTest.assertFalse((boolean)marker.isDisabled());
        MasterDetailsRidgetTest.assertTrue((boolean)ridget.isApplyRequiresNoMandatories());
        MasterDetailsRidgetTest.assertFalse((boolean)applyButton.isEnabled());
        txtColumn1.setText("abc");
        MasterDetailsRidgetTest.assertTrue((boolean)txtColumn1.isMandatory());
        MasterDetailsRidgetTest.assertTrue((boolean)marker.isDisabled());
        MasterDetailsRidgetTest.assertTrue((boolean)ridget.isApplyRequiresNoMandatories());
        MasterDetailsRidgetTest.assertTrue((boolean)applyButton.isEnabled());
        txtColumn1.setText("");
        ridget.setApplyRequiresNoMandatories(false);
        MasterDetailsRidgetTest.assertTrue((boolean)txtColumn1.isMandatory());
        MasterDetailsRidgetTest.assertFalse((boolean)marker.isDisabled());
        MasterDetailsRidgetTest.assertFalse((boolean)ridget.isApplyRequiresNoMandatories());
        MasterDetailsRidgetTest.assertTrue((boolean)applyButton.isEnabled());
    }

    public void testApplyTriggersNew() {
        MasterDetailsRidget ridget = this.getRidget();
        MasterDetailsRidgetTest.assertFalse((boolean)ridget.isApplyTriggersNew());
        ridget.setApplyTriggersNew(true);
        MasterDetailsRidgetTest.assertTrue((boolean)ridget.isApplyTriggersNew());
        ridget.setApplyTriggersNew(false);
        MasterDetailsRidgetTest.assertFalse((boolean)ridget.isApplyTriggersNew());
    }

    public void testApplyTriggersNewWhenNewButtonDoesNotExist() {
        boolean isTesting = RienaStatus.isTest();
        System.setProperty("riena.test", "false");
        try {
            IMasterDetailsRidget ridget = (IMasterDetailsRidget)this.createRidget();
            ridget.setUIControl((Object)new MDWidget((Composite)this.getShell(), 0){

                public Button createButtonNew(Composite parent) {
                    return null;
                }
            });
            ridget.setApplyTriggersNew(true);
            MasterDetailsRidgetTest.assertFalse((boolean)ridget.isApplyTriggersNew());
        }
        finally {
            System.setProperty("riena.test", String.valueOf(isTesting));
        }
    }

    private void assertContent(Table table, int items) {
        int i = 0;
        while (i < items) {
            String label0 = String.format("TestR%dC1", i);
            String label1 = String.format("TestR%dC2", i);
            MasterDetailsRidgetTest.assertEquals((String)label0, (String)table.getItem(i).getText(0));
            MasterDetailsRidgetTest.assertEquals((String)label1, (String)table.getItem(i).getText(1));
            ++i;
        }
        MasterDetailsRidgetTest.assertEquals((int)items, (int)table.getItemCount());
    }

    private void assertPropertyChangeEvent(int count, Object oldValue, Object newValue, FTPropertyChangeListener listener) {
        MasterDetailsRidgetTest.assertEquals((int)count, (int)listener.count);
        MasterDetailsRidgetTest.assertEquals((String)"selection", (String)listener.event.getPropertyName());
        MasterDetailsRidgetTest.assertEquals((Object)oldValue, (Object)listener.event.getOldValue());
        MasterDetailsRidgetTest.assertEquals((Object)newValue, (Object)listener.event.getNewValue());
    }

    private void bindToModel(boolean withUpdate) {
        WritableList list = new WritableList(this.input, MDBean.class);
        this.getRidget().bindToModel((IObservableList)list, MDBean.class, this.columnProperties, this.columnHeaders);
        if (withUpdate) {
            this.getRidget().updateFromModel();
        }
    }

    private void bindUIControl(IMasterDetailsRidget ridget, MasterDetailsComposite control) {
        ridget.setUIControl((Object)control);
        BINDING_MAN.bind((IRidgetContainer)ridget, control.getUIControls());
    }

    private List<MDBean> createInput(int numItems) {
        ArrayList<MDBean> result = new ArrayList<MDBean>();
        int i = 0;
        while (i < numItems) {
            String c1 = String.format("TestR%dC1", i);
            String c2 = String.format("TestR%dC2", i);
            result.add(new MDBean(c1, c2));
            ++i;
        }
        return result;
    }

    private Event createSelectionEvent(MDWidget widget, Object first) {
        Event result = new Event();
        result.type = 13;
        widget.setData(first);
        result.item = widget;
        return result;
    }

    private void unbindUIControl(IMasterDetailsRidget ridget, MasterDetailsComposite control) {
        ridget.setUIControl(null);
        BINDING_MAN.unbind((IRidgetContainer)ridget, control.getUIControls());
    }

    private static final class FTPropertyChangeListener
    implements PropertyChangeListener {
        private int count;
        private PropertyChangeEvent event;

        private FTPropertyChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent event) {
            ++this.count;
            this.event = event;
        }
    }

    private static final class MDBean
    extends AbstractBean {
        private static final String PROPERTY_COLUMN_1 = "column1";
        private static final String PROPERTY_COLUMN_2 = "column2";
        private String column1;
        private String column2;

        MDBean(String column1, String column2) {
            this.column1 = column1;
            this.column2 = column2;
        }

        public String getColumn1() {
            return this.column1;
        }

        public String getColumn2() {
            return this.column2;
        }

        public void setColumn1(String column1) {
            this.column1 = column1;
            this.firePropertyChanged(PROPERTY_COLUMN_1, this.column1, this.column1);
        }

        public void setColumn2(String column2) {
            this.column2 = column2;
            this.firePropertyChanged(PROPERTY_COLUMN_2, this.column2, this.column2);
        }

        public String toString() {
            return String.format("[%s, %s]", this.column1, this.column2);
        }
    }

    private static final class MDDelegate
    extends AbstractMasterDetailsDelegate {
        private final MDBean workingCopy = this.createWorkingCopy();
        private boolean isTxtColumn1IsEnabled = true;
        private int createCount;
        private int removeCount;
        private int applyCount;
        private int prepareCount;
        private int selectionCount;
        private Object lastItem;
        private ITextRidget txtColumn1;
        private ITextRidget txtColumn2;
        private String validationResult;

        private MDDelegate() {
        }

        public void configureRidgets(IRidgetContainer container) {
            this.checkContainer(container);
            this.txtColumn1 = (ITextRidget)container.getRidget("txtColumn1");
            this.txtColumn1.bindToModel((Object)this.workingCopy, "column1");
            this.txtColumn1.updateFromModel();
            this.txtColumn2 = (ITextRidget)container.getRidget("txtColumn2");
            this.txtColumn2.bindToModel((Object)this.workingCopy, "column2");
            this.txtColumn2.updateFromModel();
        }

        public Object copyBean(Object source, Object target) {
            MDBean from = source == null ? this.createWorkingCopy() : (MDBean)((Object)source);
            MDBean to = target == null ? this.createWorkingCopy() : (MDBean)((Object)target);
            to.setColumn1(from.getColumn1());
            to.setColumn2(from.getColumn2());
            return to;
        }

        public MDBean createWorkingCopy() {
            return new MDBean("", "");
        }

        public MDBean getWorkingCopy() {
            return this.workingCopy;
        }

        public String isValid(IRidgetContainer container) {
            this.checkContainer(container);
            return this.validationResult;
        }

        public void updateDetails(IRidgetContainer container) {
            this.checkContainer(container);
            ITextRidget txtCol1 = (ITextRidget)container.getRidget("txtColumn1");
            txtCol1.setEnabled(this.isTxtColumn1IsEnabled);
            for (IRidget ridget : container.getRidgets()) {
                ridget.updateFromModel();
            }
        }

        public void itemApplied(Object changedItem) {
            ++this.applyCount;
            this.lastItem = changedItem;
        }

        public void itemCreated(Object newItem) {
            ++this.createCount;
            this.lastItem = newItem;
        }

        public void itemRemoved(Object oldItem) {
            ++this.removeCount;
            this.lastItem = oldItem;
        }

        public void prepareItemSelected(Object newSelection) {
            ++this.prepareCount;
            this.lastItem = newSelection;
        }

        public void itemSelected(Object newSelection) {
            ++this.selectionCount;
            this.lastItem = newSelection;
        }

        private void checkContainer(IRidgetContainer container) {
            MasterDetailsRidgetTest.assertNotNull((Object)container.getRidget("txtColumn1"));
            MasterDetailsRidgetTest.assertNotNull((Object)container.getRidget("txtColumn2"));
            MasterDetailsRidgetTest.assertEquals((int)2, (int)container.getRidgets().size());
        }
    }

    private static class MDWidget
    extends MasterDetailsComposite {
        private Text txtColumn1;
        private Text txtColumn2;

        public MDWidget(Composite parent, int style) {
            super(parent, style, 1024);
        }

        protected void createDetails(Composite parent) {
            GridLayoutFactory.fillDefaults().numColumns(1).applyTo(parent);
            GridDataFactory hFill = GridDataFactory.fillDefaults().grab(true, false);
            this.txtColumn1 = UIControlsFactory.createText((Composite)parent);
            hFill.applyTo((Control)this.txtColumn1);
            this.addUIControl(this.txtColumn1, "txtColumn1");
            this.txtColumn2 = UIControlsFactory.createText((Composite)parent);
            hFill.applyTo((Control)this.txtColumn2);
            this.addUIControl(this.txtColumn2, "txtColumn2");
        }

        public boolean confirmDiscardChanges() {
            return true;
        }
    }
}

