/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.ui.ridgets.swt;

import junit.framework.TestCase;
import org.eclipse.riena.core.util.ReflectionUtils;
import org.eclipse.riena.internal.core.test.collect.UITestCase;
import org.eclipse.riena.internal.ui.ridgets.swt.ToolItemProperties;
import org.eclipse.riena.internal.ui.ridgets.swt.ToolItemRidget;
import org.eclipse.riena.ui.swt.utils.SWTBindingPropertyLocator;
import org.eclipse.riena.ui.swt.utils.SwtUtilities;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;

@UITestCase
public class ToolItemPropertiesTest
extends TestCase {
    private Shell shell;

    protected void setUp() throws Exception {
        this.shell = new Shell();
    }

    protected void tearDown() throws Exception {
        SwtUtilities.disposeWidget((Widget)this.shell);
    }

    public void testToolItemProperties() {
        ToolItemRidget ridget = new ToolItemRidget();
        ToolBar toolbar = new ToolBar((Composite)this.shell, 2048);
        ToolItem item = new ToolItem(toolbar, 8);
        SWTBindingPropertyLocator.getInstance().setBindingProperty((Object)item, "item1");
        ridget.setUIControl((Object)item);
        MyToolItemProperties itemProperties = new MyToolItemProperties(ridget);
        ToolBar parent = (ToolBar)ReflectionUtils.getHidden((Object)((Object)itemProperties), (String)"parent");
        ToolItemPropertiesTest.assertSame((Object)ridget, (Object)itemProperties.getRidget());
        ToolItemPropertiesTest.assertSame((Object)toolbar, (Object)parent);
        int index = (Integer)ReflectionUtils.invokeHidden((Object)((Object)itemProperties), (String)"getIndex", (Object[])new Object[0]);
        ToolItemPropertiesTest.assertEquals((int)0, (int)index);
    }

    public void testCreateItem() {
        ToolItemRidget ridget = new ToolItemRidget();
        ToolBar toolbar = new ToolBar((Composite)this.shell, 2048);
        ToolItem item = new ToolItem(toolbar, 8);
        String text = "toolItem0815";
        item.setText(text);
        ridget.setUIControl((Object)item);
        MyToolItemProperties itemProperties = new MyToolItemProperties(ridget);
        item.dispose();
        ToolItemPropertiesTest.assertEquals((int)0, (int)toolbar.getItemCount());
        ToolItem item2 = itemProperties.createItem();
        ToolItemPropertiesTest.assertSame((Object)item2, (Object)ridget.getUIControl());
        ToolItemPropertiesTest.assertSame((Object)toolbar, (Object)item2.getParent());
        ToolItemPropertiesTest.assertEquals((int)1, (int)toolbar.getItemCount());
        ToolItemPropertiesTest.assertEquals((String)text, (String)item2.getText());
    }

    private static class MyToolItemProperties
    extends ToolItemProperties {
        public MyToolItemProperties(ToolItemRidget ridget) {
            super(ridget);
        }

        public ToolItem createItem() {
            return super.createItem();
        }

        public ToolItemRidget getRidget() {
            return super.getRidget();
        }
    }
}

