/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.navigation.ui.swt.lnf.renderer;

import junit.framework.TestCase;
import org.eclipse.riena.core.util.ReflectionUtils;
import org.eclipse.riena.internal.core.test.collect.UITestCase;
import org.eclipse.riena.internal.ui.swt.Activator;
import org.eclipse.riena.navigation.ui.swt.lnf.renderer.SubApplicationTabRenderer;
import org.eclipse.riena.ui.swt.lnf.LnfManager;
import org.eclipse.riena.ui.swt.lnf.rienadefault.RienaDefaultLnf;
import org.eclipse.riena.ui.swt.utils.SwtUtilities;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

@UITestCase
public class SubApplicationTabRendererTest
extends TestCase {
    private Shell shell;
    private GC gc;
    private RienaDefaultLnf originalLnf;
    private MyLnf lnf;

    protected void setUp() throws Exception {
        super.setUp();
        if (Activator.getDefault() == null) {
            SubApplicationTabRendererTest.fail((String)"This test only runs correct as JUnit Plug-in Test!");
        }
        this.shell = new Shell();
        this.gc = new GC((Drawable)this.shell);
        this.lnf = new MyLnf();
        this.originalLnf = LnfManager.getLnf();
        LnfManager.setLnf((RienaDefaultLnf)this.lnf);
        LnfManager.getLnf().initialize();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.gc.dispose();
        this.gc = null;
        SwtUtilities.disposeWidget((Widget)this.shell);
        this.lnf.uninitialize();
        this.lnf = null;
        LnfManager.setLnf((RienaDefaultLnf)this.originalLnf);
    }

    public void testGetImageTextWidth() {
        SubApplicationTabRenderer renderer = new SubApplicationTabRenderer();
        renderer.setLabel("Hello &World!");
        int widthWithoutMnemonic = (Integer)ReflectionUtils.invokeHidden((Object)renderer, (String)"getImageTextWidth", (Object[])new Object[]{this.gc});
        renderer.setLabel("Hello World!");
        int widthWithMnemonic = (Integer)ReflectionUtils.invokeHidden((Object)renderer, (String)"getImageTextWidth", (Object[])new Object[]{this.gc});
        SubApplicationTabRendererTest.assertEquals((int)widthWithoutMnemonic, (int)widthWithMnemonic);
        renderer.setIcon(null);
        int widthWithoutIcon = (Integer)ReflectionUtils.invokeHidden((Object)renderer, (String)"getImageTextWidth", (Object[])new Object[]{this.gc});
        renderer.setIcon("eclipse.gif");
        int widthWithIcon = (Integer)ReflectionUtils.invokeHidden((Object)renderer, (String)"getImageTextWidth", (Object[])new Object[]{this.gc});
        SubApplicationTabRendererTest.assertEquals((int)widthWithoutIcon, (int)widthWithIcon);
        this.lnf.setShowIcon(true);
        widthWithIcon = (Integer)ReflectionUtils.invokeHidden((Object)renderer, (String)"getImageTextWidth", (Object[])new Object[]{this.gc});
        SubApplicationTabRendererTest.assertTrue((widthWithoutIcon < widthWithIcon ? 1 : 0) != 0);
    }

    private class MyLnf
    extends RienaDefaultLnf {
        private MyLnf() {
        }

        public void setShowIcon(boolean show) {
            this.putLnfSetting("SubApplicationSwitcher.tabShowIcon", show);
        }
    }
}

