/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.core.uiprocess;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.ProgressProvider;
import org.eclipse.riena.ui.core.uiprocess.IProgressVisualizerLocator;
import org.eclipse.riena.ui.core.uiprocess.UICallbackDispatcher;
import org.eclipse.riena.ui.core.uiprocess.UIProcess;

public class ProgressProviderBridge
extends ProgressProvider {
    private static ProgressProviderBridge instance;
    private IProgressVisualizerLocator visualizerLocator;
    private Map<Job, UIProcess> jobUiProcess = Collections.synchronizedMap(new HashMap());

    public static ProgressProviderBridge instance() {
        if (instance == null) {
            instance = new ProgressProviderBridge();
        }
        return instance;
    }

    public void setVisualizerFactory(IProgressVisualizerLocator visualizerLocator) {
        this.visualizerLocator = visualizerLocator;
    }

    public IProgressMonitor createMonitor(Job job) {
        ProgressProvider provider = this.queryProgressProvider(job);
        return provider.createMonitor(job);
    }

    private ProgressProvider queryProgressProvider(Job job) {
        UIProcess uiprocess = this.jobUiProcess.get(job);
        Object context = this.getContext(job);
        if (uiprocess == null) {
            uiprocess = this.createDefaultUIProcess(job);
        }
        UICallbackDispatcher dispatcher = (UICallbackDispatcher)uiprocess.getAdapter(UICallbackDispatcher.class);
        dispatcher.addUIMonitor(this.visualizerLocator.getProgressVisualizer(context));
        return dispatcher;
    }

    private Object getContext(Job job) {
        return job.getProperty(UIProcess.PROPERTY_CONTEXT);
    }

    private UIProcess createDefaultUIProcess(Job job) {
        return new UIProcess(job);
    }

    public void registerMapping(Job job, UIProcess process) {
        this.jobUiProcess.put(job, process);
    }

    public void unregisterMapping(Job job) {
        this.jobUiProcess.remove(job);
    }
}

