/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.ui.ridgets.swt;

import java.math.BigDecimal;
import org.eclipse.core.databinding.beans.BeansObservables;
import org.eclipse.core.databinding.beans.PojoObservables;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.runtime.Assert;
import org.eclipse.riena.core.util.StringUtils;
import org.eclipse.riena.internal.ui.ridgets.swt.NumericTextRidget;
import org.eclipse.riena.ui.ridgets.IDecimalTextRidget;
import org.eclipse.riena.ui.ridgets.ValueBindingSupport;
import org.eclipse.riena.ui.ridgets.swt.AbstractSWTRidget;

public class DecimalTextRidget
extends NumericTextRidget
implements IDecimalTextRidget {
    public DecimalTextRidget() {
        this.setMaxLength(10);
        this.setPrecision(2);
        this.setText("0");
        this.setSigned(true);
    }

    protected void checkNumber(String number) {
        if (!"".equals(number)) {
            BigDecimal value = this.checkIsNumber(number);
            this.checkSigned(value);
            this.checkMaxLength(number);
            this.checkPrecision(number);
        }
    }

    protected final String getTextBasedOnMarkerState(String value) {
        if (this.isOutputOnly() && !this.isNotEmpty(value)) {
            return "";
        }
        return super.getTextBasedOnMarkerState(value);
    }

    protected boolean isNegative(String text) {
        BigDecimal value = new BigDecimal(this.localStringToBigDecimal(text));
        return value.compareTo(BigDecimal.ZERO) < 0;
    }

    protected boolean isNotEmpty(String text) {
        String stripped = DecimalTextRidget.removeLeadingCruft(DecimalTextRidget.removeTrailingPadding(text));
        return stripped.length() > 0;
    }

    public void bindToModel(IObservableValue observableValue) {
        super.bindToModel(observableValue);
        this.updateConverter(this.getPrecision());
    }

    public void bindToModel(Object valueHolder, String valuePropertyName) {
        if (AbstractSWTRidget.isBean(valueHolder.getClass())) {
            this.bindToModel(BeansObservables.observeValue((Object)valueHolder, (String)valuePropertyName));
        } else {
            this.bindToModel(PojoObservables.observeValue((Object)valueHolder, (String)valuePropertyName));
        }
    }

    public synchronized int getPrecision() {
        return super.getPrecision();
    }

    public final synchronized void setPrecision(int numberOfFractionDigits) {
        Assert.isLegal((numberOfFractionDigits > -1 ? 1 : 0) != 0, (String)("numberOfFractionDigits must > -1: " + numberOfFractionDigits));
        int oldValue = this.getPrecision();
        if (oldValue != numberOfFractionDigits) {
            this.updateConverter(numberOfFractionDigits);
            super.setPrecision(numberOfFractionDigits);
            this.firePropertyChange("precision", oldValue, numberOfFractionDigits);
        }
    }

    private BigDecimal checkIsNumber(String number) {
        try {
            return new BigDecimal(this.localStringToBigDecimal(number));
        }
        catch (NumberFormatException numberFormatException) {
            throw new NumberFormatException("Not a valid decimal: " + number);
        }
    }

    private void checkMaxLength(String number) {
        int length;
        int maxLength = this.getMaxLength();
        int decSepIndex = number.indexOf(DECIMAL_SEPARATOR);
        if (decSepIndex != -1) {
            String decimalPart = number.substring(0, decSepIndex);
            length = decimalPart.length() - StringUtils.count((String)decimalPart, (char)GROUPING_SEPARATOR);
        } else {
            length = number.length() - StringUtils.count((String)number, (char)GROUPING_SEPARATOR);
        }
        if (number.length() > 0 && number.charAt(0) == MINUS_SIGN) {
            --length;
        }
        if (maxLength < length) {
            String msg = String.format("Length (%d) exceeded: %s", maxLength, number);
            throw new NumberFormatException(msg);
        }
    }

    private void checkPrecision(String number) {
        int fractionalDigits;
        int precision;
        int decSepIndex = number.indexOf(DECIMAL_SEPARATOR);
        if (decSepIndex != -1 && (precision = this.getPrecision()) < (fractionalDigits = number.substring(decSepIndex).length() - 1)) {
            String msg = String.format("Precision (%d) exceeded: %s", precision, number);
            throw new NumberFormatException(msg);
        }
    }

    private void checkSigned(BigDecimal value) {
        if (!this.isSigned() && value.compareTo(BigDecimal.ZERO) == -1) {
            throw new NumberFormatException("Negative numbers not allowed: " + value);
        }
    }

    private String localStringToBigDecimal(String number) {
        return DecimalTextRidget.ungroup(number).replace(DECIMAL_SEPARATOR, '.');
    }

    private void updateConverter(int precision) {
        ValueBindingSupport vbs = this.getValueBindingSupport();
        if (vbs.getModelObservable() != null) {
            Class type = (Class)vbs.getModelObservable().getValueType();
            IConverter converter = this.getConverter(type, precision);
            vbs.setModelToUIControlConverter(converter);
            vbs.rebindToModel();
        }
    }
}

