/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.ridgets.swt;

import java.beans.PropertyChangeSupport;
import org.eclipse.riena.ui.ridgets.IBasicMarkableRidget;
import org.eclipse.riena.ui.ridgets.swt.MarkerSupport;
import org.eclipse.riena.ui.swt.BorderControlDecoration;
import org.eclipse.riena.ui.swt.lnf.LnfManager;
import org.eclipse.riena.ui.swt.lnf.rienadefault.RienaDefaultLnf;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Control;

public class BorderMarkerSupport
extends MarkerSupport {
    private BorderControlDecoration errorDecoration;

    public BorderMarkerSupport() {
    }

    public BorderMarkerSupport(IBasicMarkableRidget ridget, PropertyChangeSupport propertyChangeSupport) {
        super(ridget, propertyChangeSupport);
    }

    protected void addError(Control control) {
        if (this.errorDecoration == null) {
            this.errorDecoration = this.createErrorDecoration(control);
            control.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    BorderMarkerSupport.this.errorDecoration.dispose();
                }
            });
        }
        this.errorDecoration.show();
    }

    protected void clearError(Control control) {
        if (this.errorDecoration != null) {
            this.errorDecoration.hide();
        }
    }

    protected BorderControlDecoration createErrorDecoration(Control control) {
        RienaDefaultLnf lnf = LnfManager.getLnf();
        int width = lnf.getIntegerSetting("errorMarker.borderWidth", Integer.valueOf(1));
        Color borderColor = lnf.getColor("errorMarker.borderColor");
        BorderControlDecoration ctrlDecoration = new BorderControlDecoration(control, width, borderColor);
        return ctrlDecoration;
    }
}

