/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.ridgets.swt.views;

import org.eclipse.riena.ui.ridgets.controller.AbstractWindowController;
import org.eclipse.riena.ui.ridgets.swt.views.AbstractControlledView;
import org.eclipse.riena.ui.swt.RienaDialog;
import org.eclipse.riena.ui.swt.lnf.LnFUpdater;
import org.eclipse.riena.ui.swt.utils.SWTControlFinder;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public abstract class DialogView
extends RienaDialog {
    private static final LnFUpdater LNF_UPDATER = new LnFUpdater();
    private boolean closing;
    private AbstractControlledView<AbstractWindowController> controlledViewDelegate = new AbstractControlledView<AbstractWindowController>(){};
    private Shell parentShell;

    public DialogView(Composite parent) {
        super(parent != null ? parent.getShell() : Display.getDefault().getActiveShell());
        this.controlledViewDelegate.setController(this.createController());
        this.closing = false;
        if (parent != null) {
            this.parentShell = parent.getShell();
        }
    }

    private void addUIControls(Composite composite) {
        SWTControlFinder finder = new SWTControlFinder(composite){

            public void handleBoundControl(Control control, String bindingProperty) {
                DialogView.this.addUIControl(control, bindingProperty);
            }
        };
        finder.run();
    }

    public AbstractWindowController getController() {
        return this.controlledViewDelegate.getController();
    }

    public void addUIControl(Object uiControl, String ridgetId) {
        this.controlledViewDelegate.addUIControl(uiControl, ridgetId);
    }

    private void bindController() {
        this.controlledViewDelegate.initialize(this.getController());
        this.controlledViewDelegate.bind(this.getController());
    }

    protected Control buildView(Composite parent) {
        return parent;
    }

    protected abstract AbstractWindowController createController();

    public void build() {
        this.open();
    }

    protected Shell getParentShell() {
        return this.parentShell;
    }

    protected void onClose() {
    }

    public boolean close() {
        this.closing = true;
        this.onClose();
        this.controlledViewDelegate.unbind(this.getController());
        boolean result = super.close();
        this.closing = false;
        return result;
    }

    public void create() {
        super.create();
        this.addUIControls((Composite)this.getShell());
        this.bindController();
        LNF_UPDATER.updateUIControls((Composite)this.getShell(), true);
        this.getShell().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (!DialogView.this.closing) {
                    DialogView.this.close();
                }
            }
        });
    }

    protected Control createDialogArea(Composite parent) {
        Control dlgContente = this.buildView(parent);
        this.addUIControl(this.getShell(), "windowRidget");
        LNF_UPDATER.updateUIControls(parent, true);
        return dlgContente;
    }
}

