/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.ridgets.uibinding;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.riena.core.wire.InjectExtension;
import org.eclipse.riena.ui.ridgets.ILabelRidget;
import org.eclipse.riena.ui.ridgets.IRidget;
import org.eclipse.riena.ui.ridgets.IRidgetContainer;
import org.eclipse.riena.ui.ridgets.uibinding.ICorrespondingLabelExtension;
import org.eclipse.riena.ui.ridgets.uibinding.ILabelFinderStrategy;
import org.eclipse.riena.ui.ridgets.uibinding.ILabelFinderStrategyExtension;

public class CorrespondingLabelMapper {
    private static final String DEFAULT_LABEL_PREFIX = "label";
    private static final ILabelFinderStrategy DEFAULT_LABEL_FINDER_STRATEGY = new DefaultLabelFinderStrategy();
    private final IRidgetContainer ridgetContainer;
    private static String labelPrefix = "label";
    private static ILabelFinderStrategy labelFinderStrategy = DEFAULT_LABEL_FINDER_STRATEGY;

    public CorrespondingLabelMapper(IRidgetContainer ridgetContainer) {
        this.ridgetContainer = ridgetContainer;
    }

    @InjectExtension(min=0, max=1)
    public static void setCorrespondingLabelConfig(ICorrespondingLabelExtension labelProperties) {
        if (labelProperties != null && labelProperties.getLabelPrefix() != null) {
            labelPrefix = labelProperties.getLabelPrefix();
            return;
        }
        labelPrefix = DEFAULT_LABEL_PREFIX;
    }

    @InjectExtension(min=0, max=1)
    public static void setLabelFinderStrategy(ILabelFinderStrategyExtension strategyProperties) {
        ILabelFinderStrategy customLabelFinderStrategy;
        if (strategyProperties != null && (customLabelFinderStrategy = strategyProperties.createFinderStrategy()) != null) {
            labelFinderStrategy = customLabelFinderStrategy;
            return;
        }
        labelFinderStrategy = DEFAULT_LABEL_FINDER_STRATEGY;
    }

    public boolean connectCorrespondingLabel(final IRidget ridget, String ridgetId) {
        final ILabelRidget labelRidget = labelFinderStrategy.findLabelRidget(this.ridgetContainer, ridgetId);
        if (labelRidget == null) {
            return false;
        }
        ridget.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if ("enabled".equals(evt.getPropertyName())) {
                    labelRidget.setEnabled(ridget.isEnabled());
                }
            }
        });
        return true;
    }

    private static class DefaultLabelFinderStrategy
    implements ILabelFinderStrategy {
        private DefaultLabelFinderStrategy() {
        }

        public ILabelRidget findLabelRidget(IRidgetContainer iridgetContainer, String ridgetID) {
            String labelID = String.valueOf(labelPrefix) + ridgetID;
            IRidget labelRidget = iridgetContainer.getRidget(labelID);
            if (labelRidget != null && labelRidget instanceof ILabelRidget) {
                return (ILabelRidget)labelRidget;
            }
            return null;
        }
    }
}

