/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.ridgets.validation;

import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.osgi.util.NLS;
import org.eclipse.riena.core.util.PropertiesUtils;
import org.eclipse.riena.ui.ridgets.nls.Messages;
import org.eclipse.riena.ui.ridgets.validation.ValidationFailure;
import org.eclipse.riena.ui.ridgets.validation.ValidationRuleStatus;

public class MaxLength
implements IValidator,
IExecutableExtension {
    protected int maxLength;
    private boolean isBlocking;

    public MaxLength() {
        this(0, true);
    }

    public MaxLength(int length) {
        this(length, true);
    }

    protected MaxLength(int length, boolean isBlocking) {
        this.maxLength = length;
        this.isBlocking = isBlocking;
    }

    public IStatus validate(Object value) {
        if (value == null || this.maxLength < 0) {
            return ValidationRuleStatus.ok();
        }
        if (value instanceof String) {
            String string = (String)value;
            int length = string.length();
            if (length > this.maxLength) {
                String message = NLS.bind((String)Messages.MaxLength_error_tooLong, (Object)string, (Object)this.maxLength);
                return ValidationRuleStatus.error(this.isBlocking, message);
            }
            return ValidationRuleStatus.ok();
        }
        throw new ValidationFailure("MaxLength can only validate objects of type String.");
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder(this.getClass().getSimpleName());
        buffer.append("[maxLength=");
        buffer.append(this.maxLength);
        buffer.append("]");
        return buffer.toString();
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        if (data instanceof String) {
            String[] args = PropertiesUtils.asArray((Object)data);
            this.maxLength = Integer.parseInt(args[0]);
        }
    }
}

