/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.ridgets.validation;

import org.apache.oro.text.perl.Perl5Util;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.osgi.util.NLS;
import org.eclipse.riena.core.util.PropertiesUtils;
import org.eclipse.riena.ui.ridgets.nls.Messages;
import org.eclipse.riena.ui.ridgets.validation.ValidationFailure;
import org.eclipse.riena.ui.ridgets.validation.ValidationRuleStatus;

public class ValidExpression
implements IValidator,
IExecutableExtension {
    public static final String GERMAN_ZIP = "^[0-9]{5}$";
    public static final String SWIFT_BIC = "^([a-zA-Z]{6}[a-zA-Z\\d]{2})([a-zA-Z\\d]{3})?$";
    private final Perl5Util matcher = new Perl5Util();
    private String pattern;
    private final StringBuffer options;

    public ValidExpression() {
        this("*", new Option[0]);
    }

    public ValidExpression(String pattern, Option ... options) {
        Assert.isNotNull((Object)pattern, (String)"pattern must not be null");
        Assert.isLegal((pattern.length() > 0 ? 1 : 0) != 0, (String)"pattern must not be empty");
        this.pattern = pattern;
        this.options = new StringBuffer(4);
        Option[] optionArray = options;
        int n = options.length;
        int n2 = 0;
        while (n2 < n) {
            Option option = optionArray[n2];
            this.options.append(option.symbol);
            ++n2;
        }
    }

    public IStatus validate(Object value) {
        String string;
        if (value != null && !(value instanceof String)) {
            throw new ValidationFailure(String.valueOf(this.getClass().getSimpleName()) + " can only validate objects of type " + String.class.getName());
        }
        String string2 = string = value == null ? "" : (String)value;
        if (this.matcher.match("/" + this.pattern + "/" + this.options, string)) {
            return ValidationRuleStatus.ok();
        }
        String message = NLS.bind((String)Messages.ValidExpression_error_noMatch, (Object)string, (Object)this.pattern);
        return ValidationRuleStatus.error(false, message);
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        if (data instanceof String) {
            String[] args = PropertiesUtils.asArray((Object)data);
            this.pattern = args[0];
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Option {
        CASE_INSENSITIVE('i'),
        MULTIPLE_LINE('m'),
        ENABLE_EXTENDED_SYNTAX('x');

        private final char symbol;

        private Option(char symbol) {
            this.symbol = symbol;
        }
    }
}

