/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.communication.core.registry;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.equinox.log.Logger;
import org.eclipse.riena.communication.core.IRemoteServiceReference;
import org.eclipse.riena.communication.core.IRemoteServiceRegistration;
import org.eclipse.riena.communication.core.IRemoteServiceRegistry;
import org.eclipse.riena.communication.core.factory.ProxyAlreadyRegisteredFailure;
import org.eclipse.riena.core.IRienaActivator;
import org.eclipse.riena.core.Log4r;
import org.eclipse.riena.internal.communication.core.Activator;
import org.eclipse.riena.internal.communication.core.registry.RemoteServiceRegistration;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceRegistration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteServiceRegistry
implements IRemoteServiceRegistry {
    private volatile Map<String, IRemoteServiceRegistration> registeredServices;
    private static final Logger LOGGER = Log4r.getLogger((IRienaActivator)Activator.getDefault(), RemoteServiceRegistry.class);

    public synchronized void start() {
        this.registeredServices = Collections.synchronizedMap(new HashMap());
    }

    public synchronized void stop() {
        Map<String, IRemoteServiceRegistration> tempRegisteredServices = this.registeredServices;
        this.registeredServices = null;
        for (Map.Entry<String, IRemoteServiceRegistration> entry : tempRegisteredServices.entrySet()) {
            this.unregisterService(entry.getValue().getReference());
        }
    }

    @Override
    public IRemoteServiceRegistration registerService(IRemoteServiceReference reference, BundleContext context) {
        final String url = reference.getDescription().getURL();
        IRemoteServiceRegistration foundRemoteServiceReg = this.getRegisteredServices().get(url);
        if (foundRemoteServiceReg != null) {
            throw new ProxyAlreadyRegisteredFailure("Cannot register two remote service proxies with the same URL. Proxy for " + url + " already exists. Registered by bundle " + foundRemoteServiceReg.getReference().getContext().getBundle().getSymbolicName() + ".");
        }
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put("service.url", url);
        ((Dictionary)props).put("service.protocol", reference.getDescription().getProtocol());
        ServiceRegistration serviceRegistration = context.registerService(reference.getServiceInterfaceClassName(), reference.getServiceInstance(), props);
        try {
            Activator.getDefault().getContext().addServiceListener(new ServiceListener(){

                public void serviceChanged(ServiceEvent event) {
                    if (event.getType() == 4) {
                        RemoteServiceRegistry.this.getRegisteredServices().remove(url);
                        Activator.getDefault().getContext().removeServiceListener((ServiceListener)this);
                    }
                }
            }, "(service.id=" + serviceRegistration.getReference().getProperty("service.id") + ")");
        }
        catch (InvalidSyntaxException e) {
            LOGGER.log(2, "Filter is unexpectedly wrong.", (Throwable)e);
        }
        reference.setContext(context);
        reference.setServiceRegistration(serviceRegistration);
        RemoteServiceRegistration remoteServiceReg = new RemoteServiceRegistration(reference, this);
        this.registeredServices.put(url, remoteServiceReg);
        LOGGER.log(4, "OSGi NEW service registered id: " + reference.getServiceInterfaceClassName());
        return remoteServiceReg;
    }

    @Override
    public void unregisterService(IRemoteServiceReference reference) {
        Assert.isNotNull((Object)reference, (String)"RemoteServiceReference must not be null");
        this.getRegisteredServices().remove(reference.getURL());
        reference.getServiceRegistration().unregister();
        String serviceClassName = reference.getServiceInterfaceClassName();
        reference.dispose();
        LOGGER.log(4, "OSGi service removed: " + serviceClassName);
    }

    @Override
    public List<IRemoteServiceRegistration> registeredServices(BundleContext context) {
        ArrayList<IRemoteServiceRegistration> result = new ArrayList<IRemoteServiceRegistration>();
        ArrayList<IRemoteServiceRegistration> all = new ArrayList<IRemoteServiceRegistration>(this.getRegisteredServices().values());
        for (IRemoteServiceRegistration remoteServiceRegistration : all) {
            if (context != null && !context.equals(remoteServiceRegistration.getReference().getContext())) continue;
            result.add(remoteServiceRegistration);
        }
        return result;
    }

    public boolean hasServiceForUrl(String url) {
        return this.getRegisteredServices().get(url) != null;
    }

    private Map<String, IRemoteServiceRegistration> getRegisteredServices() {
        Map<String, IRemoteServiceRegistration> temp = this.registeredServices;
        if (temp == null) {
            throw new IllegalStateException("RemoteServiceRegistry is either not started or already stopped!");
        }
        return temp;
    }
}

