/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.example.client.controllers;

import java.net.URL;
import javax.security.auth.login.LoginException;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.security.auth.ILoginContext;
import org.eclipse.equinox.security.auth.LoginContextFactory;
import org.eclipse.riena.core.util.StringUtils;
import org.eclipse.riena.internal.example.client.Activator;
import org.eclipse.riena.internal.example.client.security.authentication.LocalLoginCallbackHandler;
import org.eclipse.riena.navigation.ui.application.AbstractApplication;
import org.eclipse.riena.ui.ridgets.IActionListener;
import org.eclipse.riena.ui.ridgets.IActionRidget;
import org.eclipse.riena.ui.ridgets.IMessageBoxRidget;
import org.eclipse.riena.ui.ridgets.IRidget;
import org.eclipse.riena.ui.ridgets.ITextRidget;
import org.eclipse.riena.ui.ridgets.controller.AbstractWindowController;

public class LoginDialogController
extends AbstractWindowController {
    public static final String RIDGET_ID_USER = "user";
    public static final String RIDGET_ID_PASSWORD = "password";
    public static final String RIDGET_ID_OK = "okButton";
    public static final String RIDGET_ID_CANCEL = "cancelButton";
    public static final String RIDGET_ID_MESSAGE_LOGIN_EXCEPTION = "messageLoginException";
    public static final int EXIT_OK = IApplication.EXIT_OK;
    public static final int EXIT_ABORT = AbstractApplication.EXIT_ABORT;
    private static final String JAAS_CONFIG_FILE = "config/sample_jaas.config";
    private boolean canLogin;

    public void afterBind() {
        super.afterBind();
        this.getRidget(RIDGET_ID_USER).requestFocus();
    }

    public void configureRidgets() {
        super.configureRidgets();
        this.getWindowRidget().setTitle("Riena login");
        this.getWindowRidget().setIcon("sample.gif");
        final ITextRidget user = (ITextRidget)this.getRidget(RIDGET_ID_USER);
        user.setMandatory(true);
        ITextRidget password = (ITextRidget)this.getRidget(RIDGET_ID_PASSWORD);
        password.setMandatory(true);
        IActionRidget okAction = (IActionRidget)this.getRidget(RIDGET_ID_OK);
        okAction.addListener(new IActionListener(){

            public void callback() {
                LoginDialogController.this.canLogin = LoginDialogController.this.checkLogin();
                if (LoginDialogController.this.canLogin) {
                    LoginDialogController.this.dispose(EXIT_OK);
                } else {
                    user.requestFocus();
                }
            }
        });
        this.addDefaultAction((IRidget)this.getWindowRidget(), okAction);
        IActionRidget cancelAction = (IActionRidget)this.getRidget(RIDGET_ID_CANCEL);
        cancelAction.addListener(new IActionListener(){

            public void callback() {
                LoginDialogController.this.dispose(EXIT_ABORT);
            }
        });
    }

    public void onClose() {
        this.setReturnCode(this.canLogin ? EXIT_OK : EXIT_ABORT);
    }

    private boolean checkLogin() {
        String userId = ((ITextRidget)this.getRidget(RIDGET_ID_USER)).getText();
        String password = ((ITextRidget)this.getRidget(RIDGET_ID_PASSWORD)).getText();
        if (StringUtils.isEmpty((CharSequence)userId) && StringUtils.isEmpty((CharSequence)password)) {
            return true;
        }
        LocalLoginCallbackHandler.setSuppliedCredentials(((ITextRidget)this.getRidget(RIDGET_ID_USER)).getText(), ((ITextRidget)this.getRidget(RIDGET_ID_PASSWORD)).getText());
        URL configUrl = Activator.getDefault().getContext().getBundle().getEntry(JAAS_CONFIG_FILE);
        ILoginContext secureContext = LoginContextFactory.createContext((String)"Remote", (URL)configUrl);
        try {
            secureContext.login();
            return true;
        }
        catch (LoginException e) {
            this.showMessage(e);
            return false;
        }
    }

    private void dispose(int result) {
        this.getWindowRidget().dispose();
        this.setReturnCode(result);
    }

    private void showMessage(LoginException e) {
        IMessageBoxRidget messageLoginException = (IMessageBoxRidget)this.getRidget(RIDGET_ID_MESSAGE_LOGIN_EXCEPTION);
        messageLoginException.setType(IMessageBoxRidget.Type.ERROR);
        messageLoginException.setTitle("Login exception");
        messageLoginException.setText(e.getMessage());
        messageLoginException.show();
    }
}

