/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.communication.core.attachment;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.security.SecureRandom;
import org.eclipse.riena.communication.core.IRemoteServiceRegistration;
import org.eclipse.riena.communication.core.RemoteFailure;
import org.eclipse.riena.communication.core.attachment.Attachment;
import org.eclipse.riena.communication.core.attachment.AttachmentSerialized;
import org.eclipse.riena.communication.core.attachment.ByteArrayDataSource;
import org.eclipse.riena.communication.core.factory.Register;
import org.eclipse.riena.core.util.Nop;
import org.eclipse.riena.core.util.ReflectionUtils;
import org.eclipse.riena.internal.core.test.RienaTestCase;
import org.eclipse.riena.internal.core.test.collect.ManualTestCase;
import org.eclipse.riena.internal.tests.Activator;
import org.eclipse.riena.sample.app.common.attachment.IAttachmentService;

@ManualTestCase
public final class AttachmentClientITest
extends RienaTestCase {
    private static final String STRING1 = "das sind testdaten, die wir mal einfach so verschicken um et+das sind testdaten, die wir mal einfach so verschicken um et";
    private static final String STRING2 = "first+das sind testdaten, die wir mal einfach so verschicken um et+second+das sind testdaten, die wir mal einfach so verschicken um et+third+2";
    private static final String TESTDATA1 = "das sind testdaten, die wir mal einfach so verschicken um etwas zu testen.";
    private static final String TESTDATA2 = "das sind testdaten, die wir mal einfach so verschicken um etwas zu testen. (2.test)";
    private IAttachmentService attachService;
    private IRemoteServiceRegistration regAttachmentService;
    private static final int ATTACHMENT_START = 60;

    public void setUp() throws Exception {
        super.setUp();
        this.regAttachmentService = Register.remoteProxy(IAttachmentService.class).usingUrl("http://localhost:8080/hessian/AttachmentService").withProtocol("hessian").andStart(Activator.getDefault().getContext());
        this.attachService = (IAttachmentService)Activator.getDefault().getContext().getService(Activator.getDefault().getContext().getServiceReference(IAttachmentService.class.getName()));
    }

    public void tearDown() throws Exception {
        this.regAttachmentService.unregister();
        this.attachService = null;
        super.tearDown();
    }

    public void testSendSimpleFile() throws IOException {
        Attachment attachment = new Attachment(this.setupTestFile(TESTDATA1));
        String str = this.attachService.sendSingleAttachment(attachment);
        AttachmentClientITest.assertTrue((String)"expecting a certain string", (str != null && str.equals("das sind testdaten, die wir mal einfach so verschicken um et") ? 1 : 0) != 0);
        this.trace("testSendSimpleFile " + str);
    }

    public void testSendTwoFiles() throws IOException {
        Attachment attachment2;
        Attachment attachment = new Attachment(this.setupTestFile(TESTDATA1));
        String str = this.attachService.sendTwoAttachments(attachment, attachment2 = new Attachment(this.setupTestFile(TESTDATA2)));
        AttachmentClientITest.assertTrue((String)"expecting a certain string", (str != null && str.equals(STRING1) ? 1 : 0) != 0);
        this.trace("testSendTwoFiles " + str);
    }

    public void testSendFileAndData() throws IOException {
        Attachment attachment2;
        Attachment attachment = new Attachment(this.setupTestFile(TESTDATA1));
        String str = this.attachService.sendAttachmentsAndData("first", attachment, "second", attachment2 = new Attachment(this.setupTestFile(TESTDATA2)), "third", 2);
        AttachmentClientITest.assertTrue((String)"expecting a certain string", (str != null && str.equals(STRING2) ? 1 : 0) != 0);
        this.trace("testSendFileAndData " + str);
    }

    public void testReturn() throws IOException {
        Attachment attachment = this.attachService.returnAttachment();
        this.trace("testReturn as String " + this.readAttachmentStart(attachment));
    }

    public void testReturnOnRequest() throws IOException {
        Attachment attachment = this.attachService.returnAttachmentForRequest("validfilename");
        this.trace("testReturn as String " + this.readAttachmentStart(attachment));
    }

    public void testReturnOnRequestInvalidFile() throws IOException {
        try {
            this.attachService.returnAttachmentForRequest("invalidfilename");
            AttachmentClientITest.fail((String)"the requested file does not exist and the webservice should throw an exception");
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    public void testSendAndReturn() throws IOException {
        Attachment attachment = new Attachment(this.setupTestFile(TESTDATA1));
        Attachment attachment2 = this.attachService.sendAndReturnAttachment(attachment);
        this.trace("testReturn as String " + this.readAttachmentStart(attachment2));
        AttachmentClientITest.assertEquals((String)"The webservice echos the request, how the result is not the same as it was sent in the request.", (String)this.readAttachmentStart(attachment), (String)this.readAttachmentStart(attachment2));
    }

    public void testReadFileAsInputStream() throws Exception {
        InputStream input = this.attachService.getFile();
        byte[] b = new byte[50];
        int rc = input.read(b);
        while (rc != -1) {
            String s = new String(b, 0, rc);
            this.trace(s);
            rc = input.read(b);
        }
    }

    public void testReadInputWithError() throws Exception {
        try {
            Attachment attachment = this.attachService.getBytesFromSampleWithError();
            attachment.readAsStream();
            AttachmentClientITest.fail();
        }
        catch (RemoteFailure remoteFailure) {
            this.ok();
        }
    }

    public void testReadUrlWithErrorAtStart() throws Exception {
        try {
            Attachment attachment = this.attachService.getBytesFromUrlWithErrorAtStart();
            String output = this.readAttachmentStart(attachment);
            this.trace(output);
            AttachmentClientITest.fail();
        }
        catch (RuntimeException runtimeException) {
            this.ok();
        }
    }

    public void testReadUrlWithError() throws Exception {
        Attachment attachment = this.attachService.getBytesFromUrlWithError();
        String output = this.readAttachmentStart(attachment);
        this.trace(output);
    }

    public void testReadUrlWithoutError() throws Exception {
        Attachment attachment = this.attachService.getBytesFromUrlWithoutError();
        String output = this.readAttachmentStart(attachment);
        this.trace(output);
    }

    private String readAttachmentStart(Attachment attachment) {
        byte[] byteArray = new byte[60];
        try {
            InputStream input = attachment.readAsStream();
            int nbrBytes = input.read(byteArray, 0, byteArray.length);
            if (nbrBytes < 1) {
                throw new IOException("Empty Attachment.");
            }
            return new String(byteArray, 0, nbrBytes);
        }
        catch (IOException iOException) {
            return "[can't read " + attachment + "]";
        }
    }

    public void testReadAttachmentCreatedWithInvalidUrl() throws Exception {
        try {
            Attachment attachment = this.attachService.getBytesFromInvalidUrl();
            this.trace(attachment);
            AttachmentClientITest.fail();
        }
        catch (IOException iOException) {
            this.ok();
        }
    }

    public void testSendAndDeleteFile() throws IOException {
        File file = new File("/testattachments.txt");
        OutputStream out = null;
        try {
            out = new FileOutputStream(file);
            int i = 0;
            while (i < 200) {
                out.write(i);
                ++i;
            }
        }
        finally {
            out.close();
        }
        boolean deleted = file.delete();
        AttachmentClientITest.assertTrue((boolean)deleted);
        AttachmentClientITest.assertFalse((String)"file must be deleted by now", (boolean)file.exists());
    }

    public void testRetrieveAttachmentAsObject() throws IOException {
        Object a = this.attachService.getAttachmentAsObject();
        AttachmentClientITest.assertTrue((boolean)(a instanceof Attachment));
    }

    public void testEmptyAttachment() throws Exception {
        Attachment attachment = this.attachService.getEmptyAttachment();
        InputStream input = attachment.readAsStream();
        AttachmentClientITest.assertTrue((input != null ? 1 : 0) != 0);
        AttachmentClientITest.assertTrue((input.read() == -1 ? 1 : 0) != 0);
    }

    public void testSendLargeAttachments() throws Exception {
        System.out.println("generating 15 Mio bytes attachment");
        Attachment attachment = this.generateLargeAttachment(15000000);
        System.out.println("sending it");
        int i = this.attachService.sendAttachmentAndReturnSize(attachment);
        System.out.println("done");
        AttachmentClientITest.assertTrue((i == 15000000 ? 1 : 0) != 0);
    }

    public void testSendFileAndTestIfItIsClosed() throws Exception {
        File file = File.createTempFile("attachTest", null);
        PrintWriter printWriter = new PrintWriter(new FileOutputStream(file));
        printWriter.write("This text file is accessed in AttachmentTest to test the Attachment class.");
        printWriter.close();
        Attachment attach = new Attachment(file);
        AttachmentClientITest.assertTrue((boolean)file.exists());
        AttachmentSerialized attach2 = (AttachmentSerialized)attach.writeReplace();
        ByteArrayDataSource byteArray = (ByteArrayDataSource)ReflectionUtils.getHidden((Object)attach2, (String)"internalDataSource");
        InputStream inputStream = byteArray.getInputStream();
        while (inputStream.read() != -1) {
            Nop.reason((String)"nothing to do");
        }
        inputStream.close();
        AttachmentClientITest.assertTrue((boolean)file.exists());
        AttachmentClientITest.assertTrue((boolean)file.delete());
        AttachmentClientITest.assertFalse((boolean)file.exists());
    }

    private Attachment generateLargeAttachment(int countInBytes) throws IOException {
        return new Attachment(new InputStream(countInBytes){
            private int count;
            private final SecureRandom random;
            {
                this.count = n;
                this.random = new SecureRandom();
            }

            public int read() throws IOException {
                --this.count;
                if (this.count >= 0) {
                    return this.random.nextInt();
                }
                return -1;
            }
        });
    }

    private File setupTestFile(String string) {
        try {
            File file = File.createTempFile("attachTest", null);
            PrintWriter printWriter = new PrintWriter(new FileOutputStream(file));
            printWriter.write(string);
            printWriter.close();
            return file;
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    private void trace(Object object) {
        System.out.println(object.toString());
    }
}

