/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.communication.core.progressmonitor;

import java.io.IOException;
import java.io.InputStream;
import java.security.SecureRandom;
import org.eclipse.riena.communication.core.IRemoteServiceRegistration;
import org.eclipse.riena.communication.core.attachment.Attachment;
import org.eclipse.riena.communication.core.factory.Register;
import org.eclipse.riena.communication.core.progressmonitor.IRemoteProgressMonitor;
import org.eclipse.riena.communication.core.progressmonitor.IRemoteProgressMonitorRegistry;
import org.eclipse.riena.communication.core.progressmonitor.RemoteProgressMonitorEvent;
import org.eclipse.riena.internal.core.test.RienaTestCase;
import org.eclipse.riena.internal.core.test.collect.ManualTestCase;
import org.eclipse.riena.internal.tests.Activator;
import org.eclipse.riena.sample.app.common.attachment.IAttachmentService;
import org.osgi.framework.BundleContext;

@ManualTestCase
public final class RemoteProgressMonitorITest
extends RienaTestCase {
    private IAttachmentService attachService;
    private IRemoteServiceRegistration regAttachmentService;
    private IRemoteProgressMonitorRegistry registry;

    public void setUp() throws Exception {
        super.setUp();
        this.regAttachmentService = Register.remoteProxy(IAttachmentService.class).usingUrl("http://localhost:8080/hessian/AttachmentService").withProtocol("hessian").andStart(Activator.getDefault().getContext());
        this.attachService = (IAttachmentService)Activator.getDefault().getContext().getService(Activator.getDefault().getContext().getServiceReference(IAttachmentService.class.getName()));
        BundleContext context = Activator.getDefault().getContext();
        this.registry = (IRemoteProgressMonitorRegistry)context.getService(context.getServiceReference(IRemoteProgressMonitorRegistry.class.getName()));
    }

    public void tearDown() throws Exception {
        super.tearDown();
        this.regAttachmentService.unregister();
        this.attachService = null;
    }

    public void testSendSimpleAttachmentProgress() throws Exception {
        TestProgressMonitor monitor = new TestProgressMonitor();
        this.registry.addProgressMonitor((Object)this.attachService, (IRemoteProgressMonitor)monitor, IRemoteProgressMonitorRegistry.RemovalPolicy.AFTER_ONE_CALL);
        Attachment attachment = this.generateLargeAttachment(15000);
        int i = this.attachService.sendAttachmentAndReturnSize(attachment);
        RemoteProgressMonitorITest.assertTrue((i == 15000 ? 1 : 0) != 0);
        monitor.validate(30, 1);
        this.registry.removeAllProgressMonitors((Object)this.attachService);
    }

    public void testSendLargeAttachmentProgress() throws Exception {
        TestProgressMonitor monitor = new TestProgressMonitor();
        this.registry.addProgressMonitor((Object)this.attachService, (IRemoteProgressMonitor)monitor, IRemoteProgressMonitorRegistry.RemovalPolicy.AFTER_ONE_CALL);
        Attachment attachment = this.generateLargeAttachment(15000000);
        int i = this.attachService.sendAttachmentAndReturnSize(attachment);
        RemoteProgressMonitorITest.assertTrue((i == 15000000 ? 1 : 0) != 0);
        monitor.validate(29297, 1);
        this.registry.removeAllProgressMonitors((Object)this.attachService);
    }

    public void testReceiveSimpleAttachmentProgress() throws Exception {
        TestProgressMonitor monitor = new TestProgressMonitor();
        this.registry.addProgressMonitor((Object)this.attachService, (IRemoteProgressMonitor)monitor, IRemoteProgressMonitorRegistry.RemovalPolicy.AFTER_ONE_CALL);
        Attachment attachment = this.attachService.returnAttachmentForSize(15000);
        int i = this.getSize(attachment);
        RemoteProgressMonitorITest.assertTrue((i == 15000 ? 1 : 0) != 0);
        monitor.validate(1, i / 512 + 1);
        this.registry.removeAllProgressMonitors((Object)this.attachService);
    }

    public void testReceiveLargeAttachmentProgress() throws Exception {
        TestProgressMonitor monitor = new TestProgressMonitor();
        this.registry.addProgressMonitor((Object)this.attachService, (IRemoteProgressMonitor)monitor, IRemoteProgressMonitorRegistry.RemovalPolicy.AFTER_ONE_CALL);
        Attachment attachment = this.attachService.returnAttachmentForSize(15000000);
        int i = this.getSize(attachment);
        RemoteProgressMonitorITest.assertTrue((i == 15000000 ? 1 : 0) != 0);
        monitor.validate(1, i / 512 + 1);
        this.registry.removeAllProgressMonitors((Object)this.attachService);
    }

    private int getSize(Attachment attachment) throws IOException {
        InputStream input = attachment.readAsStream();
        int count = 0;
        while (input.read() != -1) {
            ++count;
        }
        return count;
    }

    private Attachment generateLargeAttachment(int countInBytes) throws IOException {
        return new Attachment(new InputStream(countInBytes){
            private int count;
            private final SecureRandom random;
            {
                this.count = n;
                this.random = new SecureRandom();
            }

            public int read() throws IOException {
                --this.count;
                if (this.count >= 0) {
                    return this.random.nextInt();
                }
                return -1;
            }
        });
    }

    private static final class TestProgressMonitor
    implements IRemoteProgressMonitor {
        private boolean start = false;
        private boolean end = false;
        private int requestCount = 0;
        private int responseCount = 0;
        private int lastResponseLength = -1;
        private boolean requestDivideable = true;
        private boolean responseDividable = true;

        private TestProgressMonitor() {
        }

        public void validate(int requests, int responses) {
            RemoteProgressMonitorITest.assertTrue((String)"start method not called", (boolean)this.start);
            RemoteProgressMonitorITest.assertTrue((String)"end method not called", (boolean)this.end);
            if (requests != -1) {
                RemoteProgressMonitorITest.assertTrue((String)("expected " + requests + " but was " + this.requestCount + " for number of requestEvents"), (requests <= this.requestCount ? 1 : 0) != 0);
            }
            if (responses != -1) {
                RemoteProgressMonitorITest.assertTrue((String)("expected " + responses + " but was " + this.responseCount + " for number of responseEvents"), (responses <= this.responseCount ? 1 : 0) != 0);
            }
        }

        public void request(RemoteProgressMonitorEvent event) {
            System.out.println(event.getBytesProcessed());
            if (event.getBytesProcessed() % 512 != 0) {
                if (this.requestDivideable) {
                    this.requestDivideable = false;
                } else {
                    RemoteProgressMonitorITest.assertTrue((String)("expected bytesProcess in request to be always dividable by 512 (expect in the last call) :" + event.getBytesProcessed()), (event.getBytesProcessed() % 512 == 0 ? 1 : 0) != 0);
                }
            }
            ++this.requestCount;
        }

        public void response(RemoteProgressMonitorEvent event) {
            System.out.println(event.getBytesProcessed());
            if (event.getBytesProcessed() % 512 != 0) {
                if (this.responseDividable) {
                    this.responseDividable = false;
                } else {
                    RemoteProgressMonitorITest.assertTrue((String)("expected bytesProcess in response to be always dividable by 512 (expect in the last call) :" + event.getBytesProcessed()), (event.getBytesProcessed() % 512 == 0 ? 1 : 0) != 0);
                }
            }
            ++this.responseCount;
            this.lastResponseLength = event.getBytesProcessed();
        }

        public void start() {
            RemoteProgressMonitorITest.assertFalse((boolean)this.start);
            System.out.println("start");
            this.start = true;
        }

        public void end() {
            RemoteProgressMonitorITest.assertFalse((boolean)this.end);
            System.out.println("end");
            this.end = true;
        }
    }
}

