/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.navigation.ui.swt.views;

import org.eclipse.riena.core.util.ReflectionUtils;
import org.eclipse.riena.internal.core.test.RienaTestCase;
import org.eclipse.riena.internal.core.test.collect.UITestCase;
import org.eclipse.riena.navigation.INavigationNode;
import org.eclipse.riena.navigation.NavigationNodeId;
import org.eclipse.riena.navigation.model.ModuleNode;
import org.eclipse.riena.navigation.model.SubModuleNode;
import org.eclipse.riena.navigation.ui.swt.views.ModuleNavigationListener;
import org.eclipse.riena.ui.swt.utils.SwtUtilities;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

@UITestCase
public class ModuleNavigationListenerTest
extends RienaTestCase {
    private Tree tree;
    private ModuleNavigationListener listener;

    protected void setUp() throws Exception {
        super.setUp();
        this.tree = new Tree((Composite)new Shell(Display.getDefault()), 0);
        this.listener = new ModuleNavigationListener(this.tree);
    }

    protected void tearDown() throws Exception {
        this.listener = null;
        SwtUtilities.dispose((Widget)this.tree);
        super.tearDown();
    }

    public void testIsSelectable() throws Exception {
        TreeItem item = new TreeItem(this.tree, 0);
        SubModuleNode s1 = new SubModuleNode("s1");
        item.setData((Object)s1);
        ModuleNavigationListenerTest.assertTrue((boolean)ModuleNavigationListenerTest.invokeIsSelectable(this.listener, item));
        s1.setSelectable(false);
        ModuleNavigationListenerTest.assertFalse((boolean)ModuleNavigationListenerTest.invokeIsSelectable(this.listener, item));
        SubModuleNode s2 = new SubModuleNode("s2");
        s1.addChild((INavigationNode)s2);
        ModuleNavigationListenerTest.assertTrue((boolean)ModuleNavigationListenerTest.invokeIsSelectable(this.listener, item));
    }

    public void testFindItem() throws Exception {
        TreeItem item1 = new TreeItem(this.tree, 0);
        SubModuleNode s1 = new SubModuleNode("s1");
        item1.setData((Object)s1);
        TreeItem foundItem = (TreeItem)ReflectionUtils.invokeHidden((Object)this.listener, (String)"findItem", (Object[])new Object[]{this.tree.getItems(), s1});
        ModuleNavigationListenerTest.assertSame((Object)item1, (Object)foundItem);
        SubModuleNode s2 = new SubModuleNode("s2");
        foundItem = (TreeItem)ReflectionUtils.invokeHidden((Object)this.listener, (String)"findItem", (Object[])new Object[]{this.tree.getItems(), s2});
        ModuleNavigationListenerTest.assertNull((Object)foundItem);
        s1.addChild((INavigationNode)s2);
        foundItem = (TreeItem)ReflectionUtils.invokeHidden((Object)this.listener, (String)"findItem", (Object[])new Object[]{this.tree.getItems(), s2});
        ModuleNavigationListenerTest.assertNull((Object)foundItem);
        TreeItem item2 = new TreeItem(item1, 0);
        item2.setData((Object)s2);
        foundItem = (TreeItem)ReflectionUtils.invokeHidden((Object)this.listener, (String)"findItem", (Object[])new Object[]{this.tree.getItems(), s2});
        ModuleNavigationListenerTest.assertSame((Object)item2, (Object)foundItem);
    }

    public void testActivateNode() throws Exception {
        ModuleNode m = new ModuleNode();
        TreeItem item1 = new TreeItem(this.tree, 0);
        SubModuleNode s1 = new SubModuleNode(new NavigationNodeId("s1"), "s1");
        m.addChild((INavigationNode)s1);
        item1.setData((Object)s1);
        TreeItem item2 = new TreeItem(this.tree, 0);
        SubModuleNode s2 = new SubModuleNode(new NavigationNodeId("s2"), "s2");
        m.addChild((INavigationNode)s2);
        item2.setData((Object)s2);
        TreeItem item3 = new TreeItem(this.tree, 0);
        SubModuleNode s3 = new SubModuleNode(new NavigationNodeId("s3"), "s3");
        m.addChild((INavigationNode)s3);
        s3.setSelectable(false);
        item3.setData((Object)s3);
        this.tree.select(item2);
        ReflectionUtils.invokeHidden((Object)this.listener, (String)"activateNode", (Object[])new Object[]{s2, this.tree});
        ModuleNavigationListenerTest.assertTrue((boolean)s2.isActivated());
        ModuleNavigationListenerTest.assertSame((Object)item2, (Object)this.tree.getSelection()[0]);
        this.tree.select(item3);
        ReflectionUtils.invokeHidden((Object)this.listener, (String)"activateNode", (Object[])new Object[]{s3, this.tree});
        ModuleNavigationListenerTest.assertFalse((boolean)s3.isActivated());
        ModuleNavigationListenerTest.assertSame((Object)item2, (Object)this.tree.getSelection()[0]);
        this.tree.select(item1);
        ReflectionUtils.invokeHidden((Object)this.listener, (String)"activateNode", (Object[])new Object[]{s1, this.tree});
        ModuleNavigationListenerTest.assertTrue((boolean)s1.isActivated());
        ModuleNavigationListenerTest.assertSame((Object)item1, (Object)this.tree.getSelection()[0]);
    }

    private static Boolean invokeIsSelectable(ModuleNavigationListener listener, TreeItem item) {
        return (Boolean)ReflectionUtils.invokeHidden((Object)listener, (String)"isSelectable", (Object[])new Object[]{item});
    }
}

