/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.core.marker;

import org.eclipse.riena.core.marker.AbstractMarker;
import org.eclipse.riena.ui.core.marker.IIconizableMarker;

public class UIProcessFinishedMarker
extends AbstractMarker
implements IIconizableMarker {
    public static final String MARKER_KEY = "UIProcessFinishedMarker";
    private static final String ATTRIBUTE_FINISHED = "uiprocess.finished";
    private static final int COUNTER_MINIMUM = 0;
    private static final int COUNTER_INACTIVE = -1;
    private int counter;
    private int counterMaximum;
    private boolean on;

    public UIProcessFinishedMarker() {
        this(10);
    }

    public UIProcessFinishedMarker(int counterMaximum) {
        this.setCounterMaximum(counterMaximum);
        this.counter = -1;
        this.on = true;
    }

    public boolean isFinished() {
        return (Boolean)this.getAttribute(ATTRIBUTE_FINISHED);
    }

    public void setFinished(boolean finished) {
        this.setAttribute(ATTRIBUTE_FINISHED, finished);
    }

    public String getIconConfigurationKey() {
        return MARKER_KEY;
    }

    public IIconizableMarker.MarkerPosition getPositionOfMarker() {
        return IIconizableMarker.MarkerPosition.TOP_LEFT;
    }

    public void setOn(boolean on) {
        this.on = on;
    }

    public boolean isOn() {
        if (this.counter >= this.getCounterMaximum()) {
            this.setOn(true);
        }
        return this.on;
    }

    public boolean isFlashing() {
        return this.counter >= 0 && this.counter < this.getCounterMaximum();
    }

    public void setCounterMaximum(int counterMaximum) {
        this.counterMaximum = counterMaximum;
    }

    public int getCounterMaximum() {
        return this.counterMaximum;
    }

    public void increase() {
        if (this.isFlashing()) {
            ++this.counter;
        }
    }

    public void activate() {
        this.counter = 0;
    }

    public boolean isActivated() {
        return this.counter != -1;
    }

    public int getTimeOn() {
        return 400;
    }

    public int getTimeOff() {
        return 400;
    }

    public boolean isVisible() {
        return true;
    }
}

