/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.ui.ridgets.swt;

import org.eclipse.core.runtime.Assert;
import org.eclipse.riena.internal.ui.ridgets.swt.AbstractTraverseRidget;
import org.eclipse.riena.ui.ridgets.IStatusMeterRidget;
import org.eclipse.riena.ui.ridgets.swt.AbstractSWTRidget;
import org.eclipse.riena.ui.swt.StatusMeterWidget;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Control;

public class StatusMeterRidget
extends AbstractTraverseRidget
implements IStatusMeterRidget {
    private static final String COLOR_WARNING = "Parameter color is not an instance of 'org.eclipse.swt.graphics.Color'";
    private boolean initialized;
    private boolean maxInitialized;
    private boolean minInitialized;
    private Color borderColor;
    private Color backgroundColor;
    private Color gradientStartColor;
    private Color gradientEndColor;

    public StatusMeterWidget getUIControl() {
        return (StatusMeterWidget)super.getUIControl();
    }

    public void checkUIControl(Object uiControl) {
        AbstractSWTRidget.assertType(uiControl, StatusMeterWidget.class);
    }

    protected int getValue(Control control) {
        return this.getUIControl() != null ? this.getUIControl().getValue() : 0;
    }

    protected void initFromUIControl() {
        StatusMeterWidget meter = this.getUIControl();
        if (meter != null && !this.initialized) {
            if (!this.maxInitialized) {
                this.setMaximum(meter.getMaximum());
            }
            if (!this.minInitialized) {
                this.setMinimum(meter.getMinimum());
            }
            this.setValue(meter.getValue());
            this.initialized = true;
        }
    }

    protected void updateUIMaximum() {
        StatusMeterWidget control = this.getUIControl();
        if (control != null) {
            control.setMaximum(this.getMaximum());
        }
    }

    protected void updateUIMinimum() {
        StatusMeterWidget control = this.getUIControl();
        if (control != null) {
            control.setMinimum(this.getMinimum());
        }
    }

    protected void updateUIValue() {
        StatusMeterWidget control = this.getUIControl();
        if (control != null) {
            control.setValue(this.getValue());
        }
    }

    public void setMaximum(int maximum) {
        super.setMaximum(maximum);
        this.maxInitialized = true;
    }

    public void setMinimum(int minimum) {
        super.setMinimum(minimum);
        this.minInitialized = true;
    }

    protected void updateUIControl() {
        super.updateUIControl();
        StatusMeterWidget control = this.getUIControl();
        if (control == null) {
            return;
        }
        if (this.borderColor != null) {
            control.setBorderColor(this.borderColor);
        }
        if (this.backgroundColor != null) {
            control.setBackgroundColor(this.backgroundColor);
        }
        if (this.gradientStartColor != null) {
            control.setGradientStartColor(this.gradientStartColor);
        }
        if (this.gradientEndColor != null) {
            control.setGradientEndColor(this.gradientEndColor);
        }
    }

    public void setBorderColor(Object color) {
        Assert.isTrue((boolean)(color instanceof Color), (String)COLOR_WARNING);
        this.borderColor = (Color)color;
        this.updateUIControl();
    }

    public void setBackgroundColor(Object color) {
        Assert.isTrue((boolean)(color instanceof Color), (String)COLOR_WARNING);
        this.backgroundColor = (Color)color;
        this.updateUIControl();
    }

    public void setGradientStartColor(Object color) {
        Assert.isTrue((boolean)(color instanceof Color), (String)COLOR_WARNING);
        this.gradientStartColor = (Color)color;
        this.updateUIControl();
    }

    public void setGradientEndColor(Object color) {
        Assert.isTrue((boolean)(color instanceof Color), (String)COLOR_WARNING);
        this.gradientEndColor = (Color)color;
        this.updateUIControl();
    }

    protected void addSelectionListener(Control control, SelectionListener listener) {
    }

    protected void removeSelectionListener(Control control, SelectionListener listener) {
    }

    protected int getUIControlIncrement() {
        return 0;
    }

    protected int getUIControlMaximum() {
        return 0;
    }

    protected int getUIControlMinimum() {
        return 0;
    }

    protected int getUIControlPageIncrement() {
        return 0;
    }

    protected int getUIControlSelection() {
        return 0;
    }

    protected void initAdditionalsFromUIControl() {
    }

    protected void updateUIIncrement() {
    }

    protected void updateUIPageIncrement() {
    }
}

